<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for b2CCollection StructType
 * @subpackage Structs
 */
class B2CCollection extends Collection
{
    /**
     * The deliveryMessage2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $deliveryMessage2;
    /**
     * The numberParcels
     * @var int
     */
    public $numberParcels;
    /**
     * The services
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Services
     */
    public $services;
    /**
     * The warehouseNo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $warehouseNo;
    /**
     * Constructor method for b2CCollection
     * @uses B2CCollection::setDeliveryMessage2()
     * @uses B2CCollection::setNumberParcels()
     * @uses B2CCollection::setServices()
     * @uses B2CCollection::setWarehouseNo()
     * @param string $deliveryMessage2
     * @param int $numberParcels
     * @param \StructType\Services $services
     * @param string $warehouseNo
     */
    public function __construct($deliveryMessage2 = null, $numberParcels = null, \StructType\Services $services = null, $warehouseNo = null)
    {
        $this
            ->setDeliveryMessage2($deliveryMessage2)
            ->setNumberParcels($numberParcels)
            ->setServices($services)
            ->setWarehouseNo($warehouseNo);
    }
    /**
     * Get deliveryMessage2 value
     * @return string|null
     */
    public function getDeliveryMessage2()
    {
        return $this->deliveryMessage2;
    }
    /**
     * Set deliveryMessage2 value
     * @param string $deliveryMessage2
     * @return \StructType\B2CCollection
     */
    public function setDeliveryMessage2($deliveryMessage2 = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryMessage2) && !is_string($deliveryMessage2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deliveryMessage2)), __LINE__);
        }
        $this->deliveryMessage2 = $deliveryMessage2;
        return $this;
    }
    /**
     * Get numberParcels value
     * @return int|null
     */
    public function getNumberParcels()
    {
        return $this->numberParcels;
    }
    /**
     * Set numberParcels value
     * @param int $numberParcels
     * @return \StructType\B2CCollection
     */
    public function setNumberParcels($numberParcels = null)
    {
        // validation for constraint: int
        if (!is_null($numberParcels) && !is_numeric($numberParcels)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberParcels)), __LINE__);
        }
        $this->numberParcels = $numberParcels;
        return $this;
    }
    /**
     * Get services value
     * @return \StructType\Services|null
     */
    public function getServices()
    {
        return $this->services;
    }
    /**
     * Set services value
     * @param \StructType\Services $services
     * @return \StructType\B2CCollection
     */
    public function setServices(\StructType\Services $services = null)
    {
        $this->services = $services;
        return $this;
    }
    /**
     * Get warehouseNo value
     * @return string|null
     */
    public function getWarehouseNo()
    {
        return $this->warehouseNo;
    }
    /**
     * Set warehouseNo value
     * @param string $warehouseNo
     * @return \StructType\B2CCollection
     */
    public function setWarehouseNo($warehouseNo = null)
    {
        // validation for constraint: string
        if (!is_null($warehouseNo) && !is_string($warehouseNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($warehouseNo)), __LINE__);
        }
        $this->warehouseNo = $warehouseNo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\B2CCollection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
