<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Address StructType
 * @subpackage Structs
 */
class Address extends AbstractStructBase
{
    /**
     * The title
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $title;
    /**
     * The firstName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $firstName;
    /**
     * The lastName
     * @var string
     */
    public $lastName;
    /**
     * The streetName
     * @var string
     */
    public $streetName;
    /**
     * The houseNo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $houseNo;
    /**
     * The countryCode
     * @var string
     */
    public $countryCode;
    /**
     * The postcode
     * @var string
     */
    public $postcode;
    /**
     * The city
     * @var string
     */
    public $city;
    /**
     * The addressAdd1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $addressAdd1;
    /**
     * The addressAdd2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $addressAdd2;
    /**
     * The addressAdd3
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $addressAdd3;
    /**
     * The phoneNo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $phoneNo;
    /**
     * The faxNo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $faxNo;
    /**
     * The mobileNo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $mobileNo;
    /**
     * The email
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $email;
    /**
     * Constructor method for Address
     * @uses Address::setTitle()
     * @uses Address::setFirstName()
     * @uses Address::setLastName()
     * @uses Address::setStreetName()
     * @uses Address::setHouseNo()
     * @uses Address::setCountryCode()
     * @uses Address::setPostcode()
     * @uses Address::setCity()
     * @uses Address::setAddressAdd1()
     * @uses Address::setAddressAdd2()
     * @uses Address::setAddressAdd3()
     * @uses Address::setPhoneNo()
     * @uses Address::setFaxNo()
     * @uses Address::setMobileNo()
     * @uses Address::setEmail()
     * @param string $title
     * @param string $firstName
     * @param string $lastName
     * @param string $streetName
     * @param string $houseNo
     * @param string $countryCode
     * @param string $postcode
     * @param string $city
     * @param string $addressAdd1
     * @param string $addressAdd2
     * @param string $addressAdd3
     * @param string $phoneNo
     * @param string $faxNo
     * @param string $mobileNo
     * @param string $email
     */
    public function __construct($title = null, $firstName = null, $lastName = null, $streetName = null, $houseNo = null, $countryCode = null, $postcode = null, $city = null, $addressAdd1 = null, $addressAdd2 = null, $addressAdd3 = null, $phoneNo = null, $faxNo = null, $mobileNo = null, $email = null)
    {
        $this
            ->setTitle($title)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setStreetName($streetName)
            ->setHouseNo($houseNo)
            ->setCountryCode($countryCode)
            ->setPostcode($postcode)
            ->setCity($city)
            ->setAddressAdd1($addressAdd1)
            ->setAddressAdd2($addressAdd2)
            ->setAddressAdd3($addressAdd3)
            ->setPhoneNo($phoneNo)
            ->setFaxNo($faxNo)
            ->setMobileNo($mobileNo)
            ->setEmail($email);
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \StructType\Address
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get firstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->firstName;
    }
    /**
     * Set firstName value
     * @param string $firstName
     * @return \StructType\Address
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->firstName = $firstName;
        return $this;
    }
    /**
     * Get lastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->lastName;
    }
    /**
     * Set lastName value
     * @param string $lastName
     * @return \StructType\Address
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        $this->lastName = $lastName;
        return $this;
    }
    /**
     * Get streetName value
     * @return string|null
     */
    public function getStreetName()
    {
        return $this->streetName;
    }
    /**
     * Set streetName value
     * @param string $streetName
     * @return \StructType\Address
     */
    public function setStreetName($streetName = null)
    {
        // validation for constraint: string
        if (!is_null($streetName) && !is_string($streetName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($streetName)), __LINE__);
        }
        $this->streetName = $streetName;
        return $this;
    }
    /**
     * Get houseNo value
     * @return string|null
     */
    public function getHouseNo()
    {
        return $this->houseNo;
    }
    /**
     * Set houseNo value
     * @param string $houseNo
     * @return \StructType\Address
     */
    public function setHouseNo($houseNo = null)
    {
        // validation for constraint: string
        if (!is_null($houseNo) && !is_string($houseNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($houseNo)), __LINE__);
        }
        $this->houseNo = $houseNo;
        return $this;
    }
    /**
     * Get countryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->countryCode;
    }
    /**
     * Set countryCode value
     * @param string $countryCode
     * @return \StructType\Address
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryCode)), __LINE__);
        }
        $this->countryCode = $countryCode;
        return $this;
    }
    /**
     * Get postcode value
     * @return string|null
     */
    public function getPostcode()
    {
        return $this->postcode;
    }
    /**
     * Set postcode value
     * @param string $postcode
     * @return \StructType\Address
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postcode)), __LINE__);
        }
        $this->postcode = $postcode;
        return $this;
    }
    /**
     * Get city value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \StructType\Address
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get addressAdd1 value
     * @return string|null
     */
    public function getAddressAdd1()
    {
        return $this->addressAdd1;
    }
    /**
     * Set addressAdd1 value
     * @param string $addressAdd1
     * @return \StructType\Address
     */
    public function setAddressAdd1($addressAdd1 = null)
    {
        // validation for constraint: string
        if (!is_null($addressAdd1) && !is_string($addressAdd1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressAdd1)), __LINE__);
        }
        $this->addressAdd1 = $addressAdd1;
        return $this;
    }
    /**
     * Get addressAdd2 value
     * @return string|null
     */
    public function getAddressAdd2()
    {
        return $this->addressAdd2;
    }
    /**
     * Set addressAdd2 value
     * @param string $addressAdd2
     * @return \StructType\Address
     */
    public function setAddressAdd2($addressAdd2 = null)
    {
        // validation for constraint: string
        if (!is_null($addressAdd2) && !is_string($addressAdd2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressAdd2)), __LINE__);
        }
        $this->addressAdd2 = $addressAdd2;
        return $this;
    }
    /**
     * Get addressAdd3 value
     * @return string|null
     */
    public function getAddressAdd3()
    {
        return $this->addressAdd3;
    }
    /**
     * Set addressAdd3 value
     * @param string $addressAdd3
     * @return \StructType\Address
     */
    public function setAddressAdd3($addressAdd3 = null)
    {
        // validation for constraint: string
        if (!is_null($addressAdd3) && !is_string($addressAdd3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressAdd3)), __LINE__);
        }
        $this->addressAdd3 = $addressAdd3;
        return $this;
    }
    /**
     * Get phoneNo value
     * @return string|null
     */
    public function getPhoneNo()
    {
        return $this->phoneNo;
    }
    /**
     * Set phoneNo value
     * @param string $phoneNo
     * @return \StructType\Address
     */
    public function setPhoneNo($phoneNo = null)
    {
        // validation for constraint: string
        if (!is_null($phoneNo) && !is_string($phoneNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phoneNo)), __LINE__);
        }
        $this->phoneNo = $phoneNo;
        return $this;
    }
    /**
     * Get faxNo value
     * @return string|null
     */
    public function getFaxNo()
    {
        return $this->faxNo;
    }
    /**
     * Set faxNo value
     * @param string $faxNo
     * @return \StructType\Address
     */
    public function setFaxNo($faxNo = null)
    {
        // validation for constraint: string
        if (!is_null($faxNo) && !is_string($faxNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($faxNo)), __LINE__);
        }
        $this->faxNo = $faxNo;
        return $this;
    }
    /**
     * Get mobileNo value
     * @return string|null
     */
    public function getMobileNo()
    {
        return $this->mobileNo;
    }
    /**
     * Set mobileNo value
     * @param string $mobileNo
     * @return \StructType\Address
     */
    public function setMobileNo($mobileNo = null)
    {
        // validation for constraint: string
        if (!is_null($mobileNo) && !is_string($mobileNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mobileNo)), __LINE__);
        }
        $this->mobileNo = $mobileNo;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\Address
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Address
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
