<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Process ServiceType
 * @subpackage Services
 */
class Process extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named processC2CDelivery
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ProcessC2CDelivery $parameters
     * @return \StructType\ProcessC2CDeliveryResponse|bool
     */
    public function processC2CDelivery(\StructType\ProcessC2CDelivery $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->processC2CDelivery($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named processB2CDelivery
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ProcessB2CDelivery $parameters
     * @return \StructType\ProcessB2CDeliveryResponse|bool
     */
    public function processB2CDelivery(\StructType\ProcessB2CDelivery $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->processB2CDelivery($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named processC2BReturns
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ProcessC2BReturns $parameters
     * @return \StructType\ProcessC2BReturnsResponse|bool
     */
    public function processC2BReturns(\StructType\ProcessC2BReturns $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->processC2BReturns($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named processB2CCollection
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ProcessB2CCollection $parameters
     * @return \StructType\ProcessB2CCollectionResponse|bool
     */
    public function processB2CCollection(\StructType\ProcessB2CCollection $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->processB2CCollection($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ProcessB2CCollectionResponse|\StructType\ProcessB2CDeliveryResponse|\StructType\ProcessC2BReturnsResponse|\StructType\ProcessC2CDeliveryResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
