<?php

namespace EnumType;

/**
 * This class stands for userType EnumType
 * @subpackage Enumerations
 */
class UserType
{
    /**
     * Constant for value 'KAM'
     * @return string 'KAM'
     */
    const VALUE_KAM = 'KAM';
    /**
     * Constant for value 'PROPS'
     * @return string 'PROPS'
     */
    const VALUE_PROPS = 'PROPS';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_KAM
     * @uses self::VALUE_PROPS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_KAM,
            self::VALUE_PROPS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
