<?php

namespace EnumType;

/**
 * This class stands for transmissionCode EnumType
 * @subpackage Enumerations
 */
class TransmissionCode
{
    /**
     * Constant for value 'SOAP'
     * @return string 'SOAP'
     */
    const VALUE_SOAP = 'SOAP';
    /**
     * Constant for value 'FILE'
     * @return string 'FILE'
     */
    const VALUE_FILE = 'FILE';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SOAP
     * @uses self::VALUE_FILE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SOAP,
            self::VALUE_FILE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
