<?php
/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'c2COrder' => '\\StructType\\C2COrder',
            'Address' => '\\StructType\\Address',
            'c2CShipment' => '\\StructType\\C2CShipment',
            'c2CDelivery' => '\\StructType\\C2CDelivery',
            'delivery' => '\\StructType\\Delivery',
            'BaseRequest' => '\\StructType\\BaseRequest',
            'payment' => '\\StructType\\Payment',
            's2SService' => '\\StructType\\S2SService',
            'ParcelshopDelivery' => '\\StructType\\ParcelshopDelivery',
            'Services' => '\\StructType\\Services',
            'cashOnDelivery' => '\\StructType\\CashOnDelivery',
            'IdentService' => '\\StructType\\IdentService',
            'returns' => '\\StructType\\Returns',
            'c2BReturns' => '\\StructType\\C2BReturns',
            'returnsService' => '\\StructType\\ReturnsService',
            'collection' => '\\StructType\\Collection',
            'b2CCollection' => '\\StructType\\B2CCollection',
            'b2CDelivery' => '\\StructType\\B2CDelivery',
            'outputCriteria' => '\\StructType\\OutputCriteria',
            'C2CResponse' => '\\StructType\\C2CResponse',
            'BaseResponse' => '\\StructType\\BaseResponse',
            'Label' => '\\StructType\\Label',
            'ClientAddress' => '\\StructType\\ClientAddress',
            'ResponseAddress' => '\\StructType\\ResponseAddress',
            'SenderAddress' => '\\StructType\\SenderAddress',
            'DestinationAddress' => '\\StructType\\DestinationAddress',
            'Carrier' => '\\StructType\\Carrier',
            'Barcode' => '\\StructType\\Barcode',
            'ServiceDescription' => '\\StructType\\ServiceDescription',
            'Entity' => '\\StructType\\Entity',
            'erosUserError' => '\\StructType\\ErosUserError',
            'erosUserWarning' => '\\StructType\\ErosUserWarning',
            'C2BResponse' => '\\StructType\\C2BResponse',
            'B2CResponse' => '\\StructType\\B2CResponse',
            'Exception' => '\\StructType\\Exception',
            'cancelAdvice' => '\\StructType\\CancelAdvice',
            'cancelAdviceResponse' => '\\StructType\\CancelAdviceResponse',
            'CancelResponse' => '\\StructType\\CancelResponse',
            'processB2CCollection' => '\\StructType\\ProcessB2CCollection',
            'processB2CCollectionResponse' => '\\StructType\\ProcessB2CCollectionResponse',
            'reprintC2CLabel' => '\\StructType\\ReprintC2CLabel',
            'reprintC2CLabelResponse' => '\\StructType\\ReprintC2CLabelResponse',
            'callErosEvent' => '\\StructType\\CallErosEvent',
            'callErosEventResponse' => '\\StructType\\CallErosEventResponse',
            'getRoutingVersion' => '\\StructType\\GetRoutingVersion',
            'getRoutingVersionResponse' => '\\StructType\\GetRoutingVersionResponse',
            'routingVersion' => '\\StructType\\RoutingVersion',
            'ping' => '\\StructType\\Ping',
            'pingResponse' => '\\StructType\\PingResponse',
            'processB2CDelivery' => '\\StructType\\ProcessB2CDelivery',
            'processB2CDeliveryResponse' => '\\StructType\\ProcessB2CDeliveryResponse',
            'processC2BReturn' => '\\StructType\\ProcessC2BReturn',
            'processC2BReturnResponse' => '\\StructType\\ProcessC2BReturnResponse',
            'processC2CDelivery' => '\\StructType\\ProcessC2CDelivery',
            'processC2CDeliveryResponse' => '\\StructType\\ProcessC2CDeliveryResponse',
            'scannedAndShippedToCHE' => '\\StructType\\ScannedAndShippedToCHE',
            'scannedAndShippedToCHEResponse' => '\\StructType\\ScannedAndShippedToCHEResponse',
            'scannedAndShippedToCHEErrors' => '\\StructType\\ScannedAndShippedToCHEErrors',
            'processC2BReturns' => '\\StructType\\ProcessC2BReturns',
            'processC2BReturnsResponse' => '\\StructType\\ProcessC2BReturnsResponse',
        );
    }
}
