<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetHouseListChanges StructType
 * @subpackage Structs
 */
class GetHouseListChanges extends AbstractStructBase
{
    /**
     * The date_start
     * @var string
     */
    public $date_start;
    /**
     * The region_id
     * @var string
     */
    public $region_id;
    /**
     * The page_number
     * @var int
     */
    public $page_number;
    /**
     * Constructor method for GetHouseListChanges
     * @uses GetHouseListChanges::setDate_start()
     * @uses GetHouseListChanges::setRegion_id()
     * @uses GetHouseListChanges::setPage_number()
     * @param string $date_start
     * @param string $region_id
     * @param int $page_number
     */
    public function __construct($date_start = null, $region_id = null, $page_number = null)
    {
        $this
            ->setDate_start($date_start)
            ->setRegion_id($region_id)
            ->setPage_number($page_number);
    }
    /**
     * Get date_start value
     * @return string|null
     */
    public function getDate_start()
    {
        return $this->date_start;
    }
    /**
     * Set date_start value
     * @param string $date_start
     * @return \StructType\GetHouseListChanges
     */
    public function setDate_start($date_start = null)
    {
        // validation for constraint: string
        if (!is_null($date_start) && !is_string($date_start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date_start, true), gettype($date_start)), __LINE__);
        }
        $this->date_start = $date_start;
        return $this;
    }
    /**
     * Get region_id value
     * @return string|null
     */
    public function getRegion_id()
    {
        return $this->region_id;
    }
    /**
     * Set region_id value
     * @param string $region_id
     * @return \StructType\GetHouseListChanges
     */
    public function setRegion_id($region_id = null)
    {
        // validation for constraint: string
        if (!is_null($region_id) && !is_string($region_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($region_id, true), gettype($region_id)), __LINE__);
        }
        $this->region_id = $region_id;
        return $this;
    }
    /**
     * Get page_number value
     * @return int|null
     */
    public function getPage_number()
    {
        return $this->page_number;
    }
    /**
     * Set page_number value
     * @param int $page_number
     * @return \StructType\GetHouseListChanges
     */
    public function setPage_number($page_number = null)
    {
        // validation for constraint: int
        if (!is_null($page_number) && !(is_int($page_number) || ctype_digit($page_number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($page_number, true), gettype($page_number)), __LINE__);
        }
        $this->page_number = $page_number;
        return $this;
    }
}
