<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://api.reformagkh.ru/api_document_literal/wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://api.reformagkh.ru/api_document_literal/wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Login ServiceType
 */
$login = new \ServiceType\Login($options);
/**
 * Sample call for Login operation/method
 */
if ($login->Login(new \StructType\Login()) !== false) {
    print_r($login->getResult());
} else {
    print_r($login->getLastError());
}
/**
 * Samples for Logout ServiceType
 */
$logout = new \ServiceType\Logout($options);
/**
 * Sample call for Logout operation/method
 */
if ($logout->Logout(new \StructType\Logout()) !== false) {
    print_r($logout->getResult());
} else {
    print_r($logout->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetRequestList operation/method
 */
if ($get->GetRequestList(new \StructType\GetRequestList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetHouseInfo operation/method
 */
if ($get->GetHouseInfo(new \StructType\GetHouseInfo()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetHouseProfile operation/method
 */
if ($get->GetHouseProfile(new \StructType\GetHouseProfile()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetHouseProfile988 operation/method
 */
if ($get->GetHouseProfile988(new \StructType\GetHouseProfile988()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetHouseProfileSF operation/method
 */
if ($get->GetHouseProfileSF(new \StructType\GetHouseProfileSF()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetHouseProfileSF988 operation/method
 */
if ($get->GetHouseProfileSF988(new \StructType\GetHouseProfileSF988()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetHouseProfileSFActual operation/method
 */
if ($get->GetHouseProfileSFActual(new \StructType\GetHouseProfileSFActual()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetHouseProfileActual operation/method
 */
if ($get->GetHouseProfileActual(new \StructType\GetHouseProfileActual()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetHouseListChanges operation/method
 */
if ($get->GetHouseListChanges(new \StructType\GetHouseListChanges()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetOrganizationListChanges operation/method
 */
if ($get->GetOrganizationListChanges(new \StructType\GetOrganizationListChanges()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetHouseList operation/method
 */
if ($get->GetHouseList(new \StructType\GetHouseList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetHouseListByPage operation/method
 */
if ($get->GetHouseListByPage(new \StructType\GetHouseListByPage()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCompanyProfile operation/method
 */
if ($get->GetCompanyProfile(new \StructType\GetCompanyProfile()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCompanyProfile988 operation/method
 */
if ($get->GetCompanyProfile988(new \StructType\GetCompanyProfile988()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCompanyProfileSF operation/method
 */
if ($get->GetCompanyProfileSF(new \StructType\GetCompanyProfileSF()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCompanyProfileSF988 operation/method
 */
if ($get->GetCompanyProfileSF988(new \StructType\GetCompanyProfileSF988()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetReportingPeriodList operation/method
 */
if ($get->GetReportingPeriodList(new \StructType\GetReportingPeriodList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetFileByID operation/method
 */
if ($get->GetFileByID(new \StructType\GetFileByID()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Set ServiceType
 */
$set = new \ServiceType\Set($options);
/**
 * Sample call for SetRequestForSubmit operation/method
 */
if ($set->SetRequestForSubmit(new \StructType\SetRequestForSubmit()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetHouseProfile operation/method
 */
if ($set->SetHouseProfile(new \StructType\SetHouseProfile()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetHouseProfile988 operation/method
 */
if ($set->SetHouseProfile988(new \StructType\SetHouseProfile988()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetHouseLinkToOrganization operation/method
 */
if ($set->SetHouseLinkToOrganization(new \StructType\SetHouseLinkToOrganization()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetNewHouse operation/method
 */
if ($set->SetNewHouse(new \StructType\SetNewHouse()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetUnlinkFromOrganization operation/method
 */
if ($set->SetUnlinkFromOrganization(new \StructType\SetUnlinkFromOrganization()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetNewCompany operation/method
 */
if ($set->SetNewCompany(new \StructType\SetNewCompany()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetCompanyProfile operation/method
 */
if ($set->SetCompanyProfile(new \StructType\SetCompanyProfile()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetCompanyProfile988 operation/method
 */
if ($set->SetCompanyProfile988(new \StructType\SetCompanyProfile988()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetUploadFile operation/method
 */
if ($set->SetUploadFile(new \StructType\SetUploadFile()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
