<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetHouseProfile StructType
 * @subpackage Structs
 */
class SetHouseProfile extends AbstractStructBase
{
    /**
     * The house_id
     * @var int
     */
    public $house_id;
    /**
     * The reporting_period_id
     * @var int
     */
    public $reporting_period_id;
    /**
     * The data
     * @var \StructType\HouseProfileData
     */
    public $data;
    /**
     * Constructor method for SetHouseProfile
     * @uses SetHouseProfile::setHouse_id()
     * @uses SetHouseProfile::setReporting_period_id()
     * @uses SetHouseProfile::setData()
     * @param int $house_id
     * @param int $reporting_period_id
     * @param \StructType\HouseProfileData $data
     */
    public function __construct($house_id = null, $reporting_period_id = null, \StructType\HouseProfileData $data = null)
    {
        $this
            ->setHouse_id($house_id)
            ->setReporting_period_id($reporting_period_id)
            ->setData($data);
    }
    /**
     * Get house_id value
     * @return int|null
     */
    public function getHouse_id()
    {
        return $this->house_id;
    }
    /**
     * Set house_id value
     * @param int $house_id
     * @return \StructType\SetHouseProfile
     */
    public function setHouse_id($house_id = null)
    {
        // validation for constraint: int
        if (!is_null($house_id) && !(is_int($house_id) || ctype_digit($house_id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($house_id, true), gettype($house_id)), __LINE__);
        }
        $this->house_id = $house_id;
        return $this;
    }
    /**
     * Get reporting_period_id value
     * @return int|null
     */
    public function getReporting_period_id()
    {
        return $this->reporting_period_id;
    }
    /**
     * Set reporting_period_id value
     * @param int $reporting_period_id
     * @return \StructType\SetHouseProfile
     */
    public function setReporting_period_id($reporting_period_id = null)
    {
        // validation for constraint: int
        if (!is_null($reporting_period_id) && !(is_int($reporting_period_id) || ctype_digit($reporting_period_id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($reporting_period_id, true), gettype($reporting_period_id)), __LINE__);
        }
        $this->reporting_period_id = $reporting_period_id;
        return $this;
    }
    /**
     * Get data value
     * @return \StructType\HouseProfileData|null
     */
    public function getData()
    {
        return $this->data;
    }
    /**
     * Set data value
     * @param \StructType\HouseProfileData $data
     * @return \StructType\SetHouseProfile
     */
    public function setData(\StructType\HouseProfileData $data = null)
    {
        $this->data = $data;
        return $this;
    }
}
