<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HouseChangesData StructType
 * @subpackage Structs
 */
class HouseChangesData extends AbstractStructBase
{
    /**
     * The house_id
     * @var int
     */
    public $house_id;
    /**
     * The reporting_period_id
     * @var int
     */
    public $reporting_period_id;
    /**
     * The houseguid
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $houseguid;
    /**
     * The last_update
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $last_update;
    /**
     * Constructor method for HouseChangesData
     * @uses HouseChangesData::setHouse_id()
     * @uses HouseChangesData::setReporting_period_id()
     * @uses HouseChangesData::setHouseguid()
     * @uses HouseChangesData::setLast_update()
     * @param int $house_id
     * @param int $reporting_period_id
     * @param string $houseguid
     * @param string $last_update
     */
    public function __construct($house_id = null, $reporting_period_id = null, $houseguid = null, $last_update = null)
    {
        $this
            ->setHouse_id($house_id)
            ->setReporting_period_id($reporting_period_id)
            ->setHouseguid($houseguid)
            ->setLast_update($last_update);
    }
    /**
     * Get house_id value
     * @return int|null
     */
    public function getHouse_id()
    {
        return $this->house_id;
    }
    /**
     * Set house_id value
     * @param int $house_id
     * @return \StructType\HouseChangesData
     */
    public function setHouse_id($house_id = null)
    {
        // validation for constraint: int
        if (!is_null($house_id) && !(is_int($house_id) || ctype_digit($house_id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($house_id, true), gettype($house_id)), __LINE__);
        }
        $this->house_id = $house_id;
        return $this;
    }
    /**
     * Get reporting_period_id value
     * @return int|null
     */
    public function getReporting_period_id()
    {
        return $this->reporting_period_id;
    }
    /**
     * Set reporting_period_id value
     * @param int $reporting_period_id
     * @return \StructType\HouseChangesData
     */
    public function setReporting_period_id($reporting_period_id = null)
    {
        // validation for constraint: int
        if (!is_null($reporting_period_id) && !(is_int($reporting_period_id) || ctype_digit($reporting_period_id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($reporting_period_id, true), gettype($reporting_period_id)), __LINE__);
        }
        $this->reporting_period_id = $reporting_period_id;
        return $this;
    }
    /**
     * Get houseguid value
     * @return string|null
     */
    public function getHouseguid()
    {
        return $this->houseguid;
    }
    /**
     * Set houseguid value
     * @param string $houseguid
     * @return \StructType\HouseChangesData
     */
    public function setHouseguid($houseguid = null)
    {
        // validation for constraint: string
        if (!is_null($houseguid) && !is_string($houseguid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($houseguid, true), gettype($houseguid)), __LINE__);
        }
        $this->houseguid = $houseguid;
        return $this;
    }
    /**
     * Get last_update value
     * @return string|null
     */
    public function getLast_update()
    {
        return $this->last_update;
    }
    /**
     * Set last_update value
     * @param string $last_update
     * @return \StructType\HouseChangesData
     */
    public function setLast_update($last_update = null)
    {
        // validation for constraint: string
        if (!is_null($last_update) && !is_string($last_update)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($last_update, true), gettype($last_update)), __LINE__);
        }
        $this->last_update = $last_update;
        return $this;
    }
}
