<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetHouseProfileSF988Response StructType
 * @subpackage Structs
 */
class GetHouseProfileSF988Response extends AbstractStructBase
{
    /**
     * The data
     * @var \ArrayType\ArrayOfGetHouseProfileResponse
     */
    public $data;
    /**
     * The page_number
     * @var int
     */
    public $page_number;
    /**
     * The page_count
     * @var int
     */
    public $page_count;
    /**
     * The GetHouseProfileSF988Result
     * @var \StructType\GetHouseProfileSF988Response
     */
    public $GetHouseProfileSF988Result;
    /**
     * Constructor method for GetHouseProfileSF988Response
     * @uses GetHouseProfileSF988Response::setData()
     * @uses GetHouseProfileSF988Response::setPage_number()
     * @uses GetHouseProfileSF988Response::setPage_count()
     * @uses GetHouseProfileSF988Response::setGetHouseProfileSF988Result()
     * @param \ArrayType\ArrayOfGetHouseProfileResponse $data
     * @param int $page_number
     * @param int $page_count
     * @param \StructType\GetHouseProfileSF988Response $getHouseProfileSF988Result
     */
    public function __construct(\ArrayType\ArrayOfGetHouseProfileResponse $data = null, $page_number = null, $page_count = null, \StructType\GetHouseProfileSF988Response $getHouseProfileSF988Result = null)
    {
        $this
            ->setData($data)
            ->setPage_number($page_number)
            ->setPage_count($page_count)
            ->setGetHouseProfileSF988Result($getHouseProfileSF988Result);
    }
    /**
     * Get data value
     * @return \ArrayType\ArrayOfGetHouseProfileResponse|null
     */
    public function getData()
    {
        return $this->data;
    }
    /**
     * Set data value
     * @param \ArrayType\ArrayOfGetHouseProfileResponse $data
     * @return \StructType\GetHouseProfileSF988Response
     */
    public function setData(\ArrayType\ArrayOfGetHouseProfileResponse $data = null)
    {
        $this->data = $data;
        return $this;
    }
    /**
     * Get page_number value
     * @return int|null
     */
    public function getPage_number()
    {
        return $this->page_number;
    }
    /**
     * Set page_number value
     * @param int $page_number
     * @return \StructType\GetHouseProfileSF988Response
     */
    public function setPage_number($page_number = null)
    {
        // validation for constraint: int
        if (!is_null($page_number) && !(is_int($page_number) || ctype_digit($page_number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($page_number, true), gettype($page_number)), __LINE__);
        }
        $this->page_number = $page_number;
        return $this;
    }
    /**
     * Get page_count value
     * @return int|null
     */
    public function getPage_count()
    {
        return $this->page_count;
    }
    /**
     * Set page_count value
     * @param int $page_count
     * @return \StructType\GetHouseProfileSF988Response
     */
    public function setPage_count($page_count = null)
    {
        // validation for constraint: int
        if (!is_null($page_count) && !(is_int($page_count) || ctype_digit($page_count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($page_count, true), gettype($page_count)), __LINE__);
        }
        $this->page_count = $page_count;
        return $this;
    }
    /**
     * Get GetHouseProfileSF988Result value
     * @return \StructType\GetHouseProfileSF988Response|null
     */
    public function getGetHouseProfileSF988Result()
    {
        return $this->GetHouseProfileSF988Result;
    }
    /**
     * Set GetHouseProfileSF988Result value
     * @param \StructType\GetHouseProfileSF988Response $getHouseProfileSF988Result
     * @return \StructType\GetHouseProfileSF988Response
     */
    public function setGetHouseProfileSF988Result(\StructType\GetHouseProfileSF988Response $getHouseProfileSF988Result = null)
    {
        $this->GetHouseProfileSF988Result = $getHouseProfileSF988Result;
        return $this;
    }
}
