<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetHouseProfileActual StructType
 * @subpackage Structs
 */
class GetHouseProfileActual extends AbstractStructBase
{
    /**
     * The house_id
     * @var int
     */
    public $house_id;
    /**
     * The houseguid
     * @var string
     */
    public $houseguid;
    /**
     * Constructor method for GetHouseProfileActual
     * @uses GetHouseProfileActual::setHouse_id()
     * @uses GetHouseProfileActual::setHouseguid()
     * @param int $house_id
     * @param string $houseguid
     */
    public function __construct($house_id = null, $houseguid = null)
    {
        $this
            ->setHouse_id($house_id)
            ->setHouseguid($houseguid);
    }
    /**
     * Get house_id value
     * @return int|null
     */
    public function getHouse_id()
    {
        return $this->house_id;
    }
    /**
     * Set house_id value
     * @param int $house_id
     * @return \StructType\GetHouseProfileActual
     */
    public function setHouse_id($house_id = null)
    {
        // validation for constraint: int
        if (!is_null($house_id) && !(is_int($house_id) || ctype_digit($house_id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($house_id, true), gettype($house_id)), __LINE__);
        }
        $this->house_id = $house_id;
        return $this;
    }
    /**
     * Get houseguid value
     * @return string|null
     */
    public function getHouseguid()
    {
        return $this->houseguid;
    }
    /**
     * Set houseguid value
     * @param string $houseguid
     * @return \StructType\GetHouseProfileActual
     */
    public function setHouseguid($houseguid = null)
    {
        // validation for constraint: string
        if (!is_null($houseguid) && !is_string($houseguid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($houseguid, true), gettype($houseguid)), __LINE__);
        }
        $this->houseguid = $houseguid;
        return $this;
    }
}
