<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetHouseProfile988Response StructType
 * @subpackage Structs
 */
class GetHouseProfile988Response extends AbstractStructBase
{
    /**
     * The house_id
     * @var int
     */
    public $house_id;
    /**
     * The full_address
     * @var \StructType\FullAddress
     */
    public $full_address;
    /**
     * The stage
     * @var string
     */
    public $stage;
    /**
     * The inn
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $inn;
    /**
     * The last_update
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $last_update;
    /**
     * The house_profile_data
     * @var \StructType\HouseProfileData988
     */
    public $house_profile_data;
    /**
     * The files_info
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfFileInfo
     */
    public $files_info;
    /**
     * The GetHouseProfile988Result
     * @var \StructType\GetHouseProfile988Response
     */
    public $GetHouseProfile988Result;
    /**
     * Constructor method for GetHouseProfile988Response
     * @uses GetHouseProfile988Response::setHouse_id()
     * @uses GetHouseProfile988Response::setFull_address()
     * @uses GetHouseProfile988Response::setStage()
     * @uses GetHouseProfile988Response::setInn()
     * @uses GetHouseProfile988Response::setLast_update()
     * @uses GetHouseProfile988Response::setHouse_profile_data()
     * @uses GetHouseProfile988Response::setFiles_info()
     * @uses GetHouseProfile988Response::setGetHouseProfile988Result()
     * @param int $house_id
     * @param \StructType\FullAddress $full_address
     * @param string $stage
     * @param string $inn
     * @param string $last_update
     * @param \StructType\HouseProfileData988 $house_profile_data
     * @param \ArrayType\ArrayOfFileInfo $files_info
     * @param \StructType\GetHouseProfile988Response $getHouseProfile988Result
     */
    public function __construct($house_id = null, \StructType\FullAddress $full_address = null, $stage = null, $inn = null, $last_update = null, \StructType\HouseProfileData988 $house_profile_data = null, \ArrayType\ArrayOfFileInfo $files_info = null, \StructType\GetHouseProfile988Response $getHouseProfile988Result = null)
    {
        $this
            ->setHouse_id($house_id)
            ->setFull_address($full_address)
            ->setStage($stage)
            ->setInn($inn)
            ->setLast_update($last_update)
            ->setHouse_profile_data($house_profile_data)
            ->setFiles_info($files_info)
            ->setGetHouseProfile988Result($getHouseProfile988Result);
    }
    /**
     * Get house_id value
     * @return int|null
     */
    public function getHouse_id()
    {
        return $this->house_id;
    }
    /**
     * Set house_id value
     * @param int $house_id
     * @return \StructType\GetHouseProfile988Response
     */
    public function setHouse_id($house_id = null)
    {
        // validation for constraint: int
        if (!is_null($house_id) && !(is_int($house_id) || ctype_digit($house_id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($house_id, true), gettype($house_id)), __LINE__);
        }
        $this->house_id = $house_id;
        return $this;
    }
    /**
     * Get full_address value
     * @return \StructType\FullAddress|null
     */
    public function getFull_address()
    {
        return $this->full_address;
    }
    /**
     * Set full_address value
     * @param \StructType\FullAddress $full_address
     * @return \StructType\GetHouseProfile988Response
     */
    public function setFull_address(\StructType\FullAddress $full_address = null)
    {
        $this->full_address = $full_address;
        return $this;
    }
    /**
     * Get stage value
     * @return string|null
     */
    public function getStage()
    {
        return $this->stage;
    }
    /**
     * Set stage value
     * @uses \EnumType\HouseStageEnum::valueIsValid()
     * @uses \EnumType\HouseStageEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $stage
     * @return \StructType\GetHouseProfile988Response
     */
    public function setStage($stage = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\HouseStageEnum::valueIsValid($stage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\HouseStageEnum', is_array($stage) ? implode(', ', $stage) : var_export($stage, true), implode(', ', \EnumType\HouseStageEnum::getValidValues())), __LINE__);
        }
        $this->stage = $stage;
        return $this;
    }
    /**
     * Get inn value
     * @return string|null
     */
    public function getInn()
    {
        return $this->inn;
    }
    /**
     * Set inn value
     * @param string $inn
     * @return \StructType\GetHouseProfile988Response
     */
    public function setInn($inn = null)
    {
        // validation for constraint: string
        if (!is_null($inn) && !is_string($inn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inn, true), gettype($inn)), __LINE__);
        }
        $this->inn = $inn;
        return $this;
    }
    /**
     * Get last_update value
     * @return string|null
     */
    public function getLast_update()
    {
        return $this->last_update;
    }
    /**
     * Set last_update value
     * @param string $last_update
     * @return \StructType\GetHouseProfile988Response
     */
    public function setLast_update($last_update = null)
    {
        // validation for constraint: string
        if (!is_null($last_update) && !is_string($last_update)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($last_update, true), gettype($last_update)), __LINE__);
        }
        $this->last_update = $last_update;
        return $this;
    }
    /**
     * Get house_profile_data value
     * @return \StructType\HouseProfileData988|null
     */
    public function getHouse_profile_data()
    {
        return $this->house_profile_data;
    }
    /**
     * Set house_profile_data value
     * @param \StructType\HouseProfileData988 $house_profile_data
     * @return \StructType\GetHouseProfile988Response
     */
    public function setHouse_profile_data(\StructType\HouseProfileData988 $house_profile_data = null)
    {
        $this->house_profile_data = $house_profile_data;
        return $this;
    }
    /**
     * Get files_info value
     * @return \ArrayType\ArrayOfFileInfo|null
     */
    public function getFiles_info()
    {
        return $this->files_info;
    }
    /**
     * Set files_info value
     * @param \ArrayType\ArrayOfFileInfo $files_info
     * @return \StructType\GetHouseProfile988Response
     */
    public function setFiles_info(\ArrayType\ArrayOfFileInfo $files_info = null)
    {
        $this->files_info = $files_info;
        return $this;
    }
    /**
     * Get GetHouseProfile988Result value
     * @return \StructType\GetHouseProfile988Response|null
     */
    public function getGetHouseProfile988Result()
    {
        return $this->GetHouseProfile988Result;
    }
    /**
     * Set GetHouseProfile988Result value
     * @param \StructType\GetHouseProfile988Response $getHouseProfile988Result
     * @return \StructType\GetHouseProfile988Response
     */
    public function setGetHouseProfile988Result(\StructType\GetHouseProfile988Response $getHouseProfile988Result = null)
    {
        $this->GetHouseProfile988Result = $getHouseProfile988Result;
        return $this;
    }
}
