<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetFileByID StructType
 * @subpackage Structs
 */
class GetFileByID extends AbstractStructBase
{
    /**
     * The file_id
     * @var int
     */
    public $file_id;
    /**
     * Constructor method for GetFileByID
     * @uses GetFileByID::setFile_id()
     * @param int $file_id
     */
    public function __construct($file_id = null)
    {
        $this
            ->setFile_id($file_id);
    }
    /**
     * Get file_id value
     * @return int|null
     */
    public function getFile_id()
    {
        return $this->file_id;
    }
    /**
     * Set file_id value
     * @param int $file_id
     * @return \StructType\GetFileByID
     */
    public function setFile_id($file_id = null)
    {
        // validation for constraint: int
        if (!is_null($file_id) && !(is_int($file_id) || ctype_digit($file_id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($file_id, true), gettype($file_id)), __LINE__);
        }
        $this->file_id = $file_id;
        return $this;
    }
}
