<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetCompanyProfile988 StructType
 * @subpackage Structs
 */
class SetCompanyProfile988 extends AbstractStructBase
{
    /**
     * The inn
     * @var string
     */
    public $inn;
    /**
     * The reporting_period_id
     * @var int
     */
    public $reporting_period_id;
    /**
     * The data
     * @var \StructType\CompanyProfileData988
     */
    public $data;
    /**
     * Constructor method for SetCompanyProfile988
     * @uses SetCompanyProfile988::setInn()
     * @uses SetCompanyProfile988::setReporting_period_id()
     * @uses SetCompanyProfile988::setData()
     * @param string $inn
     * @param int $reporting_period_id
     * @param \StructType\CompanyProfileData988 $data
     */
    public function __construct($inn = null, $reporting_period_id = null, \StructType\CompanyProfileData988 $data = null)
    {
        $this
            ->setInn($inn)
            ->setReporting_period_id($reporting_period_id)
            ->setData($data);
    }
    /**
     * Get inn value
     * @return string|null
     */
    public function getInn()
    {
        return $this->inn;
    }
    /**
     * Set inn value
     * @param string $inn
     * @return \StructType\SetCompanyProfile988
     */
    public function setInn($inn = null)
    {
        // validation for constraint: string
        if (!is_null($inn) && !is_string($inn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inn, true), gettype($inn)), __LINE__);
        }
        $this->inn = $inn;
        return $this;
    }
    /**
     * Get reporting_period_id value
     * @return int|null
     */
    public function getReporting_period_id()
    {
        return $this->reporting_period_id;
    }
    /**
     * Set reporting_period_id value
     * @param int $reporting_period_id
     * @return \StructType\SetCompanyProfile988
     */
    public function setReporting_period_id($reporting_period_id = null)
    {
        // validation for constraint: int
        if (!is_null($reporting_period_id) && !(is_int($reporting_period_id) || ctype_digit($reporting_period_id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($reporting_period_id, true), gettype($reporting_period_id)), __LINE__);
        }
        $this->reporting_period_id = $reporting_period_id;
        return $this;
    }
    /**
     * Get data value
     * @return \StructType\CompanyProfileData988|null
     */
    public function getData()
    {
        return $this->data;
    }
    /**
     * Set data value
     * @param \StructType\CompanyProfileData988 $data
     * @return \StructType\SetCompanyProfile988
     */
    public function setData(\StructType\CompanyProfileData988 $data = null)
    {
        $this->data = $data;
        return $this;
    }
}
