<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetHouseProfileSF988 StructType
 * @subpackage Structs
 */
class GetHouseProfileSF988 extends AbstractStructBase
{
    /**
     * The region_id
     * @var string
     */
    public $region_id;
    /**
     * The page_number
     * @var int
     */
    public $page_number;
    /**
     * The reporting_period_id
     * @var int
     */
    public $reporting_period_id;
    /**
     * Constructor method for GetHouseProfileSF988
     * @uses GetHouseProfileSF988::setRegion_id()
     * @uses GetHouseProfileSF988::setPage_number()
     * @uses GetHouseProfileSF988::setReporting_period_id()
     * @param string $region_id
     * @param int $page_number
     * @param int $reporting_period_id
     */
    public function __construct($region_id = null, $page_number = null, $reporting_period_id = null)
    {
        $this
            ->setRegion_id($region_id)
            ->setPage_number($page_number)
            ->setReporting_period_id($reporting_period_id);
    }
    /**
     * Get region_id value
     * @return string|null
     */
    public function getRegion_id()
    {
        return $this->region_id;
    }
    /**
     * Set region_id value
     * @param string $region_id
     * @return \StructType\GetHouseProfileSF988
     */
    public function setRegion_id($region_id = null)
    {
        // validation for constraint: string
        if (!is_null($region_id) && !is_string($region_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($region_id, true), gettype($region_id)), __LINE__);
        }
        $this->region_id = $region_id;
        return $this;
    }
    /**
     * Get page_number value
     * @return int|null
     */
    public function getPage_number()
    {
        return $this->page_number;
    }
    /**
     * Set page_number value
     * @param int $page_number
     * @return \StructType\GetHouseProfileSF988
     */
    public function setPage_number($page_number = null)
    {
        // validation for constraint: int
        if (!is_null($page_number) && !(is_int($page_number) || ctype_digit($page_number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($page_number, true), gettype($page_number)), __LINE__);
        }
        $this->page_number = $page_number;
        return $this;
    }
    /**
     * Get reporting_period_id value
     * @return int|null
     */
    public function getReporting_period_id()
    {
        return $this->reporting_period_id;
    }
    /**
     * Set reporting_period_id value
     * @param int $reporting_period_id
     * @return \StructType\GetHouseProfileSF988
     */
    public function setReporting_period_id($reporting_period_id = null)
    {
        // validation for constraint: int
        if (!is_null($reporting_period_id) && !(is_int($reporting_period_id) || ctype_digit($reporting_period_id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($reporting_period_id, true), gettype($reporting_period_id)), __LINE__);
        }
        $this->reporting_period_id = $reporting_period_id;
        return $this;
    }
}
