<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Facade StructType
 * @subpackage Structs
 */
class Facade extends AbstractStructBase
{
    /**
     * The area_total
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $area_total;
    /**
     * The area_plastered
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $area_plastered;
    /**
     * The area_unplastered
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $area_unplastered;
    /**
     * The area_panel
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $area_panel;
    /**
     * The area_tiled
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $area_tiled;
    /**
     * The area_lined_siding
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $area_lined_siding;
    /**
     * The area_wooden
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $area_wooden;
    /**
     * The area_insulated_decorative_plaster
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $area_insulated_decorative_plaster;
    /**
     * The area_insulated_tiles
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $area_insulated_tiles;
    /**
     * The area_insulated_siding
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $area_insulated_siding;
    /**
     * The area_riprap
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $area_riprap;
    /**
     * The area_glazing_common_wooden
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $area_glazing_common_wooden;
    /**
     * The area_glazing_common_plastic
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $area_glazing_common_plastic;
    /**
     * The area_glazing_individual_wooden
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $area_glazing_individual_wooden;
    /**
     * The area_glazing_individual_plastic
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $area_glazing_individual_plastic;
    /**
     * The area_door_fillings_metal
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $area_door_fillings_metal;
    /**
     * The area_door_fillings_others
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $area_door_fillings_others;
    /**
     * The last_overhaul_date
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $last_overhaul_date;
    /**
     * Constructor method for Facade
     * @uses Facade::setArea_total()
     * @uses Facade::setArea_plastered()
     * @uses Facade::setArea_unplastered()
     * @uses Facade::setArea_panel()
     * @uses Facade::setArea_tiled()
     * @uses Facade::setArea_lined_siding()
     * @uses Facade::setArea_wooden()
     * @uses Facade::setArea_insulated_decorative_plaster()
     * @uses Facade::setArea_insulated_tiles()
     * @uses Facade::setArea_insulated_siding()
     * @uses Facade::setArea_riprap()
     * @uses Facade::setArea_glazing_common_wooden()
     * @uses Facade::setArea_glazing_common_plastic()
     * @uses Facade::setArea_glazing_individual_wooden()
     * @uses Facade::setArea_glazing_individual_plastic()
     * @uses Facade::setArea_door_fillings_metal()
     * @uses Facade::setArea_door_fillings_others()
     * @uses Facade::setLast_overhaul_date()
     * @param float $area_total
     * @param float $area_plastered
     * @param float $area_unplastered
     * @param float $area_panel
     * @param float $area_tiled
     * @param float $area_lined_siding
     * @param float $area_wooden
     * @param float $area_insulated_decorative_plaster
     * @param float $area_insulated_tiles
     * @param float $area_insulated_siding
     * @param float $area_riprap
     * @param float $area_glazing_common_wooden
     * @param float $area_glazing_common_plastic
     * @param float $area_glazing_individual_wooden
     * @param float $area_glazing_individual_plastic
     * @param float $area_door_fillings_metal
     * @param float $area_door_fillings_others
     * @param string $last_overhaul_date
     */
    public function __construct($area_total = null, $area_plastered = null, $area_unplastered = null, $area_panel = null, $area_tiled = null, $area_lined_siding = null, $area_wooden = null, $area_insulated_decorative_plaster = null, $area_insulated_tiles = null, $area_insulated_siding = null, $area_riprap = null, $area_glazing_common_wooden = null, $area_glazing_common_plastic = null, $area_glazing_individual_wooden = null, $area_glazing_individual_plastic = null, $area_door_fillings_metal = null, $area_door_fillings_others = null, $last_overhaul_date = null)
    {
        $this
            ->setArea_total($area_total)
            ->setArea_plastered($area_plastered)
            ->setArea_unplastered($area_unplastered)
            ->setArea_panel($area_panel)
            ->setArea_tiled($area_tiled)
            ->setArea_lined_siding($area_lined_siding)
            ->setArea_wooden($area_wooden)
            ->setArea_insulated_decorative_plaster($area_insulated_decorative_plaster)
            ->setArea_insulated_tiles($area_insulated_tiles)
            ->setArea_insulated_siding($area_insulated_siding)
            ->setArea_riprap($area_riprap)
            ->setArea_glazing_common_wooden($area_glazing_common_wooden)
            ->setArea_glazing_common_plastic($area_glazing_common_plastic)
            ->setArea_glazing_individual_wooden($area_glazing_individual_wooden)
            ->setArea_glazing_individual_plastic($area_glazing_individual_plastic)
            ->setArea_door_fillings_metal($area_door_fillings_metal)
            ->setArea_door_fillings_others($area_door_fillings_others)
            ->setLast_overhaul_date($last_overhaul_date);
    }
    /**
     * Get area_total value
     * @return float|null
     */
    public function getArea_total()
    {
        return $this->area_total;
    }
    /**
     * Set area_total value
     * @param float $area_total
     * @return \StructType\Facade
     */
    public function setArea_total($area_total = null)
    {
        // validation for constraint: float
        if (!is_null($area_total) && !(is_float($area_total) || is_numeric($area_total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($area_total, true), gettype($area_total)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($area_total) && mb_strlen(mb_substr($area_total, false !== mb_strpos($area_total, '.') ? mb_strpos($area_total, '.') + 1 : mb_strlen($area_total))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($area_total, true), mb_strlen(mb_substr($area_total, mb_strpos($area_total, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($area_total) && mb_strlen(preg_replace('/(\D)/', '', $area_total)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($area_total, true), mb_strlen(preg_replace('/(\D)/', '', $area_total))), __LINE__);
        }
        $this->area_total = $area_total;
        return $this;
    }
    /**
     * Get area_plastered value
     * @return float|null
     */
    public function getArea_plastered()
    {
        return $this->area_plastered;
    }
    /**
     * Set area_plastered value
     * @param float $area_plastered
     * @return \StructType\Facade
     */
    public function setArea_plastered($area_plastered = null)
    {
        // validation for constraint: float
        if (!is_null($area_plastered) && !(is_float($area_plastered) || is_numeric($area_plastered))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($area_plastered, true), gettype($area_plastered)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($area_plastered) && mb_strlen(mb_substr($area_plastered, false !== mb_strpos($area_plastered, '.') ? mb_strpos($area_plastered, '.') + 1 : mb_strlen($area_plastered))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($area_plastered, true), mb_strlen(mb_substr($area_plastered, mb_strpos($area_plastered, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($area_plastered) && mb_strlen(preg_replace('/(\D)/', '', $area_plastered)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($area_plastered, true), mb_strlen(preg_replace('/(\D)/', '', $area_plastered))), __LINE__);
        }
        $this->area_plastered = $area_plastered;
        return $this;
    }
    /**
     * Get area_unplastered value
     * @return float|null
     */
    public function getArea_unplastered()
    {
        return $this->area_unplastered;
    }
    /**
     * Set area_unplastered value
     * @param float $area_unplastered
     * @return \StructType\Facade
     */
    public function setArea_unplastered($area_unplastered = null)
    {
        // validation for constraint: float
        if (!is_null($area_unplastered) && !(is_float($area_unplastered) || is_numeric($area_unplastered))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($area_unplastered, true), gettype($area_unplastered)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($area_unplastered) && mb_strlen(mb_substr($area_unplastered, false !== mb_strpos($area_unplastered, '.') ? mb_strpos($area_unplastered, '.') + 1 : mb_strlen($area_unplastered))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($area_unplastered, true), mb_strlen(mb_substr($area_unplastered, mb_strpos($area_unplastered, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($area_unplastered) && mb_strlen(preg_replace('/(\D)/', '', $area_unplastered)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($area_unplastered, true), mb_strlen(preg_replace('/(\D)/', '', $area_unplastered))), __LINE__);
        }
        $this->area_unplastered = $area_unplastered;
        return $this;
    }
    /**
     * Get area_panel value
     * @return float|null
     */
    public function getArea_panel()
    {
        return $this->area_panel;
    }
    /**
     * Set area_panel value
     * @param float $area_panel
     * @return \StructType\Facade
     */
    public function setArea_panel($area_panel = null)
    {
        // validation for constraint: float
        if (!is_null($area_panel) && !(is_float($area_panel) || is_numeric($area_panel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($area_panel, true), gettype($area_panel)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($area_panel) && mb_strlen(mb_substr($area_panel, false !== mb_strpos($area_panel, '.') ? mb_strpos($area_panel, '.') + 1 : mb_strlen($area_panel))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($area_panel, true), mb_strlen(mb_substr($area_panel, mb_strpos($area_panel, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($area_panel) && mb_strlen(preg_replace('/(\D)/', '', $area_panel)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($area_panel, true), mb_strlen(preg_replace('/(\D)/', '', $area_panel))), __LINE__);
        }
        $this->area_panel = $area_panel;
        return $this;
    }
    /**
     * Get area_tiled value
     * @return float|null
     */
    public function getArea_tiled()
    {
        return $this->area_tiled;
    }
    /**
     * Set area_tiled value
     * @param float $area_tiled
     * @return \StructType\Facade
     */
    public function setArea_tiled($area_tiled = null)
    {
        // validation for constraint: float
        if (!is_null($area_tiled) && !(is_float($area_tiled) || is_numeric($area_tiled))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($area_tiled, true), gettype($area_tiled)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($area_tiled) && mb_strlen(mb_substr($area_tiled, false !== mb_strpos($area_tiled, '.') ? mb_strpos($area_tiled, '.') + 1 : mb_strlen($area_tiled))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($area_tiled, true), mb_strlen(mb_substr($area_tiled, mb_strpos($area_tiled, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($area_tiled) && mb_strlen(preg_replace('/(\D)/', '', $area_tiled)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($area_tiled, true), mb_strlen(preg_replace('/(\D)/', '', $area_tiled))), __LINE__);
        }
        $this->area_tiled = $area_tiled;
        return $this;
    }
    /**
     * Get area_lined_siding value
     * @return float|null
     */
    public function getArea_lined_siding()
    {
        return $this->area_lined_siding;
    }
    /**
     * Set area_lined_siding value
     * @param float $area_lined_siding
     * @return \StructType\Facade
     */
    public function setArea_lined_siding($area_lined_siding = null)
    {
        // validation for constraint: float
        if (!is_null($area_lined_siding) && !(is_float($area_lined_siding) || is_numeric($area_lined_siding))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($area_lined_siding, true), gettype($area_lined_siding)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($area_lined_siding) && mb_strlen(mb_substr($area_lined_siding, false !== mb_strpos($area_lined_siding, '.') ? mb_strpos($area_lined_siding, '.') + 1 : mb_strlen($area_lined_siding))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($area_lined_siding, true), mb_strlen(mb_substr($area_lined_siding, mb_strpos($area_lined_siding, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($area_lined_siding) && mb_strlen(preg_replace('/(\D)/', '', $area_lined_siding)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($area_lined_siding, true), mb_strlen(preg_replace('/(\D)/', '', $area_lined_siding))), __LINE__);
        }
        $this->area_lined_siding = $area_lined_siding;
        return $this;
    }
    /**
     * Get area_wooden value
     * @return float|null
     */
    public function getArea_wooden()
    {
        return $this->area_wooden;
    }
    /**
     * Set area_wooden value
     * @param float $area_wooden
     * @return \StructType\Facade
     */
    public function setArea_wooden($area_wooden = null)
    {
        // validation for constraint: float
        if (!is_null($area_wooden) && !(is_float($area_wooden) || is_numeric($area_wooden))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($area_wooden, true), gettype($area_wooden)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($area_wooden) && mb_strlen(mb_substr($area_wooden, false !== mb_strpos($area_wooden, '.') ? mb_strpos($area_wooden, '.') + 1 : mb_strlen($area_wooden))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($area_wooden, true), mb_strlen(mb_substr($area_wooden, mb_strpos($area_wooden, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($area_wooden) && mb_strlen(preg_replace('/(\D)/', '', $area_wooden)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($area_wooden, true), mb_strlen(preg_replace('/(\D)/', '', $area_wooden))), __LINE__);
        }
        $this->area_wooden = $area_wooden;
        return $this;
    }
    /**
     * Get area_insulated_decorative_plaster value
     * @return float|null
     */
    public function getArea_insulated_decorative_plaster()
    {
        return $this->area_insulated_decorative_plaster;
    }
    /**
     * Set area_insulated_decorative_plaster value
     * @param float $area_insulated_decorative_plaster
     * @return \StructType\Facade
     */
    public function setArea_insulated_decorative_plaster($area_insulated_decorative_plaster = null)
    {
        // validation for constraint: float
        if (!is_null($area_insulated_decorative_plaster) && !(is_float($area_insulated_decorative_plaster) || is_numeric($area_insulated_decorative_plaster))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($area_insulated_decorative_plaster, true), gettype($area_insulated_decorative_plaster)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($area_insulated_decorative_plaster) && mb_strlen(mb_substr($area_insulated_decorative_plaster, false !== mb_strpos($area_insulated_decorative_plaster, '.') ? mb_strpos($area_insulated_decorative_plaster, '.') + 1 : mb_strlen($area_insulated_decorative_plaster))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($area_insulated_decorative_plaster, true), mb_strlen(mb_substr($area_insulated_decorative_plaster, mb_strpos($area_insulated_decorative_plaster, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($area_insulated_decorative_plaster) && mb_strlen(preg_replace('/(\D)/', '', $area_insulated_decorative_plaster)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($area_insulated_decorative_plaster, true), mb_strlen(preg_replace('/(\D)/', '', $area_insulated_decorative_plaster))), __LINE__);
        }
        $this->area_insulated_decorative_plaster = $area_insulated_decorative_plaster;
        return $this;
    }
    /**
     * Get area_insulated_tiles value
     * @return float|null
     */
    public function getArea_insulated_tiles()
    {
        return $this->area_insulated_tiles;
    }
    /**
     * Set area_insulated_tiles value
     * @param float $area_insulated_tiles
     * @return \StructType\Facade
     */
    public function setArea_insulated_tiles($area_insulated_tiles = null)
    {
        // validation for constraint: float
        if (!is_null($area_insulated_tiles) && !(is_float($area_insulated_tiles) || is_numeric($area_insulated_tiles))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($area_insulated_tiles, true), gettype($area_insulated_tiles)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($area_insulated_tiles) && mb_strlen(mb_substr($area_insulated_tiles, false !== mb_strpos($area_insulated_tiles, '.') ? mb_strpos($area_insulated_tiles, '.') + 1 : mb_strlen($area_insulated_tiles))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($area_insulated_tiles, true), mb_strlen(mb_substr($area_insulated_tiles, mb_strpos($area_insulated_tiles, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($area_insulated_tiles) && mb_strlen(preg_replace('/(\D)/', '', $area_insulated_tiles)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($area_insulated_tiles, true), mb_strlen(preg_replace('/(\D)/', '', $area_insulated_tiles))), __LINE__);
        }
        $this->area_insulated_tiles = $area_insulated_tiles;
        return $this;
    }
    /**
     * Get area_insulated_siding value
     * @return float|null
     */
    public function getArea_insulated_siding()
    {
        return $this->area_insulated_siding;
    }
    /**
     * Set area_insulated_siding value
     * @param float $area_insulated_siding
     * @return \StructType\Facade
     */
    public function setArea_insulated_siding($area_insulated_siding = null)
    {
        // validation for constraint: float
        if (!is_null($area_insulated_siding) && !(is_float($area_insulated_siding) || is_numeric($area_insulated_siding))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($area_insulated_siding, true), gettype($area_insulated_siding)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($area_insulated_siding) && mb_strlen(mb_substr($area_insulated_siding, false !== mb_strpos($area_insulated_siding, '.') ? mb_strpos($area_insulated_siding, '.') + 1 : mb_strlen($area_insulated_siding))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($area_insulated_siding, true), mb_strlen(mb_substr($area_insulated_siding, mb_strpos($area_insulated_siding, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($area_insulated_siding) && mb_strlen(preg_replace('/(\D)/', '', $area_insulated_siding)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($area_insulated_siding, true), mb_strlen(preg_replace('/(\D)/', '', $area_insulated_siding))), __LINE__);
        }
        $this->area_insulated_siding = $area_insulated_siding;
        return $this;
    }
    /**
     * Get area_riprap value
     * @return float|null
     */
    public function getArea_riprap()
    {
        return $this->area_riprap;
    }
    /**
     * Set area_riprap value
     * @param float $area_riprap
     * @return \StructType\Facade
     */
    public function setArea_riprap($area_riprap = null)
    {
        // validation for constraint: float
        if (!is_null($area_riprap) && !(is_float($area_riprap) || is_numeric($area_riprap))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($area_riprap, true), gettype($area_riprap)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($area_riprap) && mb_strlen(mb_substr($area_riprap, false !== mb_strpos($area_riprap, '.') ? mb_strpos($area_riprap, '.') + 1 : mb_strlen($area_riprap))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($area_riprap, true), mb_strlen(mb_substr($area_riprap, mb_strpos($area_riprap, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($area_riprap) && mb_strlen(preg_replace('/(\D)/', '', $area_riprap)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($area_riprap, true), mb_strlen(preg_replace('/(\D)/', '', $area_riprap))), __LINE__);
        }
        $this->area_riprap = $area_riprap;
        return $this;
    }
    /**
     * Get area_glazing_common_wooden value
     * @return float|null
     */
    public function getArea_glazing_common_wooden()
    {
        return $this->area_glazing_common_wooden;
    }
    /**
     * Set area_glazing_common_wooden value
     * @param float $area_glazing_common_wooden
     * @return \StructType\Facade
     */
    public function setArea_glazing_common_wooden($area_glazing_common_wooden = null)
    {
        // validation for constraint: float
        if (!is_null($area_glazing_common_wooden) && !(is_float($area_glazing_common_wooden) || is_numeric($area_glazing_common_wooden))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($area_glazing_common_wooden, true), gettype($area_glazing_common_wooden)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($area_glazing_common_wooden) && mb_strlen(mb_substr($area_glazing_common_wooden, false !== mb_strpos($area_glazing_common_wooden, '.') ? mb_strpos($area_glazing_common_wooden, '.') + 1 : mb_strlen($area_glazing_common_wooden))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($area_glazing_common_wooden, true), mb_strlen(mb_substr($area_glazing_common_wooden, mb_strpos($area_glazing_common_wooden, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($area_glazing_common_wooden) && mb_strlen(preg_replace('/(\D)/', '', $area_glazing_common_wooden)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($area_glazing_common_wooden, true), mb_strlen(preg_replace('/(\D)/', '', $area_glazing_common_wooden))), __LINE__);
        }
        $this->area_glazing_common_wooden = $area_glazing_common_wooden;
        return $this;
    }
    /**
     * Get area_glazing_common_plastic value
     * @return float|null
     */
    public function getArea_glazing_common_plastic()
    {
        return $this->area_glazing_common_plastic;
    }
    /**
     * Set area_glazing_common_plastic value
     * @param float $area_glazing_common_plastic
     * @return \StructType\Facade
     */
    public function setArea_glazing_common_plastic($area_glazing_common_plastic = null)
    {
        // validation for constraint: float
        if (!is_null($area_glazing_common_plastic) && !(is_float($area_glazing_common_plastic) || is_numeric($area_glazing_common_plastic))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($area_glazing_common_plastic, true), gettype($area_glazing_common_plastic)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($area_glazing_common_plastic) && mb_strlen(mb_substr($area_glazing_common_plastic, false !== mb_strpos($area_glazing_common_plastic, '.') ? mb_strpos($area_glazing_common_plastic, '.') + 1 : mb_strlen($area_glazing_common_plastic))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($area_glazing_common_plastic, true), mb_strlen(mb_substr($area_glazing_common_plastic, mb_strpos($area_glazing_common_plastic, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($area_glazing_common_plastic) && mb_strlen(preg_replace('/(\D)/', '', $area_glazing_common_plastic)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($area_glazing_common_plastic, true), mb_strlen(preg_replace('/(\D)/', '', $area_glazing_common_plastic))), __LINE__);
        }
        $this->area_glazing_common_plastic = $area_glazing_common_plastic;
        return $this;
    }
    /**
     * Get area_glazing_individual_wooden value
     * @return float|null
     */
    public function getArea_glazing_individual_wooden()
    {
        return $this->area_glazing_individual_wooden;
    }
    /**
     * Set area_glazing_individual_wooden value
     * @param float $area_glazing_individual_wooden
     * @return \StructType\Facade
     */
    public function setArea_glazing_individual_wooden($area_glazing_individual_wooden = null)
    {
        // validation for constraint: float
        if (!is_null($area_glazing_individual_wooden) && !(is_float($area_glazing_individual_wooden) || is_numeric($area_glazing_individual_wooden))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($area_glazing_individual_wooden, true), gettype($area_glazing_individual_wooden)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($area_glazing_individual_wooden) && mb_strlen(mb_substr($area_glazing_individual_wooden, false !== mb_strpos($area_glazing_individual_wooden, '.') ? mb_strpos($area_glazing_individual_wooden, '.') + 1 : mb_strlen($area_glazing_individual_wooden))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($area_glazing_individual_wooden, true), mb_strlen(mb_substr($area_glazing_individual_wooden, mb_strpos($area_glazing_individual_wooden, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($area_glazing_individual_wooden) && mb_strlen(preg_replace('/(\D)/', '', $area_glazing_individual_wooden)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($area_glazing_individual_wooden, true), mb_strlen(preg_replace('/(\D)/', '', $area_glazing_individual_wooden))), __LINE__);
        }
        $this->area_glazing_individual_wooden = $area_glazing_individual_wooden;
        return $this;
    }
    /**
     * Get area_glazing_individual_plastic value
     * @return float|null
     */
    public function getArea_glazing_individual_plastic()
    {
        return $this->area_glazing_individual_plastic;
    }
    /**
     * Set area_glazing_individual_plastic value
     * @param float $area_glazing_individual_plastic
     * @return \StructType\Facade
     */
    public function setArea_glazing_individual_plastic($area_glazing_individual_plastic = null)
    {
        // validation for constraint: float
        if (!is_null($area_glazing_individual_plastic) && !(is_float($area_glazing_individual_plastic) || is_numeric($area_glazing_individual_plastic))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($area_glazing_individual_plastic, true), gettype($area_glazing_individual_plastic)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($area_glazing_individual_plastic) && mb_strlen(mb_substr($area_glazing_individual_plastic, false !== mb_strpos($area_glazing_individual_plastic, '.') ? mb_strpos($area_glazing_individual_plastic, '.') + 1 : mb_strlen($area_glazing_individual_plastic))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($area_glazing_individual_plastic, true), mb_strlen(mb_substr($area_glazing_individual_plastic, mb_strpos($area_glazing_individual_plastic, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($area_glazing_individual_plastic) && mb_strlen(preg_replace('/(\D)/', '', $area_glazing_individual_plastic)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($area_glazing_individual_plastic, true), mb_strlen(preg_replace('/(\D)/', '', $area_glazing_individual_plastic))), __LINE__);
        }
        $this->area_glazing_individual_plastic = $area_glazing_individual_plastic;
        return $this;
    }
    /**
     * Get area_door_fillings_metal value
     * @return float|null
     */
    public function getArea_door_fillings_metal()
    {
        return $this->area_door_fillings_metal;
    }
    /**
     * Set area_door_fillings_metal value
     * @param float $area_door_fillings_metal
     * @return \StructType\Facade
     */
    public function setArea_door_fillings_metal($area_door_fillings_metal = null)
    {
        // validation for constraint: float
        if (!is_null($area_door_fillings_metal) && !(is_float($area_door_fillings_metal) || is_numeric($area_door_fillings_metal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($area_door_fillings_metal, true), gettype($area_door_fillings_metal)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($area_door_fillings_metal) && mb_strlen(mb_substr($area_door_fillings_metal, false !== mb_strpos($area_door_fillings_metal, '.') ? mb_strpos($area_door_fillings_metal, '.') + 1 : mb_strlen($area_door_fillings_metal))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($area_door_fillings_metal, true), mb_strlen(mb_substr($area_door_fillings_metal, mb_strpos($area_door_fillings_metal, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($area_door_fillings_metal) && mb_strlen(preg_replace('/(\D)/', '', $area_door_fillings_metal)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($area_door_fillings_metal, true), mb_strlen(preg_replace('/(\D)/', '', $area_door_fillings_metal))), __LINE__);
        }
        $this->area_door_fillings_metal = $area_door_fillings_metal;
        return $this;
    }
    /**
     * Get area_door_fillings_others value
     * @return float|null
     */
    public function getArea_door_fillings_others()
    {
        return $this->area_door_fillings_others;
    }
    /**
     * Set area_door_fillings_others value
     * @param float $area_door_fillings_others
     * @return \StructType\Facade
     */
    public function setArea_door_fillings_others($area_door_fillings_others = null)
    {
        // validation for constraint: float
        if (!is_null($area_door_fillings_others) && !(is_float($area_door_fillings_others) || is_numeric($area_door_fillings_others))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($area_door_fillings_others, true), gettype($area_door_fillings_others)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($area_door_fillings_others) && mb_strlen(mb_substr($area_door_fillings_others, false !== mb_strpos($area_door_fillings_others, '.') ? mb_strpos($area_door_fillings_others, '.') + 1 : mb_strlen($area_door_fillings_others))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($area_door_fillings_others, true), mb_strlen(mb_substr($area_door_fillings_others, mb_strpos($area_door_fillings_others, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($area_door_fillings_others) && mb_strlen(preg_replace('/(\D)/', '', $area_door_fillings_others)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($area_door_fillings_others, true), mb_strlen(preg_replace('/(\D)/', '', $area_door_fillings_others))), __LINE__);
        }
        $this->area_door_fillings_others = $area_door_fillings_others;
        return $this;
    }
    /**
     * Get last_overhaul_date value
     * @return string|null
     */
    public function getLast_overhaul_date()
    {
        return $this->last_overhaul_date;
    }
    /**
     * Set last_overhaul_date value
     * @param string $last_overhaul_date
     * @return \StructType\Facade
     */
    public function setLast_overhaul_date($last_overhaul_date = null)
    {
        // validation for constraint: string
        if (!is_null($last_overhaul_date) && !is_string($last_overhaul_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($last_overhaul_date, true), gettype($last_overhaul_date)), __LINE__);
        }
        $this->last_overhaul_date = $last_overhaul_date;
        return $this;
    }
}
