<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for SetRequestForSubmitInnStatusEnum EnumType
 * @subpackage Enumerations
 */
class SetRequestForSubmitInnStatusEnum extends AbstractStructEnumBase
{
    /**
     * Constant for value '0'
     * Meta information extracted from the WSDL
     * - description: Ошибок нет. Заявка подана.
     * - label: Success
     * @return string '0'
     */
    const VALUE_0 = '0';
    /**
     * Constant for value '1'
     * Meta information extracted from the WSDL
     * - description: Управляющая организация с  указанным ИНН не найдена
     * - label: Missing INN
     * @return string '1'
     */
    const VALUE_1 = '1';
    /**
     * Constant for value '2'
     * Meta information extracted from the WSDL
     * - description: Указан некорректный ИНН
     * - label: INN is not valid
     * @return string '2'
     */
    const VALUE_2 = '2';
    /**
     * Constant for value '3'
     * Meta information extracted from the WSDL
     * - description: Запрос на подписку был уже подан ранее
     * - label: Request have been already submitted
     * @return string '3'
     */
    const VALUE_3 = '3';
    /**
     * Return allowed values
     * @uses self::VALUE_0
     * @uses self::VALUE_1
     * @uses self::VALUE_2
     * @uses self::VALUE_3
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_0,
            self::VALUE_1,
            self::VALUE_2,
            self::VALUE_3,
        );
    }
}
