<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnlinkHouseFromOrganizationData StructType
 * @subpackage Structs
 */
class UnlinkHouseFromOrganizationData extends AbstractStructBase
{
    /**
     * The house_id
     * @var int
     */
    public $house_id;
    /**
     * The stop_reason_type
     * @var string
     */
    public $stop_reason_type;
    /**
     * The stop_reason
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $stop_reason;
    /**
     * The date_stop
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $date_stop;
    /**
     * Constructor method for UnlinkHouseFromOrganizationData
     * @uses UnlinkHouseFromOrganizationData::setHouse_id()
     * @uses UnlinkHouseFromOrganizationData::setStop_reason_type()
     * @uses UnlinkHouseFromOrganizationData::setStop_reason()
     * @uses UnlinkHouseFromOrganizationData::setDate_stop()
     * @param int $house_id
     * @param string $stop_reason_type
     * @param string $stop_reason
     * @param string $date_stop
     */
    public function __construct($house_id = null, $stop_reason_type = null, $stop_reason = null, $date_stop = null)
    {
        $this
            ->setHouse_id($house_id)
            ->setStop_reason_type($stop_reason_type)
            ->setStop_reason($stop_reason)
            ->setDate_stop($date_stop);
    }
    /**
     * Get house_id value
     * @return int|null
     */
    public function getHouse_id()
    {
        return $this->house_id;
    }
    /**
     * Set house_id value
     * @param int $house_id
     * @return \StructType\UnlinkHouseFromOrganizationData
     */
    public function setHouse_id($house_id = null)
    {
        // validation for constraint: int
        if (!is_null($house_id) && !(is_int($house_id) || ctype_digit($house_id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($house_id, true), gettype($house_id)), __LINE__);
        }
        $this->house_id = $house_id;
        return $this;
    }
    /**
     * Get stop_reason_type value
     * @return string|null
     */
    public function getStop_reason_type()
    {
        return $this->stop_reason_type;
    }
    /**
     * Set stop_reason_type value
     * @uses \EnumType\ContractStopReasonEnum::valueIsValid()
     * @uses \EnumType\ContractStopReasonEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $stop_reason_type
     * @return \StructType\UnlinkHouseFromOrganizationData
     */
    public function setStop_reason_type($stop_reason_type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ContractStopReasonEnum::valueIsValid($stop_reason_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ContractStopReasonEnum', is_array($stop_reason_type) ? implode(', ', $stop_reason_type) : var_export($stop_reason_type, true), implode(', ', \EnumType\ContractStopReasonEnum::getValidValues())), __LINE__);
        }
        $this->stop_reason_type = $stop_reason_type;
        return $this;
    }
    /**
     * Get stop_reason value
     * @return string|null
     */
    public function getStop_reason()
    {
        return $this->stop_reason;
    }
    /**
     * Set stop_reason value
     * @param string $stop_reason
     * @return \StructType\UnlinkHouseFromOrganizationData
     */
    public function setStop_reason($stop_reason = null)
    {
        // validation for constraint: string
        if (!is_null($stop_reason) && !is_string($stop_reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stop_reason, true), gettype($stop_reason)), __LINE__);
        }
        $this->stop_reason = $stop_reason;
        return $this;
    }
    /**
     * Get date_stop value
     * @return string|null
     */
    public function getDate_stop()
    {
        return $this->date_stop;
    }
    /**
     * Set date_stop value
     * @param string $date_stop
     * @return \StructType\UnlinkHouseFromOrganizationData
     */
    public function setDate_stop($date_stop = null)
    {
        // validation for constraint: string
        if (!is_null($date_stop) && !is_string($date_stop)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date_stop, true), gettype($date_stop)), __LINE__);
        }
        $this->date_stop = $date_stop;
        return $this;
    }
}
