<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HouseAlarm StructType
 * @subpackage Structs
 */
class HouseAlarm extends AbstractStructBase
{
    /**
     * The document_date
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $document_date;
    /**
     * The document_number
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $document_number;
    /**
     * The reason
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $reason;
    /**
     * The reason_other
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $reason_other;
    /**
     * The failure
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\HouseAlarmFailure
     */
    public $failure;
    /**
     * Constructor method for HouseAlarm
     * @uses HouseAlarm::setDocument_date()
     * @uses HouseAlarm::setDocument_number()
     * @uses HouseAlarm::setReason()
     * @uses HouseAlarm::setReason_other()
     * @uses HouseAlarm::setFailure()
     * @param string $document_date
     * @param string $document_number
     * @param string $reason
     * @param string $reason_other
     * @param \StructType\HouseAlarmFailure $failure
     */
    public function __construct($document_date = null, $document_number = null, $reason = null, $reason_other = null, \StructType\HouseAlarmFailure $failure = null)
    {
        $this
            ->setDocument_date($document_date)
            ->setDocument_number($document_number)
            ->setReason($reason)
            ->setReason_other($reason_other)
            ->setFailure($failure);
    }
    /**
     * Get document_date value
     * @return string|null
     */
    public function getDocument_date()
    {
        return $this->document_date;
    }
    /**
     * Set document_date value
     * @param string $document_date
     * @return \StructType\HouseAlarm
     */
    public function setDocument_date($document_date = null)
    {
        // validation for constraint: string
        if (!is_null($document_date) && !is_string($document_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($document_date, true), gettype($document_date)), __LINE__);
        }
        $this->document_date = $document_date;
        return $this;
    }
    /**
     * Get document_number value
     * @return string|null
     */
    public function getDocument_number()
    {
        return $this->document_number;
    }
    /**
     * Set document_number value
     * @param string $document_number
     * @return \StructType\HouseAlarm
     */
    public function setDocument_number($document_number = null)
    {
        // validation for constraint: string
        if (!is_null($document_number) && !is_string($document_number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($document_number, true), gettype($document_number)), __LINE__);
        }
        $this->document_number = $document_number;
        return $this;
    }
    /**
     * Get reason value
     * @return string|null
     */
    public function getReason()
    {
        return $this->reason;
    }
    /**
     * Set reason value
     * @uses \EnumType\AlarmReasonEnum::valueIsValid()
     * @uses \EnumType\AlarmReasonEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $reason
     * @return \StructType\HouseAlarm
     */
    public function setReason($reason = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AlarmReasonEnum::valueIsValid($reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AlarmReasonEnum', is_array($reason) ? implode(', ', $reason) : var_export($reason, true), implode(', ', \EnumType\AlarmReasonEnum::getValidValues())), __LINE__);
        }
        $this->reason = $reason;
        return $this;
    }
    /**
     * Get reason_other value
     * @return string|null
     */
    public function getReason_other()
    {
        return $this->reason_other;
    }
    /**
     * Set reason_other value
     * @param string $reason_other
     * @return \StructType\HouseAlarm
     */
    public function setReason_other($reason_other = null)
    {
        // validation for constraint: string
        if (!is_null($reason_other) && !is_string($reason_other)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reason_other, true), gettype($reason_other)), __LINE__);
        }
        $this->reason_other = $reason_other;
        return $this;
    }
    /**
     * Get failure value
     * @return \StructType\HouseAlarmFailure|null
     */
    public function getFailure()
    {
        return $this->failure;
    }
    /**
     * Set failure value
     * @param \StructType\HouseAlarmFailure $failure
     * @return \StructType\HouseAlarm
     */
    public function setFailure(\StructType\HouseAlarmFailure $failure = null)
    {
        $this->failure = $failure;
        return $this;
    }
}
