<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Basement StructType
 * @subpackage Structs
 */
class Basement extends AbstractStructBase
{
    /**
     * The basement_stage
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $basement_stage;
    /**
     * The basement_area
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $basement_area;
    /**
     * The basement_last_overhaul_date
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $basement_last_overhaul_date;
    /**
     * Constructor method for Basement
     * @uses Basement::setBasement_stage()
     * @uses Basement::setBasement_area()
     * @uses Basement::setBasement_last_overhaul_date()
     * @param string $basement_stage
     * @param float $basement_area
     * @param string $basement_last_overhaul_date
     */
    public function __construct($basement_stage = null, $basement_area = null, $basement_last_overhaul_date = null)
    {
        $this
            ->setBasement_stage($basement_stage)
            ->setBasement_area($basement_area)
            ->setBasement_last_overhaul_date($basement_last_overhaul_date);
    }
    /**
     * Get basement_stage value
     * @return string|null
     */
    public function getBasement_stage()
    {
        return $this->basement_stage;
    }
    /**
     * Set basement_stage value
     * @uses \EnumType\BasementStageEnum::valueIsValid()
     * @uses \EnumType\BasementStageEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $basement_stage
     * @return \StructType\Basement
     */
    public function setBasement_stage($basement_stage = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BasementStageEnum::valueIsValid($basement_stage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BasementStageEnum', is_array($basement_stage) ? implode(', ', $basement_stage) : var_export($basement_stage, true), implode(', ', \EnumType\BasementStageEnum::getValidValues())), __LINE__);
        }
        $this->basement_stage = $basement_stage;
        return $this;
    }
    /**
     * Get basement_area value
     * @return float|null
     */
    public function getBasement_area()
    {
        return $this->basement_area;
    }
    /**
     * Set basement_area value
     * @param float $basement_area
     * @return \StructType\Basement
     */
    public function setBasement_area($basement_area = null)
    {
        // validation for constraint: float
        if (!is_null($basement_area) && !(is_float($basement_area) || is_numeric($basement_area))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($basement_area, true), gettype($basement_area)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($basement_area) && mb_strlen(mb_substr($basement_area, false !== mb_strpos($basement_area, '.') ? mb_strpos($basement_area, '.') + 1 : mb_strlen($basement_area))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($basement_area, true), mb_strlen(mb_substr($basement_area, mb_strpos($basement_area, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($basement_area) && mb_strlen(preg_replace('/(\D)/', '', $basement_area)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($basement_area, true), mb_strlen(preg_replace('/(\D)/', '', $basement_area))), __LINE__);
        }
        $this->basement_area = $basement_area;
        return $this;
    }
    /**
     * Get basement_last_overhaul_date value
     * @return string|null
     */
    public function getBasement_last_overhaul_date()
    {
        return $this->basement_last_overhaul_date;
    }
    /**
     * Set basement_last_overhaul_date value
     * @param string $basement_last_overhaul_date
     * @return \StructType\Basement
     */
    public function setBasement_last_overhaul_date($basement_last_overhaul_date = null)
    {
        // validation for constraint: string
        if (!is_null($basement_last_overhaul_date) && !is_string($basement_last_overhaul_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($basement_last_overhaul_date, true), gettype($basement_last_overhaul_date)), __LINE__);
        }
        $this->basement_last_overhaul_date = $basement_last_overhaul_date;
        return $this;
    }
}
