<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Lift StructType
 * @subpackage Structs
 */
class Lift extends AbstractStructBase
{
    /**
     * The porch_number
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $porch_number;
    /**
     * The factory_number
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $factory_number;
    /**
     * The stops_count
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $stops_count;
    /**
     * The capacity
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $capacity;
    /**
     * The date_exploitation
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $date_exploitation;
    /**
     * The date_last_repair
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $date_last_repair;
    /**
     * The plan_period
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $plan_period;
    /**
     * The manufacturer
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $manufacturer;
    /**
     * Constructor method for Lift
     * @uses Lift::setPorch_number()
     * @uses Lift::setFactory_number()
     * @uses Lift::setStops_count()
     * @uses Lift::setCapacity()
     * @uses Lift::setDate_exploitation()
     * @uses Lift::setDate_last_repair()
     * @uses Lift::setPlan_period()
     * @uses Lift::setManufacturer()
     * @param string $porch_number
     * @param string $factory_number
     * @param int $stops_count
     * @param int $capacity
     * @param string $date_exploitation
     * @param string $date_last_repair
     * @param string $plan_period
     * @param string $manufacturer
     */
    public function __construct($porch_number = null, $factory_number = null, $stops_count = null, $capacity = null, $date_exploitation = null, $date_last_repair = null, $plan_period = null, $manufacturer = null)
    {
        $this
            ->setPorch_number($porch_number)
            ->setFactory_number($factory_number)
            ->setStops_count($stops_count)
            ->setCapacity($capacity)
            ->setDate_exploitation($date_exploitation)
            ->setDate_last_repair($date_last_repair)
            ->setPlan_period($plan_period)
            ->setManufacturer($manufacturer);
    }
    /**
     * Get porch_number value
     * @return string|null
     */
    public function getPorch_number()
    {
        return $this->porch_number;
    }
    /**
     * Set porch_number value
     * @param string $porch_number
     * @return \StructType\Lift
     */
    public function setPorch_number($porch_number = null)
    {
        // validation for constraint: string
        if (!is_null($porch_number) && !is_string($porch_number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($porch_number, true), gettype($porch_number)), __LINE__);
        }
        $this->porch_number = $porch_number;
        return $this;
    }
    /**
     * Get factory_number value
     * @return string|null
     */
    public function getFactory_number()
    {
        return $this->factory_number;
    }
    /**
     * Set factory_number value
     * @param string $factory_number
     * @return \StructType\Lift
     */
    public function setFactory_number($factory_number = null)
    {
        // validation for constraint: string
        if (!is_null($factory_number) && !is_string($factory_number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($factory_number, true), gettype($factory_number)), __LINE__);
        }
        $this->factory_number = $factory_number;
        return $this;
    }
    /**
     * Get stops_count value
     * @return int|null
     */
    public function getStops_count()
    {
        return $this->stops_count;
    }
    /**
     * Set stops_count value
     * @param int $stops_count
     * @return \StructType\Lift
     */
    public function setStops_count($stops_count = null)
    {
        // validation for constraint: int
        if (!is_null($stops_count) && !(is_int($stops_count) || ctype_digit($stops_count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($stops_count, true), gettype($stops_count)), __LINE__);
        }
        $this->stops_count = $stops_count;
        return $this;
    }
    /**
     * Get capacity value
     * @return int|null
     */
    public function getCapacity()
    {
        return $this->capacity;
    }
    /**
     * Set capacity value
     * @param int $capacity
     * @return \StructType\Lift
     */
    public function setCapacity($capacity = null)
    {
        // validation for constraint: int
        if (!is_null($capacity) && !(is_int($capacity) || ctype_digit($capacity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($capacity, true), gettype($capacity)), __LINE__);
        }
        $this->capacity = $capacity;
        return $this;
    }
    /**
     * Get date_exploitation value
     * @return string|null
     */
    public function getDate_exploitation()
    {
        return $this->date_exploitation;
    }
    /**
     * Set date_exploitation value
     * @param string $date_exploitation
     * @return \StructType\Lift
     */
    public function setDate_exploitation($date_exploitation = null)
    {
        // validation for constraint: string
        if (!is_null($date_exploitation) && !is_string($date_exploitation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date_exploitation, true), gettype($date_exploitation)), __LINE__);
        }
        $this->date_exploitation = $date_exploitation;
        return $this;
    }
    /**
     * Get date_last_repair value
     * @return string|null
     */
    public function getDate_last_repair()
    {
        return $this->date_last_repair;
    }
    /**
     * Set date_last_repair value
     * @param string $date_last_repair
     * @return \StructType\Lift
     */
    public function setDate_last_repair($date_last_repair = null)
    {
        // validation for constraint: string
        if (!is_null($date_last_repair) && !is_string($date_last_repair)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date_last_repair, true), gettype($date_last_repair)), __LINE__);
        }
        $this->date_last_repair = $date_last_repair;
        return $this;
    }
    /**
     * Get plan_period value
     * @return string|null
     */
    public function getPlan_period()
    {
        return $this->plan_period;
    }
    /**
     * Set plan_period value
     * @param string $plan_period
     * @return \StructType\Lift
     */
    public function setPlan_period($plan_period = null)
    {
        // validation for constraint: string
        if (!is_null($plan_period) && !is_string($plan_period)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plan_period, true), gettype($plan_period)), __LINE__);
        }
        $this->plan_period = $plan_period;
        return $this;
    }
    /**
     * Get manufacturer value
     * @return string|null
     */
    public function getManufacturer()
    {
        return $this->manufacturer;
    }
    /**
     * Set manufacturer value
     * @param string $manufacturer
     * @return \StructType\Lift
     */
    public function setManufacturer($manufacturer = null)
    {
        // validation for constraint: string
        if (!is_null($manufacturer) && !is_string($manufacturer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($manufacturer, true), gettype($manufacturer)), __LINE__);
        }
        $this->manufacturer = $manufacturer;
        return $this;
    }
}
