<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HouseData StructType
 * @subpackage Structs
 */
class HouseData extends AbstractStructBase
{
    /**
     * The house_id
     * @var int
     */
    public $house_id;
    /**
     * The full_address
     * @var \StructType\FullAddress
     */
    public $full_address;
    /**
     * Constructor method for HouseData
     * @uses HouseData::setHouse_id()
     * @uses HouseData::setFull_address()
     * @param int $house_id
     * @param \StructType\FullAddress $full_address
     */
    public function __construct($house_id = null, \StructType\FullAddress $full_address = null)
    {
        $this
            ->setHouse_id($house_id)
            ->setFull_address($full_address);
    }
    /**
     * Get house_id value
     * @return int|null
     */
    public function getHouse_id()
    {
        return $this->house_id;
    }
    /**
     * Set house_id value
     * @param int $house_id
     * @return \StructType\HouseData
     */
    public function setHouse_id($house_id = null)
    {
        // validation for constraint: int
        if (!is_null($house_id) && !(is_int($house_id) || ctype_digit($house_id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($house_id, true), gettype($house_id)), __LINE__);
        }
        $this->house_id = $house_id;
        return $this;
    }
    /**
     * Get full_address value
     * @return \StructType\FullAddress|null
     */
    public function getFull_address()
    {
        return $this->full_address;
    }
    /**
     * Set full_address value
     * @param \StructType\FullAddress $full_address
     * @return \StructType\HouseData
     */
    public function setFull_address(\StructType\FullAddress $full_address = null)
    {
        $this->full_address = $full_address;
        return $this;
    }
}
