<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetOrganizationListChangesHandlerResponse StructType
 * @subpackage Structs
 */
class GetOrganizationListChangesHandlerResponse extends AbstractStructBase
{
    /**
     * The data
     * @var \ArrayType\ArrayOfCompanyProfileChangesData
     */
    public $data;
    /**
     * The page_number
     * @var int
     */
    public $page_number;
    /**
     * The page_count
     * @var int
     */
    public $page_count;
    /**
     * Constructor method for GetOrganizationListChangesHandlerResponse
     * @uses GetOrganizationListChangesHandlerResponse::setData()
     * @uses GetOrganizationListChangesHandlerResponse::setPage_number()
     * @uses GetOrganizationListChangesHandlerResponse::setPage_count()
     * @param \ArrayType\ArrayOfCompanyProfileChangesData $data
     * @param int $page_number
     * @param int $page_count
     */
    public function __construct(\ArrayType\ArrayOfCompanyProfileChangesData $data = null, $page_number = null, $page_count = null)
    {
        $this
            ->setData($data)
            ->setPage_number($page_number)
            ->setPage_count($page_count);
    }
    /**
     * Get data value
     * @return \ArrayType\ArrayOfCompanyProfileChangesData|null
     */
    public function getData()
    {
        return $this->data;
    }
    /**
     * Set data value
     * @param \ArrayType\ArrayOfCompanyProfileChangesData $data
     * @return \StructType\GetOrganizationListChangesHandlerResponse
     */
    public function setData(\ArrayType\ArrayOfCompanyProfileChangesData $data = null)
    {
        $this->data = $data;
        return $this;
    }
    /**
     * Get page_number value
     * @return int|null
     */
    public function getPage_number()
    {
        return $this->page_number;
    }
    /**
     * Set page_number value
     * @param int $page_number
     * @return \StructType\GetOrganizationListChangesHandlerResponse
     */
    public function setPage_number($page_number = null)
    {
        // validation for constraint: int
        if (!is_null($page_number) && !(is_int($page_number) || ctype_digit($page_number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($page_number, true), gettype($page_number)), __LINE__);
        }
        $this->page_number = $page_number;
        return $this;
    }
    /**
     * Get page_count value
     * @return int|null
     */
    public function getPage_count()
    {
        return $this->page_count;
    }
    /**
     * Set page_count value
     * @param int $page_count
     * @return \StructType\GetOrganizationListChangesHandlerResponse
     */
    public function setPage_count($page_count = null)
    {
        // validation for constraint: int
        if (!is_null($page_count) && !(is_int($page_count) || ctype_digit($page_count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($page_count, true), gettype($page_count)), __LINE__);
        }
        $this->page_count = $page_count;
        return $this;
    }
}
