<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Set ServiceType
 * @subpackage Services
 */
class Set extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SetRequestForSubmit
     * Meta information extracted from the WSDL
     * - documentation: SetRequestForSubmit
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetRequestForSubmit $parameters
     * @return \StructType\SetRequestForSubmitResponse|bool
     */
    public function SetRequestForSubmit(\StructType\SetRequestForSubmit $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetRequestForSubmit($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetHouseProfile
     * Meta information extracted from the WSDL
     * - documentation: Метод изменяет данные текущей анкеты дома с соответствующим ID дома.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetHouseProfile $parameters
     * @return void|bool
     */
    public function SetHouseProfile(\StructType\SetHouseProfile $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetHouseProfile($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetHouseProfile988
     * Meta information extracted from the WSDL
     * - documentation: Метод изменяет данные текущей анкеты дома с соответствующим ID дома.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetHouseProfile988 $parameters
     * @return void|bool
     */
    public function SetHouseProfile988(\StructType\SetHouseProfile988 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetHouseProfile988($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetHouseLinkToOrganization
     * Meta information extracted from the WSDL
     * - documentation: Метод добавления дома с соответсвующим ID, в управление организации с соответствующим ИНН.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetHouseLinkToOrganization $parameters
     * @return void|bool
     */
    public function SetHouseLinkToOrganization(\StructType\SetHouseLinkToOrganization $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetHouseLinkToOrganization($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetNewHouse
     * Meta information extracted from the WSDL
     * - documentation: Метод добавления нового дома с соответствующим адресом по ФИАС.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetNewHouse $parameters
     * @return \StructType\SetNewHouseResponse|bool
     */
    public function SetNewHouse(\StructType\SetNewHouse $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetNewHouse($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetUnlinkFromOrganization
     * Meta information extracted from the WSDL
     * - documentation: Прекращает управление домом с соответствующим ID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetUnlinkFromOrganization $parameters
     * @return void|bool
     */
    public function SetUnlinkFromOrganization(\StructType\SetUnlinkFromOrganization $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetUnlinkFromOrganization($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetNewCompany
     * Meta information extracted from the WSDL
     * - documentation: SetNewCompany
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetNewCompany $parameters
     * @return void|bool
     */
    public function SetNewCompany(\StructType\SetNewCompany $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetNewCompany($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetCompanyProfile
     * Meta information extracted from the WSDL
     * - documentation: Метод изменяет данные по анкете управляющей организации с соответствующим ИНН за указанный отчетный период.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetCompanyProfile $parameters
     * @return void|bool
     */
    public function SetCompanyProfile(\StructType\SetCompanyProfile $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetCompanyProfile($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetCompanyProfile988
     * Meta information extracted from the WSDL
     * - documentation: Метод изменяет данные по анкете управляющей организации с соответствующим ИНН за указанный отчетный период.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetCompanyProfile988 $parameters
     * @return void|bool
     */
    public function SetCompanyProfile988(\StructType\SetCompanyProfile988 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetCompanyProfile988($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetUploadFile
     * Meta information extracted from the WSDL
     * - documentation: Метод загрузки файла для последующей работы в анкетах УО или МКД
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetUploadFile $parameters
     * @return \StructType\SetUploadFileResponse|bool
     */
    public function SetUploadFile(\StructType\SetUploadFile $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetUploadFile($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return void|\StructType\SetNewHouseResponse|\StructType\SetRequestForSubmitResponse|\StructType\SetUploadFileResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
