<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HouseReportClaimsToConsumers StructType
 * @subpackage Structs
 */
class HouseReportClaimsToConsumers extends AbstractStructBase
{
    /**
     * The sent_claims_count
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $sent_claims_count;
    /**
     * The filed_actions_count
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $filed_actions_count;
    /**
     * The received_cash_amount
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $received_cash_amount;
    /**
     * Constructor method for HouseReportClaimsToConsumers
     * @uses HouseReportClaimsToConsumers::setSent_claims_count()
     * @uses HouseReportClaimsToConsumers::setFiled_actions_count()
     * @uses HouseReportClaimsToConsumers::setReceived_cash_amount()
     * @param int $sent_claims_count
     * @param int $filed_actions_count
     * @param float $received_cash_amount
     */
    public function __construct($sent_claims_count = null, $filed_actions_count = null, $received_cash_amount = null)
    {
        $this
            ->setSent_claims_count($sent_claims_count)
            ->setFiled_actions_count($filed_actions_count)
            ->setReceived_cash_amount($received_cash_amount);
    }
    /**
     * Get sent_claims_count value
     * @return int|null
     */
    public function getSent_claims_count()
    {
        return $this->sent_claims_count;
    }
    /**
     * Set sent_claims_count value
     * @param int $sent_claims_count
     * @return \StructType\HouseReportClaimsToConsumers
     */
    public function setSent_claims_count($sent_claims_count = null)
    {
        // validation for constraint: int
        if (!is_null($sent_claims_count) && !is_numeric($sent_claims_count)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sent_claims_count)), __LINE__);
        }
        $this->sent_claims_count = $sent_claims_count;
        return $this;
    }
    /**
     * Get filed_actions_count value
     * @return int|null
     */
    public function getFiled_actions_count()
    {
        return $this->filed_actions_count;
    }
    /**
     * Set filed_actions_count value
     * @param int $filed_actions_count
     * @return \StructType\HouseReportClaimsToConsumers
     */
    public function setFiled_actions_count($filed_actions_count = null)
    {
        // validation for constraint: int
        if (!is_null($filed_actions_count) && !is_numeric($filed_actions_count)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($filed_actions_count)), __LINE__);
        }
        $this->filed_actions_count = $filed_actions_count;
        return $this;
    }
    /**
     * Get received_cash_amount value
     * @return float|null
     */
    public function getReceived_cash_amount()
    {
        return $this->received_cash_amount;
    }
    /**
     * Set received_cash_amount value
     * @param float $received_cash_amount
     * @return \StructType\HouseReportClaimsToConsumers
     */
    public function setReceived_cash_amount($received_cash_amount = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($received_cash_amount) && strlen(substr($received_cash_amount, strpos($received_cash_amount, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($received_cash_amount, strpos($received_cash_amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($received_cash_amount) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $received_cash_amount)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($received_cash_amount, strpos($received_cash_amount, '.')))), __LINE__);
        }
        $this->received_cash_amount = $received_cash_amount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HouseReportClaimsToConsumers
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
