<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FiasAddress StructType
 * @subpackage Structs
 */
class FiasAddress extends AbstractStructBase
{
    /**
     * The city_id
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $city_id;
    /**
     * The street_id
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $street_id;
    /**
     * The houseguid
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $houseguid;
    /**
     * The house_number
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $house_number;
    /**
     * The building
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $building;
    /**
     * The block
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $block;
    /**
     * The room_number
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $room_number;
    /**
     * The letter
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $letter;
    /**
     * The structure
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $structure;
    /**
     * Constructor method for FiasAddress
     * @uses FiasAddress::setCity_id()
     * @uses FiasAddress::setStreet_id()
     * @uses FiasAddress::setHouseguid()
     * @uses FiasAddress::setHouse_number()
     * @uses FiasAddress::setBuilding()
     * @uses FiasAddress::setBlock()
     * @uses FiasAddress::setRoom_number()
     * @uses FiasAddress::setLetter()
     * @uses FiasAddress::setStructure()
     * @param string $city_id
     * @param string $street_id
     * @param string $houseguid
     * @param string $house_number
     * @param string $building
     * @param string $block
     * @param string $room_number
     * @param string $letter
     * @param string $structure
     */
    public function __construct($city_id = null, $street_id = null, $houseguid = null, $house_number = null, $building = null, $block = null, $room_number = null, $letter = null, $structure = null)
    {
        $this
            ->setCity_id($city_id)
            ->setStreet_id($street_id)
            ->setHouseguid($houseguid)
            ->setHouse_number($house_number)
            ->setBuilding($building)
            ->setBlock($block)
            ->setRoom_number($room_number)
            ->setLetter($letter)
            ->setStructure($structure);
    }
    /**
     * Get city_id value
     * @return string|null
     */
    public function getCity_id()
    {
        return $this->city_id;
    }
    /**
     * Set city_id value
     * @param string $city_id
     * @return \StructType\FiasAddress
     */
    public function setCity_id($city_id = null)
    {
        // validation for constraint: string
        if (!is_null($city_id) && !is_string($city_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city_id)), __LINE__);
        }
        $this->city_id = $city_id;
        return $this;
    }
    /**
     * Get street_id value
     * @return string|null
     */
    public function getStreet_id()
    {
        return $this->street_id;
    }
    /**
     * Set street_id value
     * @param string $street_id
     * @return \StructType\FiasAddress
     */
    public function setStreet_id($street_id = null)
    {
        // validation for constraint: string
        if (!is_null($street_id) && !is_string($street_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($street_id)), __LINE__);
        }
        $this->street_id = $street_id;
        return $this;
    }
    /**
     * Get houseguid value
     * @return string|null
     */
    public function getHouseguid()
    {
        return $this->houseguid;
    }
    /**
     * Set houseguid value
     * @param string $houseguid
     * @return \StructType\FiasAddress
     */
    public function setHouseguid($houseguid = null)
    {
        // validation for constraint: string
        if (!is_null($houseguid) && !is_string($houseguid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($houseguid)), __LINE__);
        }
        $this->houseguid = $houseguid;
        return $this;
    }
    /**
     * Get house_number value
     * @return string|null
     */
    public function getHouse_number()
    {
        return $this->house_number;
    }
    /**
     * Set house_number value
     * @param string $house_number
     * @return \StructType\FiasAddress
     */
    public function setHouse_number($house_number = null)
    {
        // validation for constraint: string
        if (!is_null($house_number) && !is_string($house_number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($house_number)), __LINE__);
        }
        $this->house_number = $house_number;
        return $this;
    }
    /**
     * Get building value
     * @return string|null
     */
    public function getBuilding()
    {
        return $this->building;
    }
    /**
     * Set building value
     * @param string $building
     * @return \StructType\FiasAddress
     */
    public function setBuilding($building = null)
    {
        // validation for constraint: string
        if (!is_null($building) && !is_string($building)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($building)), __LINE__);
        }
        $this->building = $building;
        return $this;
    }
    /**
     * Get block value
     * @return string|null
     */
    public function getBlock()
    {
        return $this->block;
    }
    /**
     * Set block value
     * @param string $block
     * @return \StructType\FiasAddress
     */
    public function setBlock($block = null)
    {
        // validation for constraint: string
        if (!is_null($block) && !is_string($block)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($block)), __LINE__);
        }
        $this->block = $block;
        return $this;
    }
    /**
     * Get room_number value
     * @return string|null
     */
    public function getRoom_number()
    {
        return $this->room_number;
    }
    /**
     * Set room_number value
     * @param string $room_number
     * @return \StructType\FiasAddress
     */
    public function setRoom_number($room_number = null)
    {
        // validation for constraint: string
        if (!is_null($room_number) && !is_string($room_number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($room_number)), __LINE__);
        }
        $this->room_number = $room_number;
        return $this;
    }
    /**
     * Get letter value
     * @return string|null
     */
    public function getLetter()
    {
        return $this->letter;
    }
    /**
     * Set letter value
     * @param string $letter
     * @return \StructType\FiasAddress
     */
    public function setLetter($letter = null)
    {
        // validation for constraint: string
        if (!is_null($letter) && !is_string($letter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($letter)), __LINE__);
        }
        $this->letter = $letter;
        return $this;
    }
    /**
     * Get structure value
     * @return string|null
     */
    public function getStructure()
    {
        return $this->structure;
    }
    /**
     * Set structure value
     * @param string $structure
     * @return \StructType\FiasAddress
     */
    public function setStructure($structure = null)
    {
        // validation for constraint: string
        if (!is_null($structure) && !is_string($structure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($structure)), __LINE__);
        }
        $this->structure = $structure;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FiasAddress
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
