<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ManagementContract StructType
 * @subpackage Structs
 */
class ManagementContract extends AbstractStructBase
{
    /**
     * The contract_type
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $contract_type;
    /**
     * The date_start
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $date_start;
    /**
     * The plan_date_stop
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $plan_date_stop;
    /**
     * The jobs
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $jobs;
    /**
     * The job_files
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfInt
     */
    public $job_files;
    /**
     * The responsibility
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $responsibility;
    /**
     * The responsibility_files
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfInt
     */
    public $responsibility_files;
    /**
     * The notice
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $notice;
    /**
     * The service_cost
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $service_cost;
    /**
     * The service_cost_files
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfInt
     */
    public $service_cost_files;
    /**
     * The resources_tsz_zsk
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $resources_tsz_zsk;
    /**
     * The resources_tsz_zsk_files
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfInt
     */
    public $resources_tsz_zsk_files;
    /**
     * The terms_service_tsz_zsk
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $terms_service_tsz_zsk;
    /**
     * The terms_service_tsz_zsk_files
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfInt
     */
    public $terms_service_tsz_zsk_files;
    /**
     * Constructor method for ManagementContract
     * @uses ManagementContract::setContract_type()
     * @uses ManagementContract::setDate_start()
     * @uses ManagementContract::setPlan_date_stop()
     * @uses ManagementContract::setJobs()
     * @uses ManagementContract::setJob_files()
     * @uses ManagementContract::setResponsibility()
     * @uses ManagementContract::setResponsibility_files()
     * @uses ManagementContract::setNotice()
     * @uses ManagementContract::setService_cost()
     * @uses ManagementContract::setService_cost_files()
     * @uses ManagementContract::setResources_tsz_zsk()
     * @uses ManagementContract::setResources_tsz_zsk_files()
     * @uses ManagementContract::setTerms_service_tsz_zsk()
     * @uses ManagementContract::setTerms_service_tsz_zsk_files()
     * @param string $contract_type
     * @param string $date_start
     * @param string $plan_date_stop
     * @param string $jobs
     * @param \ArrayType\ArrayOfInt $job_files
     * @param string $responsibility
     * @param \ArrayType\ArrayOfInt $responsibility_files
     * @param string $notice
     * @param string $service_cost
     * @param \ArrayType\ArrayOfInt $service_cost_files
     * @param string $resources_tsz_zsk
     * @param \ArrayType\ArrayOfInt $resources_tsz_zsk_files
     * @param string $terms_service_tsz_zsk
     * @param \ArrayType\ArrayOfInt $terms_service_tsz_zsk_files
     */
    public function __construct($contract_type = null, $date_start = null, $plan_date_stop = null, $jobs = null, \ArrayType\ArrayOfInt $job_files = null, $responsibility = null, \ArrayType\ArrayOfInt $responsibility_files = null, $notice = null, $service_cost = null, \ArrayType\ArrayOfInt $service_cost_files = null, $resources_tsz_zsk = null, \ArrayType\ArrayOfInt $resources_tsz_zsk_files = null, $terms_service_tsz_zsk = null, \ArrayType\ArrayOfInt $terms_service_tsz_zsk_files = null)
    {
        $this
            ->setContract_type($contract_type)
            ->setDate_start($date_start)
            ->setPlan_date_stop($plan_date_stop)
            ->setJobs($jobs)
            ->setJob_files($job_files)
            ->setResponsibility($responsibility)
            ->setResponsibility_files($responsibility_files)
            ->setNotice($notice)
            ->setService_cost($service_cost)
            ->setService_cost_files($service_cost_files)
            ->setResources_tsz_zsk($resources_tsz_zsk)
            ->setResources_tsz_zsk_files($resources_tsz_zsk_files)
            ->setTerms_service_tsz_zsk($terms_service_tsz_zsk)
            ->setTerms_service_tsz_zsk_files($terms_service_tsz_zsk_files);
    }
    /**
     * Get contract_type value
     * @return string|null
     */
    public function getContract_type()
    {
        return $this->contract_type;
    }
    /**
     * Set contract_type value
     * @uses \EnumType\ContractTypeEnum::valueIsValid()
     * @uses \EnumType\ContractTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $contract_type
     * @return \StructType\ManagementContract
     */
    public function setContract_type($contract_type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ContractTypeEnum::valueIsValid($contract_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ContractTypeEnum', is_array($contract_type) ? implode(', ', $contract_type) : var_export($contract_type, true), implode(', ', \EnumType\ContractTypeEnum::getValidValues())), __LINE__);
        }
        $this->contract_type = $contract_type;
        return $this;
    }
    /**
     * Get date_start value
     * @return string|null
     */
    public function getDate_start()
    {
        return $this->date_start;
    }
    /**
     * Set date_start value
     * @param string $date_start
     * @return \StructType\ManagementContract
     */
    public function setDate_start($date_start = null)
    {
        // validation for constraint: string
        if (!is_null($date_start) && !is_string($date_start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date_start, true), gettype($date_start)), __LINE__);
        }
        $this->date_start = $date_start;
        return $this;
    }
    /**
     * Get plan_date_stop value
     * @return string|null
     */
    public function getPlan_date_stop()
    {
        return $this->plan_date_stop;
    }
    /**
     * Set plan_date_stop value
     * @param string $plan_date_stop
     * @return \StructType\ManagementContract
     */
    public function setPlan_date_stop($plan_date_stop = null)
    {
        // validation for constraint: string
        if (!is_null($plan_date_stop) && !is_string($plan_date_stop)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plan_date_stop, true), gettype($plan_date_stop)), __LINE__);
        }
        $this->plan_date_stop = $plan_date_stop;
        return $this;
    }
    /**
     * Get jobs value
     * @return string|null
     */
    public function getJobs()
    {
        return $this->jobs;
    }
    /**
     * Set jobs value
     * @param string $jobs
     * @return \StructType\ManagementContract
     */
    public function setJobs($jobs = null)
    {
        // validation for constraint: string
        if (!is_null($jobs) && !is_string($jobs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jobs, true), gettype($jobs)), __LINE__);
        }
        $this->jobs = $jobs;
        return $this;
    }
    /**
     * Get job_files value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getJob_files()
    {
        return $this->job_files;
    }
    /**
     * Set job_files value
     * @param \ArrayType\ArrayOfInt $job_files
     * @return \StructType\ManagementContract
     */
    public function setJob_files(\ArrayType\ArrayOfInt $job_files = null)
    {
        $this->job_files = $job_files;
        return $this;
    }
    /**
     * Get responsibility value
     * @return string|null
     */
    public function getResponsibility()
    {
        return $this->responsibility;
    }
    /**
     * Set responsibility value
     * @param string $responsibility
     * @return \StructType\ManagementContract
     */
    public function setResponsibility($responsibility = null)
    {
        // validation for constraint: string
        if (!is_null($responsibility) && !is_string($responsibility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responsibility, true), gettype($responsibility)), __LINE__);
        }
        $this->responsibility = $responsibility;
        return $this;
    }
    /**
     * Get responsibility_files value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getResponsibility_files()
    {
        return $this->responsibility_files;
    }
    /**
     * Set responsibility_files value
     * @param \ArrayType\ArrayOfInt $responsibility_files
     * @return \StructType\ManagementContract
     */
    public function setResponsibility_files(\ArrayType\ArrayOfInt $responsibility_files = null)
    {
        $this->responsibility_files = $responsibility_files;
        return $this;
    }
    /**
     * Get notice value
     * @return string|null
     */
    public function getNotice()
    {
        return $this->notice;
    }
    /**
     * Set notice value
     * @param string $notice
     * @return \StructType\ManagementContract
     */
    public function setNotice($notice = null)
    {
        // validation for constraint: string
        if (!is_null($notice) && !is_string($notice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notice, true), gettype($notice)), __LINE__);
        }
        $this->notice = $notice;
        return $this;
    }
    /**
     * Get service_cost value
     * @return string|null
     */
    public function getService_cost()
    {
        return $this->service_cost;
    }
    /**
     * Set service_cost value
     * @param string $service_cost
     * @return \StructType\ManagementContract
     */
    public function setService_cost($service_cost = null)
    {
        // validation for constraint: string
        if (!is_null($service_cost) && !is_string($service_cost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($service_cost, true), gettype($service_cost)), __LINE__);
        }
        $this->service_cost = $service_cost;
        return $this;
    }
    /**
     * Get service_cost_files value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getService_cost_files()
    {
        return $this->service_cost_files;
    }
    /**
     * Set service_cost_files value
     * @param \ArrayType\ArrayOfInt $service_cost_files
     * @return \StructType\ManagementContract
     */
    public function setService_cost_files(\ArrayType\ArrayOfInt $service_cost_files = null)
    {
        $this->service_cost_files = $service_cost_files;
        return $this;
    }
    /**
     * Get resources_tsz_zsk value
     * @return string|null
     */
    public function getResources_tsz_zsk()
    {
        return $this->resources_tsz_zsk;
    }
    /**
     * Set resources_tsz_zsk value
     * @param string $resources_tsz_zsk
     * @return \StructType\ManagementContract
     */
    public function setResources_tsz_zsk($resources_tsz_zsk = null)
    {
        // validation for constraint: string
        if (!is_null($resources_tsz_zsk) && !is_string($resources_tsz_zsk)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resources_tsz_zsk, true), gettype($resources_tsz_zsk)), __LINE__);
        }
        $this->resources_tsz_zsk = $resources_tsz_zsk;
        return $this;
    }
    /**
     * Get resources_tsz_zsk_files value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getResources_tsz_zsk_files()
    {
        return $this->resources_tsz_zsk_files;
    }
    /**
     * Set resources_tsz_zsk_files value
     * @param \ArrayType\ArrayOfInt $resources_tsz_zsk_files
     * @return \StructType\ManagementContract
     */
    public function setResources_tsz_zsk_files(\ArrayType\ArrayOfInt $resources_tsz_zsk_files = null)
    {
        $this->resources_tsz_zsk_files = $resources_tsz_zsk_files;
        return $this;
    }
    /**
     * Get terms_service_tsz_zsk value
     * @return string|null
     */
    public function getTerms_service_tsz_zsk()
    {
        return $this->terms_service_tsz_zsk;
    }
    /**
     * Set terms_service_tsz_zsk value
     * @param string $terms_service_tsz_zsk
     * @return \StructType\ManagementContract
     */
    public function setTerms_service_tsz_zsk($terms_service_tsz_zsk = null)
    {
        // validation for constraint: string
        if (!is_null($terms_service_tsz_zsk) && !is_string($terms_service_tsz_zsk)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($terms_service_tsz_zsk, true), gettype($terms_service_tsz_zsk)), __LINE__);
        }
        $this->terms_service_tsz_zsk = $terms_service_tsz_zsk;
        return $this;
    }
    /**
     * Get terms_service_tsz_zsk_files value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getTerms_service_tsz_zsk_files()
    {
        return $this->terms_service_tsz_zsk_files;
    }
    /**
     * Set terms_service_tsz_zsk_files value
     * @param \ArrayType\ArrayOfInt $terms_service_tsz_zsk_files
     * @return \StructType\ManagementContract
     */
    public function setTerms_service_tsz_zsk_files(\ArrayType\ArrayOfInt $terms_service_tsz_zsk_files = null)
    {
        $this->terms_service_tsz_zsk_files = $terms_service_tsz_zsk_files;
        return $this;
    }
}
