<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClaimsByContractsMng StructType
 * @subpackage Structs
 */
class ClaimsByContractsMng extends AbstractStructBase
{
    /**
     * The claims_by_contracts_mng
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var float
     */
    public $claims_by_contracts_mng;
    /**
     * The claims_for_damage
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var float
     */
    public $claims_for_damage;
    /**
     * The claims_for_refusal
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var float
     */
    public $claims_for_refusal;
    /**
     * The claims_for_short_shipment
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var float
     */
    public $claims_for_short_shipment;
    /**
     * Constructor method for ClaimsByContractsMng
     * @uses ClaimsByContractsMng::setClaims_by_contracts_mng()
     * @uses ClaimsByContractsMng::setClaims_for_damage()
     * @uses ClaimsByContractsMng::setClaims_for_refusal()
     * @uses ClaimsByContractsMng::setClaims_for_short_shipment()
     * @param float $claims_by_contracts_mng
     * @param float $claims_for_damage
     * @param float $claims_for_refusal
     * @param float $claims_for_short_shipment
     */
    public function __construct($claims_by_contracts_mng = null, $claims_for_damage = null, $claims_for_refusal = null, $claims_for_short_shipment = null)
    {
        $this
            ->setClaims_by_contracts_mng($claims_by_contracts_mng)
            ->setClaims_for_damage($claims_for_damage)
            ->setClaims_for_refusal($claims_for_refusal)
            ->setClaims_for_short_shipment($claims_for_short_shipment);
    }
    /**
     * Get claims_by_contracts_mng value
     * @return float|null
     */
    public function getClaims_by_contracts_mng()
    {
        return $this->claims_by_contracts_mng;
    }
    /**
     * Set claims_by_contracts_mng value
     * @param float $claims_by_contracts_mng
     * @return \StructType\ClaimsByContractsMng
     */
    public function setClaims_by_contracts_mng($claims_by_contracts_mng = null)
    {
        // validation for constraint: float
        if (!is_null($claims_by_contracts_mng) && !(is_float($claims_by_contracts_mng) || is_numeric($claims_by_contracts_mng))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($claims_by_contracts_mng, true), gettype($claims_by_contracts_mng)), __LINE__);
        }
        $this->claims_by_contracts_mng = $claims_by_contracts_mng;
        return $this;
    }
    /**
     * Get claims_for_damage value
     * @return float|null
     */
    public function getClaims_for_damage()
    {
        return $this->claims_for_damage;
    }
    /**
     * Set claims_for_damage value
     * @param float $claims_for_damage
     * @return \StructType\ClaimsByContractsMng
     */
    public function setClaims_for_damage($claims_for_damage = null)
    {
        // validation for constraint: float
        if (!is_null($claims_for_damage) && !(is_float($claims_for_damage) || is_numeric($claims_for_damage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($claims_for_damage, true), gettype($claims_for_damage)), __LINE__);
        }
        $this->claims_for_damage = $claims_for_damage;
        return $this;
    }
    /**
     * Get claims_for_refusal value
     * @return float|null
     */
    public function getClaims_for_refusal()
    {
        return $this->claims_for_refusal;
    }
    /**
     * Set claims_for_refusal value
     * @param float $claims_for_refusal
     * @return \StructType\ClaimsByContractsMng
     */
    public function setClaims_for_refusal($claims_for_refusal = null)
    {
        // validation for constraint: float
        if (!is_null($claims_for_refusal) && !(is_float($claims_for_refusal) || is_numeric($claims_for_refusal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($claims_for_refusal, true), gettype($claims_for_refusal)), __LINE__);
        }
        $this->claims_for_refusal = $claims_for_refusal;
        return $this;
    }
    /**
     * Get claims_for_short_shipment value
     * @return float|null
     */
    public function getClaims_for_short_shipment()
    {
        return $this->claims_for_short_shipment;
    }
    /**
     * Set claims_for_short_shipment value
     * @param float $claims_for_short_shipment
     * @return \StructType\ClaimsByContractsMng
     */
    public function setClaims_for_short_shipment($claims_for_short_shipment = null)
    {
        // validation for constraint: float
        if (!is_null($claims_for_short_shipment) && !(is_float($claims_for_short_shipment) || is_numeric($claims_for_short_shipment))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($claims_for_short_shipment, true), gettype($claims_for_short_shipment)), __LINE__);
        }
        $this->claims_for_short_shipment = $claims_for_short_shipment;
        return $this;
    }
}
