<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HouseReportClaimsToConsumers StructType
 * @subpackage Structs
 */
class HouseReportClaimsToConsumers extends AbstractStructBase
{
    /**
     * The sent_claims_count
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $sent_claims_count;
    /**
     * The filed_actions_count
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $filed_actions_count;
    /**
     * The received_cash_amount
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $received_cash_amount;
    /**
     * Constructor method for HouseReportClaimsToConsumers
     * @uses HouseReportClaimsToConsumers::setSent_claims_count()
     * @uses HouseReportClaimsToConsumers::setFiled_actions_count()
     * @uses HouseReportClaimsToConsumers::setReceived_cash_amount()
     * @param int $sent_claims_count
     * @param int $filed_actions_count
     * @param float $received_cash_amount
     */
    public function __construct($sent_claims_count = null, $filed_actions_count = null, $received_cash_amount = null)
    {
        $this
            ->setSent_claims_count($sent_claims_count)
            ->setFiled_actions_count($filed_actions_count)
            ->setReceived_cash_amount($received_cash_amount);
    }
    /**
     * Get sent_claims_count value
     * @return int|null
     */
    public function getSent_claims_count()
    {
        return $this->sent_claims_count;
    }
    /**
     * Set sent_claims_count value
     * @param int $sent_claims_count
     * @return \StructType\HouseReportClaimsToConsumers
     */
    public function setSent_claims_count($sent_claims_count = null)
    {
        // validation for constraint: int
        if (!is_null($sent_claims_count) && !(is_int($sent_claims_count) || ctype_digit($sent_claims_count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sent_claims_count, true), gettype($sent_claims_count)), __LINE__);
        }
        $this->sent_claims_count = $sent_claims_count;
        return $this;
    }
    /**
     * Get filed_actions_count value
     * @return int|null
     */
    public function getFiled_actions_count()
    {
        return $this->filed_actions_count;
    }
    /**
     * Set filed_actions_count value
     * @param int $filed_actions_count
     * @return \StructType\HouseReportClaimsToConsumers
     */
    public function setFiled_actions_count($filed_actions_count = null)
    {
        // validation for constraint: int
        if (!is_null($filed_actions_count) && !(is_int($filed_actions_count) || ctype_digit($filed_actions_count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($filed_actions_count, true), gettype($filed_actions_count)), __LINE__);
        }
        $this->filed_actions_count = $filed_actions_count;
        return $this;
    }
    /**
     * Get received_cash_amount value
     * @return float|null
     */
    public function getReceived_cash_amount()
    {
        return $this->received_cash_amount;
    }
    /**
     * Set received_cash_amount value
     * @param float $received_cash_amount
     * @return \StructType\HouseReportClaimsToConsumers
     */
    public function setReceived_cash_amount($received_cash_amount = null)
    {
        // validation for constraint: float
        if (!is_null($received_cash_amount) && !(is_float($received_cash_amount) || is_numeric($received_cash_amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($received_cash_amount, true), gettype($received_cash_amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($received_cash_amount) && mb_strlen(mb_substr($received_cash_amount, false !== mb_strpos($received_cash_amount, '.') ? mb_strpos($received_cash_amount, '.') + 1 : mb_strlen($received_cash_amount))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($received_cash_amount, true), mb_strlen(mb_substr($received_cash_amount, mb_strpos($received_cash_amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($received_cash_amount) && mb_strlen(preg_replace('/(\D)/', '', $received_cash_amount)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($received_cash_amount, true), mb_strlen(preg_replace('/(\D)/', '', $received_cash_amount))), __LINE__);
        }
        $this->received_cash_amount = $received_cash_amount;
        return $this;
    }
}
