<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCompanyProfileResponse StructType
 * @subpackage Structs
 */
class GetCompanyProfileResponse extends AbstractStructBase
{
    /**
     * The inn
     * @var string
     */
    public $inn;
    /**
     * The name_full
     * @var string
     */
    public $name_full;
    /**
     * The name_short
     * @var string
     */
    public $name_short;
    /**
     * The company_profile_data
     * @var \StructType\CompanyProfileData
     */
    public $company_profile_data;
    /**
     * The files_info
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfFileInfo
     */
    public $files_info;
    /**
     * The GetCompanyProfileResult
     * @var \StructType\GetCompanyProfileResponse
     */
    public $GetCompanyProfileResult;
    /**
     * Constructor method for GetCompanyProfileResponse
     * @uses GetCompanyProfileResponse::setInn()
     * @uses GetCompanyProfileResponse::setName_full()
     * @uses GetCompanyProfileResponse::setName_short()
     * @uses GetCompanyProfileResponse::setCompany_profile_data()
     * @uses GetCompanyProfileResponse::setFiles_info()
     * @uses GetCompanyProfileResponse::setGetCompanyProfileResult()
     * @param string $inn
     * @param string $name_full
     * @param string $name_short
     * @param \StructType\CompanyProfileData $company_profile_data
     * @param \ArrayType\ArrayOfFileInfo $files_info
     * @param \StructType\GetCompanyProfileResponse $getCompanyProfileResult
     */
    public function __construct($inn = null, $name_full = null, $name_short = null, \StructType\CompanyProfileData $company_profile_data = null, \ArrayType\ArrayOfFileInfo $files_info = null, \StructType\GetCompanyProfileResponse $getCompanyProfileResult = null)
    {
        $this
            ->setInn($inn)
            ->setName_full($name_full)
            ->setName_short($name_short)
            ->setCompany_profile_data($company_profile_data)
            ->setFiles_info($files_info)
            ->setGetCompanyProfileResult($getCompanyProfileResult);
    }
    /**
     * Get inn value
     * @return string|null
     */
    public function getInn()
    {
        return $this->inn;
    }
    /**
     * Set inn value
     * @param string $inn
     * @return \StructType\GetCompanyProfileResponse
     */
    public function setInn($inn = null)
    {
        // validation for constraint: string
        if (!is_null($inn) && !is_string($inn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inn, true), gettype($inn)), __LINE__);
        }
        $this->inn = $inn;
        return $this;
    }
    /**
     * Get name_full value
     * @return string|null
     */
    public function getName_full()
    {
        return $this->name_full;
    }
    /**
     * Set name_full value
     * @param string $name_full
     * @return \StructType\GetCompanyProfileResponse
     */
    public function setName_full($name_full = null)
    {
        // validation for constraint: string
        if (!is_null($name_full) && !is_string($name_full)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name_full, true), gettype($name_full)), __LINE__);
        }
        $this->name_full = $name_full;
        return $this;
    }
    /**
     * Get name_short value
     * @return string|null
     */
    public function getName_short()
    {
        return $this->name_short;
    }
    /**
     * Set name_short value
     * @param string $name_short
     * @return \StructType\GetCompanyProfileResponse
     */
    public function setName_short($name_short = null)
    {
        // validation for constraint: string
        if (!is_null($name_short) && !is_string($name_short)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name_short, true), gettype($name_short)), __LINE__);
        }
        $this->name_short = $name_short;
        return $this;
    }
    /**
     * Get company_profile_data value
     * @return \StructType\CompanyProfileData|null
     */
    public function getCompany_profile_data()
    {
        return $this->company_profile_data;
    }
    /**
     * Set company_profile_data value
     * @param \StructType\CompanyProfileData $company_profile_data
     * @return \StructType\GetCompanyProfileResponse
     */
    public function setCompany_profile_data(\StructType\CompanyProfileData $company_profile_data = null)
    {
        $this->company_profile_data = $company_profile_data;
        return $this;
    }
    /**
     * Get files_info value
     * @return \ArrayType\ArrayOfFileInfo|null
     */
    public function getFiles_info()
    {
        return $this->files_info;
    }
    /**
     * Set files_info value
     * @param \ArrayType\ArrayOfFileInfo $files_info
     * @return \StructType\GetCompanyProfileResponse
     */
    public function setFiles_info(\ArrayType\ArrayOfFileInfo $files_info = null)
    {
        $this->files_info = $files_info;
        return $this;
    }
    /**
     * Get GetCompanyProfileResult value
     * @return \StructType\GetCompanyProfileResponse|null
     */
    public function getGetCompanyProfileResult()
    {
        return $this->GetCompanyProfileResult;
    }
    /**
     * Set GetCompanyProfileResult value
     * @param \StructType\GetCompanyProfileResponse $getCompanyProfileResult
     * @return \StructType\GetCompanyProfileResponse
     */
    public function setGetCompanyProfileResult(\StructType\GetCompanyProfileResponse $getCompanyProfileResult = null)
    {
        $this->GetCompanyProfileResult = $getCompanyProfileResult;
        return $this;
    }
}
