<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetNewCompany StructType
 * @subpackage Structs
 */
class SetNewCompany extends AbstractStructBase
{
    /**
     * The inn
     * @var string
     */
    public $inn;
    /**
     * The new_company_data
     * @var \StructType\NewCompanyProfileData
     */
    public $new_company_data;
    /**
     * Constructor method for SetNewCompany
     * @uses SetNewCompany::setInn()
     * @uses SetNewCompany::setNew_company_data()
     * @param string $inn
     * @param \StructType\NewCompanyProfileData $new_company_data
     */
    public function __construct($inn = null, \StructType\NewCompanyProfileData $new_company_data = null)
    {
        $this
            ->setInn($inn)
            ->setNew_company_data($new_company_data);
    }
    /**
     * Get inn value
     * @return string|null
     */
    public function getInn()
    {
        return $this->inn;
    }
    /**
     * Set inn value
     * @param string $inn
     * @return \StructType\SetNewCompany
     */
    public function setInn($inn = null)
    {
        // validation for constraint: string
        if (!is_null($inn) && !is_string($inn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inn, true), gettype($inn)), __LINE__);
        }
        $this->inn = $inn;
        return $this;
    }
    /**
     * Get new_company_data value
     * @return \StructType\NewCompanyProfileData|null
     */
    public function getNew_company_data()
    {
        return $this->new_company_data;
    }
    /**
     * Set new_company_data value
     * @param \StructType\NewCompanyProfileData $new_company_data
     * @return \StructType\SetNewCompany
     */
    public function setNew_company_data(\StructType\NewCompanyProfileData $new_company_data = null)
    {
        $this->new_company_data = $new_company_data;
        return $this;
    }
}
