<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HouseServiceCost StructType
 * @subpackage Structs
 */
class HouseServiceCost extends AbstractStructBase
{
    /**
     * The year
     * @var int
     */
    public $year;
    /**
     * The plan_cost_per_unit
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $plan_cost_per_unit;
    /**
     * Constructor method for HouseServiceCost
     * @uses HouseServiceCost::setYear()
     * @uses HouseServiceCost::setPlan_cost_per_unit()
     * @param int $year
     * @param float $plan_cost_per_unit
     */
    public function __construct($year = null, $plan_cost_per_unit = null)
    {
        $this
            ->setYear($year)
            ->setPlan_cost_per_unit($plan_cost_per_unit);
    }
    /**
     * Get year value
     * @return int|null
     */
    public function getYear()
    {
        return $this->year;
    }
    /**
     * Set year value
     * @param int $year
     * @return \StructType\HouseServiceCost
     */
    public function setYear($year = null)
    {
        // validation for constraint: int
        if (!is_null($year) && !is_numeric($year)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($year)), __LINE__);
        }
        $this->year = $year;
        return $this;
    }
    /**
     * Get plan_cost_per_unit value
     * @return float|null
     */
    public function getPlan_cost_per_unit()
    {
        return $this->plan_cost_per_unit;
    }
    /**
     * Set plan_cost_per_unit value
     * @param float $plan_cost_per_unit
     * @return \StructType\HouseServiceCost
     */
    public function setPlan_cost_per_unit($plan_cost_per_unit = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($plan_cost_per_unit) && strlen(substr($plan_cost_per_unit, strpos($plan_cost_per_unit, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($plan_cost_per_unit, strpos($plan_cost_per_unit, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($plan_cost_per_unit) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $plan_cost_per_unit)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($plan_cost_per_unit, strpos($plan_cost_per_unit, '.')))), __LINE__);
        }
        $this->plan_cost_per_unit = $plan_cost_per_unit;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HouseServiceCost
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
