<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HouseReportCommunalService StructType
 * @subpackage Structs
 */
class HouseReportCommunalService extends AbstractStructBase
{
    /**
     * The balance_beginning_period
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $balance_beginning_period;
    /**
     * The balance_beginning_period_consumers_overpayment
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $balance_beginning_period_consumers_overpayment;
    /**
     * The balance_beginning_period_consumers_arrears
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $balance_beginning_period_consumers_arrears;
    /**
     * The balance_ending_period
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $balance_ending_period;
    /**
     * The balance_ending_period_consumers_overpayment
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $balance_ending_period_consumers_overpayment;
    /**
     * The balance_ending_period_consumers_arrears
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $balance_ending_period_consumers_arrears;
    /**
     * The claims_received_count
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $claims_received_count;
    /**
     * The claims_satisfied_count
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $claims_satisfied_count;
    /**
     * The claims_denied_count
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $claims_denied_count;
    /**
     * The produced_recalculation_amount
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $produced_recalculation_amount;
    /**
     * Constructor method for HouseReportCommunalService
     * @uses HouseReportCommunalService::setBalance_beginning_period()
     * @uses HouseReportCommunalService::setBalance_beginning_period_consumers_overpayment()
     * @uses HouseReportCommunalService::setBalance_beginning_period_consumers_arrears()
     * @uses HouseReportCommunalService::setBalance_ending_period()
     * @uses HouseReportCommunalService::setBalance_ending_period_consumers_overpayment()
     * @uses HouseReportCommunalService::setBalance_ending_period_consumers_arrears()
     * @uses HouseReportCommunalService::setClaims_received_count()
     * @uses HouseReportCommunalService::setClaims_satisfied_count()
     * @uses HouseReportCommunalService::setClaims_denied_count()
     * @uses HouseReportCommunalService::setProduced_recalculation_amount()
     * @param float $balance_beginning_period
     * @param float $balance_beginning_period_consumers_overpayment
     * @param float $balance_beginning_period_consumers_arrears
     * @param float $balance_ending_period
     * @param float $balance_ending_period_consumers_overpayment
     * @param float $balance_ending_period_consumers_arrears
     * @param int $claims_received_count
     * @param int $claims_satisfied_count
     * @param int $claims_denied_count
     * @param float $produced_recalculation_amount
     */
    public function __construct($balance_beginning_period = null, $balance_beginning_period_consumers_overpayment = null, $balance_beginning_period_consumers_arrears = null, $balance_ending_period = null, $balance_ending_period_consumers_overpayment = null, $balance_ending_period_consumers_arrears = null, $claims_received_count = null, $claims_satisfied_count = null, $claims_denied_count = null, $produced_recalculation_amount = null)
    {
        $this
            ->setBalance_beginning_period($balance_beginning_period)
            ->setBalance_beginning_period_consumers_overpayment($balance_beginning_period_consumers_overpayment)
            ->setBalance_beginning_period_consumers_arrears($balance_beginning_period_consumers_arrears)
            ->setBalance_ending_period($balance_ending_period)
            ->setBalance_ending_period_consumers_overpayment($balance_ending_period_consumers_overpayment)
            ->setBalance_ending_period_consumers_arrears($balance_ending_period_consumers_arrears)
            ->setClaims_received_count($claims_received_count)
            ->setClaims_satisfied_count($claims_satisfied_count)
            ->setClaims_denied_count($claims_denied_count)
            ->setProduced_recalculation_amount($produced_recalculation_amount);
    }
    /**
     * Get balance_beginning_period value
     * @return float|null
     */
    public function getBalance_beginning_period()
    {
        return $this->balance_beginning_period;
    }
    /**
     * Set balance_beginning_period value
     * @param float $balance_beginning_period
     * @return \StructType\HouseReportCommunalService
     */
    public function setBalance_beginning_period($balance_beginning_period = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($balance_beginning_period) && strlen(substr($balance_beginning_period, strpos($balance_beginning_period, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($balance_beginning_period, strpos($balance_beginning_period, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($balance_beginning_period) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $balance_beginning_period)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($balance_beginning_period, strpos($balance_beginning_period, '.')))), __LINE__);
        }
        $this->balance_beginning_period = $balance_beginning_period;
        return $this;
    }
    /**
     * Get balance_beginning_period_consumers_overpayment value
     * @return float|null
     */
    public function getBalance_beginning_period_consumers_overpayment()
    {
        return $this->balance_beginning_period_consumers_overpayment;
    }
    /**
     * Set balance_beginning_period_consumers_overpayment value
     * @param float $balance_beginning_period_consumers_overpayment
     * @return \StructType\HouseReportCommunalService
     */
    public function setBalance_beginning_period_consumers_overpayment($balance_beginning_period_consumers_overpayment = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($balance_beginning_period_consumers_overpayment) && strlen(substr($balance_beginning_period_consumers_overpayment, strpos($balance_beginning_period_consumers_overpayment, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($balance_beginning_period_consumers_overpayment, strpos($balance_beginning_period_consumers_overpayment, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($balance_beginning_period_consumers_overpayment) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $balance_beginning_period_consumers_overpayment)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($balance_beginning_period_consumers_overpayment, strpos($balance_beginning_period_consumers_overpayment, '.')))), __LINE__);
        }
        $this->balance_beginning_period_consumers_overpayment = $balance_beginning_period_consumers_overpayment;
        return $this;
    }
    /**
     * Get balance_beginning_period_consumers_arrears value
     * @return float|null
     */
    public function getBalance_beginning_period_consumers_arrears()
    {
        return $this->balance_beginning_period_consumers_arrears;
    }
    /**
     * Set balance_beginning_period_consumers_arrears value
     * @param float $balance_beginning_period_consumers_arrears
     * @return \StructType\HouseReportCommunalService
     */
    public function setBalance_beginning_period_consumers_arrears($balance_beginning_period_consumers_arrears = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($balance_beginning_period_consumers_arrears) && strlen(substr($balance_beginning_period_consumers_arrears, strpos($balance_beginning_period_consumers_arrears, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($balance_beginning_period_consumers_arrears, strpos($balance_beginning_period_consumers_arrears, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($balance_beginning_period_consumers_arrears) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $balance_beginning_period_consumers_arrears)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($balance_beginning_period_consumers_arrears, strpos($balance_beginning_period_consumers_arrears, '.')))), __LINE__);
        }
        $this->balance_beginning_period_consumers_arrears = $balance_beginning_period_consumers_arrears;
        return $this;
    }
    /**
     * Get balance_ending_period value
     * @return float|null
     */
    public function getBalance_ending_period()
    {
        return $this->balance_ending_period;
    }
    /**
     * Set balance_ending_period value
     * @param float $balance_ending_period
     * @return \StructType\HouseReportCommunalService
     */
    public function setBalance_ending_period($balance_ending_period = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($balance_ending_period) && strlen(substr($balance_ending_period, strpos($balance_ending_period, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($balance_ending_period, strpos($balance_ending_period, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($balance_ending_period) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $balance_ending_period)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($balance_ending_period, strpos($balance_ending_period, '.')))), __LINE__);
        }
        $this->balance_ending_period = $balance_ending_period;
        return $this;
    }
    /**
     * Get balance_ending_period_consumers_overpayment value
     * @return float|null
     */
    public function getBalance_ending_period_consumers_overpayment()
    {
        return $this->balance_ending_period_consumers_overpayment;
    }
    /**
     * Set balance_ending_period_consumers_overpayment value
     * @param float $balance_ending_period_consumers_overpayment
     * @return \StructType\HouseReportCommunalService
     */
    public function setBalance_ending_period_consumers_overpayment($balance_ending_period_consumers_overpayment = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($balance_ending_period_consumers_overpayment) && strlen(substr($balance_ending_period_consumers_overpayment, strpos($balance_ending_period_consumers_overpayment, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($balance_ending_period_consumers_overpayment, strpos($balance_ending_period_consumers_overpayment, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($balance_ending_period_consumers_overpayment) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $balance_ending_period_consumers_overpayment)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($balance_ending_period_consumers_overpayment, strpos($balance_ending_period_consumers_overpayment, '.')))), __LINE__);
        }
        $this->balance_ending_period_consumers_overpayment = $balance_ending_period_consumers_overpayment;
        return $this;
    }
    /**
     * Get balance_ending_period_consumers_arrears value
     * @return float|null
     */
    public function getBalance_ending_period_consumers_arrears()
    {
        return $this->balance_ending_period_consumers_arrears;
    }
    /**
     * Set balance_ending_period_consumers_arrears value
     * @param float $balance_ending_period_consumers_arrears
     * @return \StructType\HouseReportCommunalService
     */
    public function setBalance_ending_period_consumers_arrears($balance_ending_period_consumers_arrears = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($balance_ending_period_consumers_arrears) && strlen(substr($balance_ending_period_consumers_arrears, strpos($balance_ending_period_consumers_arrears, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($balance_ending_period_consumers_arrears, strpos($balance_ending_period_consumers_arrears, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($balance_ending_period_consumers_arrears) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $balance_ending_period_consumers_arrears)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($balance_ending_period_consumers_arrears, strpos($balance_ending_period_consumers_arrears, '.')))), __LINE__);
        }
        $this->balance_ending_period_consumers_arrears = $balance_ending_period_consumers_arrears;
        return $this;
    }
    /**
     * Get claims_received_count value
     * @return int|null
     */
    public function getClaims_received_count()
    {
        return $this->claims_received_count;
    }
    /**
     * Set claims_received_count value
     * @param int $claims_received_count
     * @return \StructType\HouseReportCommunalService
     */
    public function setClaims_received_count($claims_received_count = null)
    {
        // validation for constraint: int
        if (!is_null($claims_received_count) && !is_numeric($claims_received_count)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($claims_received_count)), __LINE__);
        }
        $this->claims_received_count = $claims_received_count;
        return $this;
    }
    /**
     * Get claims_satisfied_count value
     * @return int|null
     */
    public function getClaims_satisfied_count()
    {
        return $this->claims_satisfied_count;
    }
    /**
     * Set claims_satisfied_count value
     * @param int $claims_satisfied_count
     * @return \StructType\HouseReportCommunalService
     */
    public function setClaims_satisfied_count($claims_satisfied_count = null)
    {
        // validation for constraint: int
        if (!is_null($claims_satisfied_count) && !is_numeric($claims_satisfied_count)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($claims_satisfied_count)), __LINE__);
        }
        $this->claims_satisfied_count = $claims_satisfied_count;
        return $this;
    }
    /**
     * Get claims_denied_count value
     * @return int|null
     */
    public function getClaims_denied_count()
    {
        return $this->claims_denied_count;
    }
    /**
     * Set claims_denied_count value
     * @param int $claims_denied_count
     * @return \StructType\HouseReportCommunalService
     */
    public function setClaims_denied_count($claims_denied_count = null)
    {
        // validation for constraint: int
        if (!is_null($claims_denied_count) && !is_numeric($claims_denied_count)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($claims_denied_count)), __LINE__);
        }
        $this->claims_denied_count = $claims_denied_count;
        return $this;
    }
    /**
     * Get produced_recalculation_amount value
     * @return float|null
     */
    public function getProduced_recalculation_amount()
    {
        return $this->produced_recalculation_amount;
    }
    /**
     * Set produced_recalculation_amount value
     * @param float $produced_recalculation_amount
     * @return \StructType\HouseReportCommunalService
     */
    public function setProduced_recalculation_amount($produced_recalculation_amount = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($produced_recalculation_amount) && strlen(substr($produced_recalculation_amount, strpos($produced_recalculation_amount, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($produced_recalculation_amount, strpos($produced_recalculation_amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($produced_recalculation_amount) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $produced_recalculation_amount)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($produced_recalculation_amount, strpos($produced_recalculation_amount, '.')))), __LINE__);
        }
        $this->produced_recalculation_amount = $produced_recalculation_amount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HouseReportCommunalService
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
