<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetHouseLinkToOrganization StructType
 * @subpackage Structs
 */
class SetHouseLinkToOrganization extends AbstractStructBase
{
    /**
     * The house_id
     * @var int
     */
    public $house_id;
    /**
     * The inn
     * @var string
     */
    public $inn;
    /**
     * The date_start
     * @var string
     */
    public $date_start;
    /**
     * The management_reason
     * @var string
     */
    public $management_reason;
    /**
     * Constructor method for SetHouseLinkToOrganization
     * @uses SetHouseLinkToOrganization::setHouse_id()
     * @uses SetHouseLinkToOrganization::setInn()
     * @uses SetHouseLinkToOrganization::setDate_start()
     * @uses SetHouseLinkToOrganization::setManagement_reason()
     * @param int $house_id
     * @param string $inn
     * @param string $date_start
     * @param string $management_reason
     */
    public function __construct($house_id = null, $inn = null, $date_start = null, $management_reason = null)
    {
        $this
            ->setHouse_id($house_id)
            ->setInn($inn)
            ->setDate_start($date_start)
            ->setManagement_reason($management_reason);
    }
    /**
     * Get house_id value
     * @return int|null
     */
    public function getHouse_id()
    {
        return $this->house_id;
    }
    /**
     * Set house_id value
     * @param int $house_id
     * @return \StructType\SetHouseLinkToOrganization
     */
    public function setHouse_id($house_id = null)
    {
        // validation for constraint: int
        if (!is_null($house_id) && !is_numeric($house_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($house_id)), __LINE__);
        }
        $this->house_id = $house_id;
        return $this;
    }
    /**
     * Get inn value
     * @return string|null
     */
    public function getInn()
    {
        return $this->inn;
    }
    /**
     * Set inn value
     * @param string $inn
     * @return \StructType\SetHouseLinkToOrganization
     */
    public function setInn($inn = null)
    {
        // validation for constraint: string
        if (!is_null($inn) && !is_string($inn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($inn)), __LINE__);
        }
        $this->inn = $inn;
        return $this;
    }
    /**
     * Get date_start value
     * @return string|null
     */
    public function getDate_start()
    {
        return $this->date_start;
    }
    /**
     * Set date_start value
     * @param string $date_start
     * @return \StructType\SetHouseLinkToOrganization
     */
    public function setDate_start($date_start = null)
    {
        // validation for constraint: string
        if (!is_null($date_start) && !is_string($date_start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date_start)), __LINE__);
        }
        $this->date_start = $date_start;
        return $this;
    }
    /**
     * Get management_reason value
     * @return string|null
     */
    public function getManagement_reason()
    {
        return $this->management_reason;
    }
    /**
     * Set management_reason value
     * @param string $management_reason
     * @return \StructType\SetHouseLinkToOrganization
     */
    public function setManagement_reason($management_reason = null)
    {
        // validation for constraint: string
        if (!is_null($management_reason) && !is_string($management_reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($management_reason)), __LINE__);
        }
        $this->management_reason = $management_reason;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SetHouseLinkToOrganization
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
