<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HouseService StructType
 * @subpackage Structs
 */
class HouseService extends AbstractStructBase
{
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $id;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $name;
    /**
     * The name_other
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $name_other;
    /**
     * The stop_reason_type
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $stop_reason_type;
    /**
     * The stop_reason
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $stop_reason;
    /**
     * The date_stop
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $date_stop;
    /**
     * The report
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\HouseServiceReport
     */
    public $report;
    /**
     * The costs
     * @var \ArrayType\ArrayOfHouseServiceCost
     */
    public $costs;
    /**
     * Constructor method for HouseService
     * @uses HouseService::setId()
     * @uses HouseService::setName()
     * @uses HouseService::setName_other()
     * @uses HouseService::setStop_reason_type()
     * @uses HouseService::setStop_reason()
     * @uses HouseService::setDate_stop()
     * @uses HouseService::setReport()
     * @uses HouseService::setCosts()
     * @param int $id
     * @param string $name
     * @param string $name_other
     * @param string $stop_reason_type
     * @param string $stop_reason
     * @param string $date_stop
     * @param \StructType\HouseServiceReport $report
     * @param \ArrayType\ArrayOfHouseServiceCost $costs
     */
    public function __construct($id = null, $name = null, $name_other = null, $stop_reason_type = null, $stop_reason = null, $date_stop = null, \StructType\HouseServiceReport $report = null, \ArrayType\ArrayOfHouseServiceCost $costs = null)
    {
        $this
            ->setId($id)
            ->setName($name)
            ->setName_other($name_other)
            ->setStop_reason_type($stop_reason_type)
            ->setStop_reason($stop_reason)
            ->setDate_stop($date_stop)
            ->setReport($report)
            ->setCosts($costs);
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\HouseService
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @uses \EnumType\HouseServiceNameEnum::valueIsValid()
     * @uses \EnumType\HouseServiceNameEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $name
     * @return \StructType\HouseService
     */
    public function setName($name = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\HouseServiceNameEnum::valueIsValid($name)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $name, implode(', ', \EnumType\HouseServiceNameEnum::getValidValues())), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get name_other value
     * @return string|null
     */
    public function getName_other()
    {
        return $this->name_other;
    }
    /**
     * Set name_other value
     * @param string $name_other
     * @return \StructType\HouseService
     */
    public function setName_other($name_other = null)
    {
        // validation for constraint: string
        if (!is_null($name_other) && !is_string($name_other)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name_other)), __LINE__);
        }
        $this->name_other = $name_other;
        return $this;
    }
    /**
     * Get stop_reason_type value
     * @return string|null
     */
    public function getStop_reason_type()
    {
        return $this->stop_reason_type;
    }
    /**
     * Set stop_reason_type value
     * @uses \EnumType\ServiceStopReasonTypeEnum::valueIsValid()
     * @uses \EnumType\ServiceStopReasonTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $stop_reason_type
     * @return \StructType\HouseService
     */
    public function setStop_reason_type($stop_reason_type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ServiceStopReasonTypeEnum::valueIsValid($stop_reason_type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $stop_reason_type, implode(', ', \EnumType\ServiceStopReasonTypeEnum::getValidValues())), __LINE__);
        }
        $this->stop_reason_type = $stop_reason_type;
        return $this;
    }
    /**
     * Get stop_reason value
     * @return string|null
     */
    public function getStop_reason()
    {
        return $this->stop_reason;
    }
    /**
     * Set stop_reason value
     * @param string $stop_reason
     * @return \StructType\HouseService
     */
    public function setStop_reason($stop_reason = null)
    {
        // validation for constraint: string
        if (!is_null($stop_reason) && !is_string($stop_reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stop_reason)), __LINE__);
        }
        $this->stop_reason = $stop_reason;
        return $this;
    }
    /**
     * Get date_stop value
     * @return string|null
     */
    public function getDate_stop()
    {
        return $this->date_stop;
    }
    /**
     * Set date_stop value
     * @param string $date_stop
     * @return \StructType\HouseService
     */
    public function setDate_stop($date_stop = null)
    {
        // validation for constraint: string
        if (!is_null($date_stop) && !is_string($date_stop)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date_stop)), __LINE__);
        }
        $this->date_stop = $date_stop;
        return $this;
    }
    /**
     * Get report value
     * @return \StructType\HouseServiceReport|null
     */
    public function getReport()
    {
        return $this->report;
    }
    /**
     * Set report value
     * @param \StructType\HouseServiceReport $report
     * @return \StructType\HouseService
     */
    public function setReport(\StructType\HouseServiceReport $report = null)
    {
        $this->report = $report;
        return $this;
    }
    /**
     * Get costs value
     * @return \ArrayType\ArrayOfHouseServiceCost|null
     */
    public function getCosts()
    {
        return $this->costs;
    }
    /**
     * Set costs value
     * @param \ArrayType\ArrayOfHouseServiceCost $costs
     * @return \StructType\HouseService
     */
    public function setCosts(\ArrayType\ArrayOfHouseServiceCost $costs = null)
    {
        $this->costs = $costs;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HouseService
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
