<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetHouseProfileResponse StructType
 * @subpackage Structs
 */
class GetHouseProfileResponse extends AbstractStructBase
{
    /**
     * The house_id
     * @var int
     */
    public $house_id;
    /**
     * The house_profile_data
     * @var \StructType\HouseProfileData
     */
    public $house_profile_data;
    /**
     * The full_address
     * @var \StructType\FullAddress
     */
    public $full_address;
    /**
     * The stage
     * @var string
     */
    public $stage;
    /**
     * The state
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $state;
    /**
     * The emergency_date
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $emergency_date;
    /**
     * The emergency_number
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $emergency_number;
    /**
     * The emergency_reason
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $emergency_reason;
    /**
     * The emergency_after
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $emergency_after;
    /**
     * The inn
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $inn;
    /**
     * The files_info
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfFileInfo
     */
    public $files_info;
    /**
     * The GetHouseProfileResult
     * @var \StructType\GetHouseProfileResponse
     */
    public $GetHouseProfileResult;
    /**
     * Constructor method for GetHouseProfileResponse
     * @uses GetHouseProfileResponse::setHouse_id()
     * @uses GetHouseProfileResponse::setHouse_profile_data()
     * @uses GetHouseProfileResponse::setFull_address()
     * @uses GetHouseProfileResponse::setStage()
     * @uses GetHouseProfileResponse::setState()
     * @uses GetHouseProfileResponse::setEmergency_date()
     * @uses GetHouseProfileResponse::setEmergency_number()
     * @uses GetHouseProfileResponse::setEmergency_reason()
     * @uses GetHouseProfileResponse::setEmergency_after()
     * @uses GetHouseProfileResponse::setInn()
     * @uses GetHouseProfileResponse::setFiles_info()
     * @uses GetHouseProfileResponse::setGetHouseProfileResult()
     * @param int $house_id
     * @param \StructType\HouseProfileData $house_profile_data
     * @param \StructType\FullAddress $full_address
     * @param string $stage
     * @param string $state
     * @param string $emergency_date
     * @param string $emergency_number
     * @param string $emergency_reason
     * @param string $emergency_after
     * @param string $inn
     * @param \ArrayType\ArrayOfFileInfo $files_info
     * @param \StructType\GetHouseProfileResponse $getHouseProfileResult
     */
    public function __construct($house_id = null, \StructType\HouseProfileData $house_profile_data = null, \StructType\FullAddress $full_address = null, $stage = null, $state = null, $emergency_date = null, $emergency_number = null, $emergency_reason = null, $emergency_after = null, $inn = null, \ArrayType\ArrayOfFileInfo $files_info = null, \StructType\GetHouseProfileResponse $getHouseProfileResult = null)
    {
        $this
            ->setHouse_id($house_id)
            ->setHouse_profile_data($house_profile_data)
            ->setFull_address($full_address)
            ->setStage($stage)
            ->setState($state)
            ->setEmergency_date($emergency_date)
            ->setEmergency_number($emergency_number)
            ->setEmergency_reason($emergency_reason)
            ->setEmergency_after($emergency_after)
            ->setInn($inn)
            ->setFiles_info($files_info)
            ->setGetHouseProfileResult($getHouseProfileResult);
    }
    /**
     * Get house_id value
     * @return int|null
     */
    public function getHouse_id()
    {
        return $this->house_id;
    }
    /**
     * Set house_id value
     * @param int $house_id
     * @return \StructType\GetHouseProfileResponse
     */
    public function setHouse_id($house_id = null)
    {
        // validation for constraint: int
        if (!is_null($house_id) && !is_numeric($house_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($house_id)), __LINE__);
        }
        $this->house_id = $house_id;
        return $this;
    }
    /**
     * Get house_profile_data value
     * @return \StructType\HouseProfileData|null
     */
    public function getHouse_profile_data()
    {
        return $this->house_profile_data;
    }
    /**
     * Set house_profile_data value
     * @param \StructType\HouseProfileData $house_profile_data
     * @return \StructType\GetHouseProfileResponse
     */
    public function setHouse_profile_data(\StructType\HouseProfileData $house_profile_data = null)
    {
        $this->house_profile_data = $house_profile_data;
        return $this;
    }
    /**
     * Get full_address value
     * @return \StructType\FullAddress|null
     */
    public function getFull_address()
    {
        return $this->full_address;
    }
    /**
     * Set full_address value
     * @param \StructType\FullAddress $full_address
     * @return \StructType\GetHouseProfileResponse
     */
    public function setFull_address(\StructType\FullAddress $full_address = null)
    {
        $this->full_address = $full_address;
        return $this;
    }
    /**
     * Get stage value
     * @return string|null
     */
    public function getStage()
    {
        return $this->stage;
    }
    /**
     * Set stage value
     * @uses \EnumType\HouseStageEnum::valueIsValid()
     * @uses \EnumType\HouseStageEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $stage
     * @return \StructType\GetHouseProfileResponse
     */
    public function setStage($stage = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\HouseStageEnum::valueIsValid($stage)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $stage, implode(', ', \EnumType\HouseStageEnum::getValidValues())), __LINE__);
        }
        $this->stage = $stage;
        return $this;
    }
    /**
     * Get state value
     * @return string|null
     */
    public function getState()
    {
        return $this->state;
    }
    /**
     * Set state value
     * @uses \EnumType\HouseStateEnum::valueIsValid()
     * @uses \EnumType\HouseStateEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $state
     * @return \StructType\GetHouseProfileResponse
     */
    public function setState($state = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\HouseStateEnum::valueIsValid($state)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $state, implode(', ', \EnumType\HouseStateEnum::getValidValues())), __LINE__);
        }
        $this->state = $state;
        return $this;
    }
    /**
     * Get emergency_date value
     * @return string|null
     */
    public function getEmergency_date()
    {
        return $this->emergency_date;
    }
    /**
     * Set emergency_date value
     * @param string $emergency_date
     * @return \StructType\GetHouseProfileResponse
     */
    public function setEmergency_date($emergency_date = null)
    {
        // validation for constraint: string
        if (!is_null($emergency_date) && !is_string($emergency_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emergency_date)), __LINE__);
        }
        $this->emergency_date = $emergency_date;
        return $this;
    }
    /**
     * Get emergency_number value
     * @return string|null
     */
    public function getEmergency_number()
    {
        return $this->emergency_number;
    }
    /**
     * Set emergency_number value
     * @param string $emergency_number
     * @return \StructType\GetHouseProfileResponse
     */
    public function setEmergency_number($emergency_number = null)
    {
        // validation for constraint: string
        if (!is_null($emergency_number) && !is_string($emergency_number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emergency_number)), __LINE__);
        }
        $this->emergency_number = $emergency_number;
        return $this;
    }
    /**
     * Get emergency_reason value
     * @return string|null
     */
    public function getEmergency_reason()
    {
        return $this->emergency_reason;
    }
    /**
     * Set emergency_reason value
     * @param string $emergency_reason
     * @return \StructType\GetHouseProfileResponse
     */
    public function setEmergency_reason($emergency_reason = null)
    {
        // validation for constraint: string
        if (!is_null($emergency_reason) && !is_string($emergency_reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emergency_reason)), __LINE__);
        }
        $this->emergency_reason = $emergency_reason;
        return $this;
    }
    /**
     * Get emergency_after value
     * @return string|null
     */
    public function getEmergency_after()
    {
        return $this->emergency_after;
    }
    /**
     * Set emergency_after value
     * @param string $emergency_after
     * @return \StructType\GetHouseProfileResponse
     */
    public function setEmergency_after($emergency_after = null)
    {
        // validation for constraint: string
        if (!is_null($emergency_after) && !is_string($emergency_after)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emergency_after)), __LINE__);
        }
        $this->emergency_after = $emergency_after;
        return $this;
    }
    /**
     * Get inn value
     * @return string|null
     */
    public function getInn()
    {
        return $this->inn;
    }
    /**
     * Set inn value
     * @param string $inn
     * @return \StructType\GetHouseProfileResponse
     */
    public function setInn($inn = null)
    {
        // validation for constraint: string
        if (!is_null($inn) && !is_string($inn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($inn)), __LINE__);
        }
        $this->inn = $inn;
        return $this;
    }
    /**
     * Get files_info value
     * @return \ArrayType\ArrayOfFileInfo|null
     */
    public function getFiles_info()
    {
        return $this->files_info;
    }
    /**
     * Set files_info value
     * @param \ArrayType\ArrayOfFileInfo $files_info
     * @return \StructType\GetHouseProfileResponse
     */
    public function setFiles_info(\ArrayType\ArrayOfFileInfo $files_info = null)
    {
        $this->files_info = $files_info;
        return $this;
    }
    /**
     * Get GetHouseProfileResult value
     * @return \StructType\GetHouseProfileResponse|null
     */
    public function getGetHouseProfileResult()
    {
        return $this->GetHouseProfileResult;
    }
    /**
     * Set GetHouseProfileResult value
     * @param \StructType\GetHouseProfileResponse $getHouseProfileResult
     * @return \StructType\GetHouseProfileResponse
     */
    public function setGetHouseProfileResult(\StructType\GetHouseProfileResponse $getHouseProfileResult = null)
    {
        $this->GetHouseProfileResult = $getHouseProfileResult;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetHouseProfileResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
