<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Facade StructType
 * @subpackage Structs
 */
class Facade extends AbstractStructBase
{
    /**
     * The area_total
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $area_total;
    /**
     * The area_plastered
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $area_plastered;
    /**
     * The area_unplastered
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $area_unplastered;
    /**
     * The area_panel
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $area_panel;
    /**
     * The area_tiled
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $area_tiled;
    /**
     * The area_lined_siding
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $area_lined_siding;
    /**
     * The area_wooden
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $area_wooden;
    /**
     * The area_insulated_decorative_plaster
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $area_insulated_decorative_plaster;
    /**
     * The area_insulated_tiles
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $area_insulated_tiles;
    /**
     * The area_insulated_siding
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $area_insulated_siding;
    /**
     * The area_riprap
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $area_riprap;
    /**
     * The area_glazing_common_wooden
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $area_glazing_common_wooden;
    /**
     * The area_glazing_common_plastic
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $area_glazing_common_plastic;
    /**
     * The area_glazing_individual_wooden
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $area_glazing_individual_wooden;
    /**
     * The area_glazing_individual_plastic
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $area_glazing_individual_plastic;
    /**
     * The area_door_fillings_metal
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $area_door_fillings_metal;
    /**
     * The area_door_fillings_others
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $area_door_fillings_others;
    /**
     * The last_overhaul_date
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $last_overhaul_date;
    /**
     * Constructor method for Facade
     * @uses Facade::setArea_total()
     * @uses Facade::setArea_plastered()
     * @uses Facade::setArea_unplastered()
     * @uses Facade::setArea_panel()
     * @uses Facade::setArea_tiled()
     * @uses Facade::setArea_lined_siding()
     * @uses Facade::setArea_wooden()
     * @uses Facade::setArea_insulated_decorative_plaster()
     * @uses Facade::setArea_insulated_tiles()
     * @uses Facade::setArea_insulated_siding()
     * @uses Facade::setArea_riprap()
     * @uses Facade::setArea_glazing_common_wooden()
     * @uses Facade::setArea_glazing_common_plastic()
     * @uses Facade::setArea_glazing_individual_wooden()
     * @uses Facade::setArea_glazing_individual_plastic()
     * @uses Facade::setArea_door_fillings_metal()
     * @uses Facade::setArea_door_fillings_others()
     * @uses Facade::setLast_overhaul_date()
     * @param float $area_total
     * @param float $area_plastered
     * @param float $area_unplastered
     * @param float $area_panel
     * @param float $area_tiled
     * @param float $area_lined_siding
     * @param float $area_wooden
     * @param float $area_insulated_decorative_plaster
     * @param float $area_insulated_tiles
     * @param float $area_insulated_siding
     * @param float $area_riprap
     * @param float $area_glazing_common_wooden
     * @param float $area_glazing_common_plastic
     * @param float $area_glazing_individual_wooden
     * @param float $area_glazing_individual_plastic
     * @param float $area_door_fillings_metal
     * @param float $area_door_fillings_others
     * @param string $last_overhaul_date
     */
    public function __construct($area_total = null, $area_plastered = null, $area_unplastered = null, $area_panel = null, $area_tiled = null, $area_lined_siding = null, $area_wooden = null, $area_insulated_decorative_plaster = null, $area_insulated_tiles = null, $area_insulated_siding = null, $area_riprap = null, $area_glazing_common_wooden = null, $area_glazing_common_plastic = null, $area_glazing_individual_wooden = null, $area_glazing_individual_plastic = null, $area_door_fillings_metal = null, $area_door_fillings_others = null, $last_overhaul_date = null)
    {
        $this
            ->setArea_total($area_total)
            ->setArea_plastered($area_plastered)
            ->setArea_unplastered($area_unplastered)
            ->setArea_panel($area_panel)
            ->setArea_tiled($area_tiled)
            ->setArea_lined_siding($area_lined_siding)
            ->setArea_wooden($area_wooden)
            ->setArea_insulated_decorative_plaster($area_insulated_decorative_plaster)
            ->setArea_insulated_tiles($area_insulated_tiles)
            ->setArea_insulated_siding($area_insulated_siding)
            ->setArea_riprap($area_riprap)
            ->setArea_glazing_common_wooden($area_glazing_common_wooden)
            ->setArea_glazing_common_plastic($area_glazing_common_plastic)
            ->setArea_glazing_individual_wooden($area_glazing_individual_wooden)
            ->setArea_glazing_individual_plastic($area_glazing_individual_plastic)
            ->setArea_door_fillings_metal($area_door_fillings_metal)
            ->setArea_door_fillings_others($area_door_fillings_others)
            ->setLast_overhaul_date($last_overhaul_date);
    }
    /**
     * Get area_total value
     * @return float|null
     */
    public function getArea_total()
    {
        return $this->area_total;
    }
    /**
     * Set area_total value
     * @param float $area_total
     * @return \StructType\Facade
     */
    public function setArea_total($area_total = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($area_total) && strlen(substr($area_total, strpos($area_total, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($area_total, strpos($area_total, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($area_total) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $area_total)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($area_total, strpos($area_total, '.')))), __LINE__);
        }
        $this->area_total = $area_total;
        return $this;
    }
    /**
     * Get area_plastered value
     * @return float|null
     */
    public function getArea_plastered()
    {
        return $this->area_plastered;
    }
    /**
     * Set area_plastered value
     * @param float $area_plastered
     * @return \StructType\Facade
     */
    public function setArea_plastered($area_plastered = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($area_plastered) && strlen(substr($area_plastered, strpos($area_plastered, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($area_plastered, strpos($area_plastered, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($area_plastered) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $area_plastered)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($area_plastered, strpos($area_plastered, '.')))), __LINE__);
        }
        $this->area_plastered = $area_plastered;
        return $this;
    }
    /**
     * Get area_unplastered value
     * @return float|null
     */
    public function getArea_unplastered()
    {
        return $this->area_unplastered;
    }
    /**
     * Set area_unplastered value
     * @param float $area_unplastered
     * @return \StructType\Facade
     */
    public function setArea_unplastered($area_unplastered = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($area_unplastered) && strlen(substr($area_unplastered, strpos($area_unplastered, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($area_unplastered, strpos($area_unplastered, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($area_unplastered) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $area_unplastered)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($area_unplastered, strpos($area_unplastered, '.')))), __LINE__);
        }
        $this->area_unplastered = $area_unplastered;
        return $this;
    }
    /**
     * Get area_panel value
     * @return float|null
     */
    public function getArea_panel()
    {
        return $this->area_panel;
    }
    /**
     * Set area_panel value
     * @param float $area_panel
     * @return \StructType\Facade
     */
    public function setArea_panel($area_panel = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($area_panel) && strlen(substr($area_panel, strpos($area_panel, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($area_panel, strpos($area_panel, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($area_panel) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $area_panel)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($area_panel, strpos($area_panel, '.')))), __LINE__);
        }
        $this->area_panel = $area_panel;
        return $this;
    }
    /**
     * Get area_tiled value
     * @return float|null
     */
    public function getArea_tiled()
    {
        return $this->area_tiled;
    }
    /**
     * Set area_tiled value
     * @param float $area_tiled
     * @return \StructType\Facade
     */
    public function setArea_tiled($area_tiled = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($area_tiled) && strlen(substr($area_tiled, strpos($area_tiled, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($area_tiled, strpos($area_tiled, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($area_tiled) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $area_tiled)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($area_tiled, strpos($area_tiled, '.')))), __LINE__);
        }
        $this->area_tiled = $area_tiled;
        return $this;
    }
    /**
     * Get area_lined_siding value
     * @return float|null
     */
    public function getArea_lined_siding()
    {
        return $this->area_lined_siding;
    }
    /**
     * Set area_lined_siding value
     * @param float $area_lined_siding
     * @return \StructType\Facade
     */
    public function setArea_lined_siding($area_lined_siding = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($area_lined_siding) && strlen(substr($area_lined_siding, strpos($area_lined_siding, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($area_lined_siding, strpos($area_lined_siding, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($area_lined_siding) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $area_lined_siding)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($area_lined_siding, strpos($area_lined_siding, '.')))), __LINE__);
        }
        $this->area_lined_siding = $area_lined_siding;
        return $this;
    }
    /**
     * Get area_wooden value
     * @return float|null
     */
    public function getArea_wooden()
    {
        return $this->area_wooden;
    }
    /**
     * Set area_wooden value
     * @param float $area_wooden
     * @return \StructType\Facade
     */
    public function setArea_wooden($area_wooden = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($area_wooden) && strlen(substr($area_wooden, strpos($area_wooden, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($area_wooden, strpos($area_wooden, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($area_wooden) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $area_wooden)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($area_wooden, strpos($area_wooden, '.')))), __LINE__);
        }
        $this->area_wooden = $area_wooden;
        return $this;
    }
    /**
     * Get area_insulated_decorative_plaster value
     * @return float|null
     */
    public function getArea_insulated_decorative_plaster()
    {
        return $this->area_insulated_decorative_plaster;
    }
    /**
     * Set area_insulated_decorative_plaster value
     * @param float $area_insulated_decorative_plaster
     * @return \StructType\Facade
     */
    public function setArea_insulated_decorative_plaster($area_insulated_decorative_plaster = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($area_insulated_decorative_plaster) && strlen(substr($area_insulated_decorative_plaster, strpos($area_insulated_decorative_plaster, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($area_insulated_decorative_plaster, strpos($area_insulated_decorative_plaster, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($area_insulated_decorative_plaster) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $area_insulated_decorative_plaster)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($area_insulated_decorative_plaster, strpos($area_insulated_decorative_plaster, '.')))), __LINE__);
        }
        $this->area_insulated_decorative_plaster = $area_insulated_decorative_plaster;
        return $this;
    }
    /**
     * Get area_insulated_tiles value
     * @return float|null
     */
    public function getArea_insulated_tiles()
    {
        return $this->area_insulated_tiles;
    }
    /**
     * Set area_insulated_tiles value
     * @param float $area_insulated_tiles
     * @return \StructType\Facade
     */
    public function setArea_insulated_tiles($area_insulated_tiles = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($area_insulated_tiles) && strlen(substr($area_insulated_tiles, strpos($area_insulated_tiles, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($area_insulated_tiles, strpos($area_insulated_tiles, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($area_insulated_tiles) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $area_insulated_tiles)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($area_insulated_tiles, strpos($area_insulated_tiles, '.')))), __LINE__);
        }
        $this->area_insulated_tiles = $area_insulated_tiles;
        return $this;
    }
    /**
     * Get area_insulated_siding value
     * @return float|null
     */
    public function getArea_insulated_siding()
    {
        return $this->area_insulated_siding;
    }
    /**
     * Set area_insulated_siding value
     * @param float $area_insulated_siding
     * @return \StructType\Facade
     */
    public function setArea_insulated_siding($area_insulated_siding = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($area_insulated_siding) && strlen(substr($area_insulated_siding, strpos($area_insulated_siding, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($area_insulated_siding, strpos($area_insulated_siding, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($area_insulated_siding) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $area_insulated_siding)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($area_insulated_siding, strpos($area_insulated_siding, '.')))), __LINE__);
        }
        $this->area_insulated_siding = $area_insulated_siding;
        return $this;
    }
    /**
     * Get area_riprap value
     * @return float|null
     */
    public function getArea_riprap()
    {
        return $this->area_riprap;
    }
    /**
     * Set area_riprap value
     * @param float $area_riprap
     * @return \StructType\Facade
     */
    public function setArea_riprap($area_riprap = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($area_riprap) && strlen(substr($area_riprap, strpos($area_riprap, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($area_riprap, strpos($area_riprap, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($area_riprap) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $area_riprap)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($area_riprap, strpos($area_riprap, '.')))), __LINE__);
        }
        $this->area_riprap = $area_riprap;
        return $this;
    }
    /**
     * Get area_glazing_common_wooden value
     * @return float|null
     */
    public function getArea_glazing_common_wooden()
    {
        return $this->area_glazing_common_wooden;
    }
    /**
     * Set area_glazing_common_wooden value
     * @param float $area_glazing_common_wooden
     * @return \StructType\Facade
     */
    public function setArea_glazing_common_wooden($area_glazing_common_wooden = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($area_glazing_common_wooden) && strlen(substr($area_glazing_common_wooden, strpos($area_glazing_common_wooden, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($area_glazing_common_wooden, strpos($area_glazing_common_wooden, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($area_glazing_common_wooden) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $area_glazing_common_wooden)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($area_glazing_common_wooden, strpos($area_glazing_common_wooden, '.')))), __LINE__);
        }
        $this->area_glazing_common_wooden = $area_glazing_common_wooden;
        return $this;
    }
    /**
     * Get area_glazing_common_plastic value
     * @return float|null
     */
    public function getArea_glazing_common_plastic()
    {
        return $this->area_glazing_common_plastic;
    }
    /**
     * Set area_glazing_common_plastic value
     * @param float $area_glazing_common_plastic
     * @return \StructType\Facade
     */
    public function setArea_glazing_common_plastic($area_glazing_common_plastic = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($area_glazing_common_plastic) && strlen(substr($area_glazing_common_plastic, strpos($area_glazing_common_plastic, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($area_glazing_common_plastic, strpos($area_glazing_common_plastic, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($area_glazing_common_plastic) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $area_glazing_common_plastic)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($area_glazing_common_plastic, strpos($area_glazing_common_plastic, '.')))), __LINE__);
        }
        $this->area_glazing_common_plastic = $area_glazing_common_plastic;
        return $this;
    }
    /**
     * Get area_glazing_individual_wooden value
     * @return float|null
     */
    public function getArea_glazing_individual_wooden()
    {
        return $this->area_glazing_individual_wooden;
    }
    /**
     * Set area_glazing_individual_wooden value
     * @param float $area_glazing_individual_wooden
     * @return \StructType\Facade
     */
    public function setArea_glazing_individual_wooden($area_glazing_individual_wooden = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($area_glazing_individual_wooden) && strlen(substr($area_glazing_individual_wooden, strpos($area_glazing_individual_wooden, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($area_glazing_individual_wooden, strpos($area_glazing_individual_wooden, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($area_glazing_individual_wooden) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $area_glazing_individual_wooden)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($area_glazing_individual_wooden, strpos($area_glazing_individual_wooden, '.')))), __LINE__);
        }
        $this->area_glazing_individual_wooden = $area_glazing_individual_wooden;
        return $this;
    }
    /**
     * Get area_glazing_individual_plastic value
     * @return float|null
     */
    public function getArea_glazing_individual_plastic()
    {
        return $this->area_glazing_individual_plastic;
    }
    /**
     * Set area_glazing_individual_plastic value
     * @param float $area_glazing_individual_plastic
     * @return \StructType\Facade
     */
    public function setArea_glazing_individual_plastic($area_glazing_individual_plastic = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($area_glazing_individual_plastic) && strlen(substr($area_glazing_individual_plastic, strpos($area_glazing_individual_plastic, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($area_glazing_individual_plastic, strpos($area_glazing_individual_plastic, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($area_glazing_individual_plastic) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $area_glazing_individual_plastic)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($area_glazing_individual_plastic, strpos($area_glazing_individual_plastic, '.')))), __LINE__);
        }
        $this->area_glazing_individual_plastic = $area_glazing_individual_plastic;
        return $this;
    }
    /**
     * Get area_door_fillings_metal value
     * @return float|null
     */
    public function getArea_door_fillings_metal()
    {
        return $this->area_door_fillings_metal;
    }
    /**
     * Set area_door_fillings_metal value
     * @param float $area_door_fillings_metal
     * @return \StructType\Facade
     */
    public function setArea_door_fillings_metal($area_door_fillings_metal = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($area_door_fillings_metal) && strlen(substr($area_door_fillings_metal, strpos($area_door_fillings_metal, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($area_door_fillings_metal, strpos($area_door_fillings_metal, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($area_door_fillings_metal) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $area_door_fillings_metal)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($area_door_fillings_metal, strpos($area_door_fillings_metal, '.')))), __LINE__);
        }
        $this->area_door_fillings_metal = $area_door_fillings_metal;
        return $this;
    }
    /**
     * Get area_door_fillings_others value
     * @return float|null
     */
    public function getArea_door_fillings_others()
    {
        return $this->area_door_fillings_others;
    }
    /**
     * Set area_door_fillings_others value
     * @param float $area_door_fillings_others
     * @return \StructType\Facade
     */
    public function setArea_door_fillings_others($area_door_fillings_others = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($area_door_fillings_others) && strlen(substr($area_door_fillings_others, strpos($area_door_fillings_others, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($area_door_fillings_others, strpos($area_door_fillings_others, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($area_door_fillings_others) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $area_door_fillings_others)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($area_door_fillings_others, strpos($area_door_fillings_others, '.')))), __LINE__);
        }
        $this->area_door_fillings_others = $area_door_fillings_others;
        return $this;
    }
    /**
     * Get last_overhaul_date value
     * @return string|null
     */
    public function getLast_overhaul_date()
    {
        return $this->last_overhaul_date;
    }
    /**
     * Set last_overhaul_date value
     * @param string $last_overhaul_date
     * @return \StructType\Facade
     */
    public function setLast_overhaul_date($last_overhaul_date = null)
    {
        // validation for constraint: string
        if (!is_null($last_overhaul_date) && !is_string($last_overhaul_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($last_overhaul_date)), __LINE__);
        }
        $this->last_overhaul_date = $last_overhaul_date;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Facade
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
