<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Basement StructType
 * @subpackage Structs
 */
class Basement extends AbstractStructBase
{
    /**
     * The basement_stage
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $basement_stage;
    /**
     * The basement_area
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $basement_area;
    /**
     * The basement_last_overhaul_date
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $basement_last_overhaul_date;
    /**
     * Constructor method for Basement
     * @uses Basement::setBasement_stage()
     * @uses Basement::setBasement_area()
     * @uses Basement::setBasement_last_overhaul_date()
     * @param string $basement_stage
     * @param float $basement_area
     * @param string $basement_last_overhaul_date
     */
    public function __construct($basement_stage = null, $basement_area = null, $basement_last_overhaul_date = null)
    {
        $this
            ->setBasement_stage($basement_stage)
            ->setBasement_area($basement_area)
            ->setBasement_last_overhaul_date($basement_last_overhaul_date);
    }
    /**
     * Get basement_stage value
     * @return string|null
     */
    public function getBasement_stage()
    {
        return $this->basement_stage;
    }
    /**
     * Set basement_stage value
     * @uses \EnumType\BasementStageEnum::valueIsValid()
     * @uses \EnumType\BasementStageEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $basement_stage
     * @return \StructType\Basement
     */
    public function setBasement_stage($basement_stage = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BasementStageEnum::valueIsValid($basement_stage)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $basement_stage, implode(', ', \EnumType\BasementStageEnum::getValidValues())), __LINE__);
        }
        $this->basement_stage = $basement_stage;
        return $this;
    }
    /**
     * Get basement_area value
     * @return float|null
     */
    public function getBasement_area()
    {
        return $this->basement_area;
    }
    /**
     * Set basement_area value
     * @param float $basement_area
     * @return \StructType\Basement
     */
    public function setBasement_area($basement_area = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($basement_area) && strlen(substr($basement_area, strpos($basement_area, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($basement_area, strpos($basement_area, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($basement_area) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $basement_area)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($basement_area, strpos($basement_area, '.')))), __LINE__);
        }
        $this->basement_area = $basement_area;
        return $this;
    }
    /**
     * Get basement_last_overhaul_date value
     * @return string|null
     */
    public function getBasement_last_overhaul_date()
    {
        return $this->basement_last_overhaul_date;
    }
    /**
     * Set basement_last_overhaul_date value
     * @param string $basement_last_overhaul_date
     * @return \StructType\Basement
     */
    public function setBasement_last_overhaul_date($basement_last_overhaul_date = null)
    {
        // validation for constraint: string
        if (!is_null($basement_last_overhaul_date) && !is_string($basement_last_overhaul_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($basement_last_overhaul_date)), __LINE__);
        }
        $this->basement_last_overhaul_date = $basement_last_overhaul_date;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Basement
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
