<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnlinkHouseFromOrganizationData StructType
 * @subpackage Structs
 */
class UnlinkHouseFromOrganizationData extends AbstractStructBase
{
    /**
     * The house_id
     * @var int
     */
    public $house_id;
    /**
     * The stop_reason_type
     * @var string
     */
    public $stop_reason_type;
    /**
     * The stop_reason
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $stop_reason;
    /**
     * The date_stop
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $date_stop;
    /**
     * Constructor method for UnlinkHouseFromOrganizationData
     * @uses UnlinkHouseFromOrganizationData::setHouse_id()
     * @uses UnlinkHouseFromOrganizationData::setStop_reason_type()
     * @uses UnlinkHouseFromOrganizationData::setStop_reason()
     * @uses UnlinkHouseFromOrganizationData::setDate_stop()
     * @param int $house_id
     * @param string $stop_reason_type
     * @param string $stop_reason
     * @param string $date_stop
     */
    public function __construct($house_id = null, $stop_reason_type = null, $stop_reason = null, $date_stop = null)
    {
        $this
            ->setHouse_id($house_id)
            ->setStop_reason_type($stop_reason_type)
            ->setStop_reason($stop_reason)
            ->setDate_stop($date_stop);
    }
    /**
     * Get house_id value
     * @return int|null
     */
    public function getHouse_id()
    {
        return $this->house_id;
    }
    /**
     * Set house_id value
     * @param int $house_id
     * @return \StructType\UnlinkHouseFromOrganizationData
     */
    public function setHouse_id($house_id = null)
    {
        // validation for constraint: int
        if (!is_null($house_id) && !is_numeric($house_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($house_id)), __LINE__);
        }
        $this->house_id = $house_id;
        return $this;
    }
    /**
     * Get stop_reason_type value
     * @return string|null
     */
    public function getStop_reason_type()
    {
        return $this->stop_reason_type;
    }
    /**
     * Set stop_reason_type value
     * @uses \EnumType\ContractStopReasonEnum::valueIsValid()
     * @uses \EnumType\ContractStopReasonEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $stop_reason_type
     * @return \StructType\UnlinkHouseFromOrganizationData
     */
    public function setStop_reason_type($stop_reason_type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ContractStopReasonEnum::valueIsValid($stop_reason_type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $stop_reason_type, implode(', ', \EnumType\ContractStopReasonEnum::getValidValues())), __LINE__);
        }
        $this->stop_reason_type = $stop_reason_type;
        return $this;
    }
    /**
     * Get stop_reason value
     * @return string|null
     */
    public function getStop_reason()
    {
        return $this->stop_reason;
    }
    /**
     * Set stop_reason value
     * @param string $stop_reason
     * @return \StructType\UnlinkHouseFromOrganizationData
     */
    public function setStop_reason($stop_reason = null)
    {
        // validation for constraint: string
        if (!is_null($stop_reason) && !is_string($stop_reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stop_reason)), __LINE__);
        }
        $this->stop_reason = $stop_reason;
        return $this;
    }
    /**
     * Get date_stop value
     * @return string|null
     */
    public function getDate_stop()
    {
        return $this->date_stop;
    }
    /**
     * Set date_stop value
     * @param string $date_stop
     * @return \StructType\UnlinkHouseFromOrganizationData
     */
    public function setDate_stop($date_stop = null)
    {
        // validation for constraint: string
        if (!is_null($date_stop) && !is_string($date_stop)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date_stop)), __LINE__);
        }
        $this->date_stop = $date_stop;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UnlinkHouseFromOrganizationData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
