<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Finance StructType
 * @subpackage Structs
 */
class Finance extends AbstractStructBase
{
    /**
     * The income_management
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $income_management;
    /**
     * The income_management_common_property
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $income_management_common_property;
    /**
     * The management_costs
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $management_costs;
    /**
     * The debt_owners_total
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $debt_owners_total;
    /**
     * The charged_owners_total
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $charged_owners_total;
    /**
     * The payment_claims_compensation
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $payment_claims_compensation;
    /**
     * The payment_claims_refusal
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $payment_claims_refusal;
    /**
     * The payment_claims_not_delivered
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $payment_claims_not_delivered;
    /**
     * The repair_work
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $repair_work;
    /**
     * The beautification_work
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $beautification_work;
    /**
     * The raised_funds_subsidies
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $raised_funds_subsidies;
    /**
     * The raised_funds_credits
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $raised_funds_credits;
    /**
     * The raised_funds_leasing
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $raised_funds_leasing;
    /**
     * The raised_funds_energy_service
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $raised_funds_energy_service;
    /**
     * The raised_funds_contributions
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $raised_funds_contributions;
    /**
     * The raised_funds_others
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $raised_funds_others;
    /**
     * The income_supply_heating
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $income_supply_heating;
    /**
     * The income_supply_electricity
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $income_supply_electricity;
    /**
     * The income_supply_gaz
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $income_supply_gaz;
    /**
     * The income_supply_hot_water
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $income_supply_hot_water;
    /**
     * The income_supply_cold_water
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $income_supply_cold_water;
    /**
     * The income_supply_wastewater
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $income_supply_wastewater;
    /**
     * The debt_owners_heating
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $debt_owners_heating;
    /**
     * The debt_owners_electricity
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $debt_owners_electricity;
    /**
     * The debt_owners_gaz
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $debt_owners_gaz;
    /**
     * The debt_owners_hot_water
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $debt_owners_hot_water;
    /**
     * The debt_owners_cold_water
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $debt_owners_cold_water;
    /**
     * The debt_owners_wastewater
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $debt_owners_wastewater;
    /**
     * The charged_services_heating
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $charged_services_heating;
    /**
     * The charged_services_electricity
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $charged_services_electricity;
    /**
     * The charged_services_gaz
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $charged_services_gaz;
    /**
     * The charged_services_hot_water
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $charged_services_hot_water;
    /**
     * The charged_services_cold_water
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $charged_services_cold_water;
    /**
     * The charged_services_wastewater
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $charged_services_wastewater;
    /**
     * The paid_services_heating
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $paid_services_heating;
    /**
     * The paid_services_electricity
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $paid_services_electricity;
    /**
     * The paid_services_gaz
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $paid_services_gaz;
    /**
     * The paid_services_hot_water
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $paid_services_hot_water;
    /**
     * The paid_services_cold_water
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $paid_services_cold_water;
    /**
     * The paid_resources_heating
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $paid_resources_heating;
    /**
     * The paid_resources_electricity
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $paid_resources_electricity;
    /**
     * The paid_resources_gaz
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $paid_resources_gaz;
    /**
     * The paid_resources_hot_water
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $paid_resources_hot_water;
    /**
     * The paid_resources_cold_water
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $paid_resources_cold_water;
    /**
     * Constructor method for Finance
     * @uses Finance::setIncome_management()
     * @uses Finance::setIncome_management_common_property()
     * @uses Finance::setManagement_costs()
     * @uses Finance::setDebt_owners_total()
     * @uses Finance::setCharged_owners_total()
     * @uses Finance::setPayment_claims_compensation()
     * @uses Finance::setPayment_claims_refusal()
     * @uses Finance::setPayment_claims_not_delivered()
     * @uses Finance::setRepair_work()
     * @uses Finance::setBeautification_work()
     * @uses Finance::setRaised_funds_subsidies()
     * @uses Finance::setRaised_funds_credits()
     * @uses Finance::setRaised_funds_leasing()
     * @uses Finance::setRaised_funds_energy_service()
     * @uses Finance::setRaised_funds_contributions()
     * @uses Finance::setRaised_funds_others()
     * @uses Finance::setIncome_supply_heating()
     * @uses Finance::setIncome_supply_electricity()
     * @uses Finance::setIncome_supply_gaz()
     * @uses Finance::setIncome_supply_hot_water()
     * @uses Finance::setIncome_supply_cold_water()
     * @uses Finance::setIncome_supply_wastewater()
     * @uses Finance::setDebt_owners_heating()
     * @uses Finance::setDebt_owners_electricity()
     * @uses Finance::setDebt_owners_gaz()
     * @uses Finance::setDebt_owners_hot_water()
     * @uses Finance::setDebt_owners_cold_water()
     * @uses Finance::setDebt_owners_wastewater()
     * @uses Finance::setCharged_services_heating()
     * @uses Finance::setCharged_services_electricity()
     * @uses Finance::setCharged_services_gaz()
     * @uses Finance::setCharged_services_hot_water()
     * @uses Finance::setCharged_services_cold_water()
     * @uses Finance::setCharged_services_wastewater()
     * @uses Finance::setPaid_services_heating()
     * @uses Finance::setPaid_services_electricity()
     * @uses Finance::setPaid_services_gaz()
     * @uses Finance::setPaid_services_hot_water()
     * @uses Finance::setPaid_services_cold_water()
     * @uses Finance::setPaid_resources_heating()
     * @uses Finance::setPaid_resources_electricity()
     * @uses Finance::setPaid_resources_gaz()
     * @uses Finance::setPaid_resources_hot_water()
     * @uses Finance::setPaid_resources_cold_water()
     * @param float $income_management
     * @param float $income_management_common_property
     * @param float $management_costs
     * @param float $debt_owners_total
     * @param float $charged_owners_total
     * @param float $payment_claims_compensation
     * @param float $payment_claims_refusal
     * @param float $payment_claims_not_delivered
     * @param float $repair_work
     * @param float $beautification_work
     * @param float $raised_funds_subsidies
     * @param float $raised_funds_credits
     * @param float $raised_funds_leasing
     * @param float $raised_funds_energy_service
     * @param float $raised_funds_contributions
     * @param float $raised_funds_others
     * @param float $income_supply_heating
     * @param float $income_supply_electricity
     * @param float $income_supply_gaz
     * @param float $income_supply_hot_water
     * @param float $income_supply_cold_water
     * @param float $income_supply_wastewater
     * @param float $debt_owners_heating
     * @param float $debt_owners_electricity
     * @param float $debt_owners_gaz
     * @param float $debt_owners_hot_water
     * @param float $debt_owners_cold_water
     * @param float $debt_owners_wastewater
     * @param float $charged_services_heating
     * @param float $charged_services_electricity
     * @param float $charged_services_gaz
     * @param float $charged_services_hot_water
     * @param float $charged_services_cold_water
     * @param float $charged_services_wastewater
     * @param float $paid_services_heating
     * @param float $paid_services_electricity
     * @param float $paid_services_gaz
     * @param float $paid_services_hot_water
     * @param float $paid_services_cold_water
     * @param float $paid_resources_heating
     * @param float $paid_resources_electricity
     * @param float $paid_resources_gaz
     * @param float $paid_resources_hot_water
     * @param float $paid_resources_cold_water
     */
    public function __construct($income_management = null, $income_management_common_property = null, $management_costs = null, $debt_owners_total = null, $charged_owners_total = null, $payment_claims_compensation = null, $payment_claims_refusal = null, $payment_claims_not_delivered = null, $repair_work = null, $beautification_work = null, $raised_funds_subsidies = null, $raised_funds_credits = null, $raised_funds_leasing = null, $raised_funds_energy_service = null, $raised_funds_contributions = null, $raised_funds_others = null, $income_supply_heating = null, $income_supply_electricity = null, $income_supply_gaz = null, $income_supply_hot_water = null, $income_supply_cold_water = null, $income_supply_wastewater = null, $debt_owners_heating = null, $debt_owners_electricity = null, $debt_owners_gaz = null, $debt_owners_hot_water = null, $debt_owners_cold_water = null, $debt_owners_wastewater = null, $charged_services_heating = null, $charged_services_electricity = null, $charged_services_gaz = null, $charged_services_hot_water = null, $charged_services_cold_water = null, $charged_services_wastewater = null, $paid_services_heating = null, $paid_services_electricity = null, $paid_services_gaz = null, $paid_services_hot_water = null, $paid_services_cold_water = null, $paid_resources_heating = null, $paid_resources_electricity = null, $paid_resources_gaz = null, $paid_resources_hot_water = null, $paid_resources_cold_water = null)
    {
        $this
            ->setIncome_management($income_management)
            ->setIncome_management_common_property($income_management_common_property)
            ->setManagement_costs($management_costs)
            ->setDebt_owners_total($debt_owners_total)
            ->setCharged_owners_total($charged_owners_total)
            ->setPayment_claims_compensation($payment_claims_compensation)
            ->setPayment_claims_refusal($payment_claims_refusal)
            ->setPayment_claims_not_delivered($payment_claims_not_delivered)
            ->setRepair_work($repair_work)
            ->setBeautification_work($beautification_work)
            ->setRaised_funds_subsidies($raised_funds_subsidies)
            ->setRaised_funds_credits($raised_funds_credits)
            ->setRaised_funds_leasing($raised_funds_leasing)
            ->setRaised_funds_energy_service($raised_funds_energy_service)
            ->setRaised_funds_contributions($raised_funds_contributions)
            ->setRaised_funds_others($raised_funds_others)
            ->setIncome_supply_heating($income_supply_heating)
            ->setIncome_supply_electricity($income_supply_electricity)
            ->setIncome_supply_gaz($income_supply_gaz)
            ->setIncome_supply_hot_water($income_supply_hot_water)
            ->setIncome_supply_cold_water($income_supply_cold_water)
            ->setIncome_supply_wastewater($income_supply_wastewater)
            ->setDebt_owners_heating($debt_owners_heating)
            ->setDebt_owners_electricity($debt_owners_electricity)
            ->setDebt_owners_gaz($debt_owners_gaz)
            ->setDebt_owners_hot_water($debt_owners_hot_water)
            ->setDebt_owners_cold_water($debt_owners_cold_water)
            ->setDebt_owners_wastewater($debt_owners_wastewater)
            ->setCharged_services_heating($charged_services_heating)
            ->setCharged_services_electricity($charged_services_electricity)
            ->setCharged_services_gaz($charged_services_gaz)
            ->setCharged_services_hot_water($charged_services_hot_water)
            ->setCharged_services_cold_water($charged_services_cold_water)
            ->setCharged_services_wastewater($charged_services_wastewater)
            ->setPaid_services_heating($paid_services_heating)
            ->setPaid_services_electricity($paid_services_electricity)
            ->setPaid_services_gaz($paid_services_gaz)
            ->setPaid_services_hot_water($paid_services_hot_water)
            ->setPaid_services_cold_water($paid_services_cold_water)
            ->setPaid_resources_heating($paid_resources_heating)
            ->setPaid_resources_electricity($paid_resources_electricity)
            ->setPaid_resources_gaz($paid_resources_gaz)
            ->setPaid_resources_hot_water($paid_resources_hot_water)
            ->setPaid_resources_cold_water($paid_resources_cold_water);
    }
    /**
     * Get income_management value
     * @return float|null
     */
    public function getIncome_management()
    {
        return $this->income_management;
    }
    /**
     * Set income_management value
     * @param float $income_management
     * @return \StructType\Finance
     */
    public function setIncome_management($income_management = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($income_management) && strlen(substr($income_management, strpos($income_management, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($income_management, strpos($income_management, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($income_management) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $income_management)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($income_management, strpos($income_management, '.')))), __LINE__);
        }
        $this->income_management = $income_management;
        return $this;
    }
    /**
     * Get income_management_common_property value
     * @return float|null
     */
    public function getIncome_management_common_property()
    {
        return $this->income_management_common_property;
    }
    /**
     * Set income_management_common_property value
     * @param float $income_management_common_property
     * @return \StructType\Finance
     */
    public function setIncome_management_common_property($income_management_common_property = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($income_management_common_property) && strlen(substr($income_management_common_property, strpos($income_management_common_property, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($income_management_common_property, strpos($income_management_common_property, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($income_management_common_property) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $income_management_common_property)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($income_management_common_property, strpos($income_management_common_property, '.')))), __LINE__);
        }
        $this->income_management_common_property = $income_management_common_property;
        return $this;
    }
    /**
     * Get management_costs value
     * @return float|null
     */
    public function getManagement_costs()
    {
        return $this->management_costs;
    }
    /**
     * Set management_costs value
     * @param float $management_costs
     * @return \StructType\Finance
     */
    public function setManagement_costs($management_costs = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($management_costs) && strlen(substr($management_costs, strpos($management_costs, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($management_costs, strpos($management_costs, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($management_costs) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $management_costs)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($management_costs, strpos($management_costs, '.')))), __LINE__);
        }
        $this->management_costs = $management_costs;
        return $this;
    }
    /**
     * Get debt_owners_total value
     * @return float|null
     */
    public function getDebt_owners_total()
    {
        return $this->debt_owners_total;
    }
    /**
     * Set debt_owners_total value
     * @param float $debt_owners_total
     * @return \StructType\Finance
     */
    public function setDebt_owners_total($debt_owners_total = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($debt_owners_total) && strlen(substr($debt_owners_total, strpos($debt_owners_total, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($debt_owners_total, strpos($debt_owners_total, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($debt_owners_total) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $debt_owners_total)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($debt_owners_total, strpos($debt_owners_total, '.')))), __LINE__);
        }
        $this->debt_owners_total = $debt_owners_total;
        return $this;
    }
    /**
     * Get charged_owners_total value
     * @return float|null
     */
    public function getCharged_owners_total()
    {
        return $this->charged_owners_total;
    }
    /**
     * Set charged_owners_total value
     * @param float $charged_owners_total
     * @return \StructType\Finance
     */
    public function setCharged_owners_total($charged_owners_total = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($charged_owners_total) && strlen(substr($charged_owners_total, strpos($charged_owners_total, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($charged_owners_total, strpos($charged_owners_total, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($charged_owners_total) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $charged_owners_total)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($charged_owners_total, strpos($charged_owners_total, '.')))), __LINE__);
        }
        $this->charged_owners_total = $charged_owners_total;
        return $this;
    }
    /**
     * Get payment_claims_compensation value
     * @return float|null
     */
    public function getPayment_claims_compensation()
    {
        return $this->payment_claims_compensation;
    }
    /**
     * Set payment_claims_compensation value
     * @param float $payment_claims_compensation
     * @return \StructType\Finance
     */
    public function setPayment_claims_compensation($payment_claims_compensation = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($payment_claims_compensation) && strlen(substr($payment_claims_compensation, strpos($payment_claims_compensation, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($payment_claims_compensation, strpos($payment_claims_compensation, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($payment_claims_compensation) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $payment_claims_compensation)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($payment_claims_compensation, strpos($payment_claims_compensation, '.')))), __LINE__);
        }
        $this->payment_claims_compensation = $payment_claims_compensation;
        return $this;
    }
    /**
     * Get payment_claims_refusal value
     * @return float|null
     */
    public function getPayment_claims_refusal()
    {
        return $this->payment_claims_refusal;
    }
    /**
     * Set payment_claims_refusal value
     * @param float $payment_claims_refusal
     * @return \StructType\Finance
     */
    public function setPayment_claims_refusal($payment_claims_refusal = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($payment_claims_refusal) && strlen(substr($payment_claims_refusal, strpos($payment_claims_refusal, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($payment_claims_refusal, strpos($payment_claims_refusal, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($payment_claims_refusal) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $payment_claims_refusal)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($payment_claims_refusal, strpos($payment_claims_refusal, '.')))), __LINE__);
        }
        $this->payment_claims_refusal = $payment_claims_refusal;
        return $this;
    }
    /**
     * Get payment_claims_not_delivered value
     * @return float|null
     */
    public function getPayment_claims_not_delivered()
    {
        return $this->payment_claims_not_delivered;
    }
    /**
     * Set payment_claims_not_delivered value
     * @param float $payment_claims_not_delivered
     * @return \StructType\Finance
     */
    public function setPayment_claims_not_delivered($payment_claims_not_delivered = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($payment_claims_not_delivered) && strlen(substr($payment_claims_not_delivered, strpos($payment_claims_not_delivered, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($payment_claims_not_delivered, strpos($payment_claims_not_delivered, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($payment_claims_not_delivered) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $payment_claims_not_delivered)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($payment_claims_not_delivered, strpos($payment_claims_not_delivered, '.')))), __LINE__);
        }
        $this->payment_claims_not_delivered = $payment_claims_not_delivered;
        return $this;
    }
    /**
     * Get repair_work value
     * @return float|null
     */
    public function getRepair_work()
    {
        return $this->repair_work;
    }
    /**
     * Set repair_work value
     * @param float $repair_work
     * @return \StructType\Finance
     */
    public function setRepair_work($repair_work = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($repair_work) && strlen(substr($repair_work, strpos($repair_work, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($repair_work, strpos($repair_work, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($repair_work) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $repair_work)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($repair_work, strpos($repair_work, '.')))), __LINE__);
        }
        $this->repair_work = $repair_work;
        return $this;
    }
    /**
     * Get beautification_work value
     * @return float|null
     */
    public function getBeautification_work()
    {
        return $this->beautification_work;
    }
    /**
     * Set beautification_work value
     * @param float $beautification_work
     * @return \StructType\Finance
     */
    public function setBeautification_work($beautification_work = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($beautification_work) && strlen(substr($beautification_work, strpos($beautification_work, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($beautification_work, strpos($beautification_work, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($beautification_work) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $beautification_work)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($beautification_work, strpos($beautification_work, '.')))), __LINE__);
        }
        $this->beautification_work = $beautification_work;
        return $this;
    }
    /**
     * Get raised_funds_subsidies value
     * @return float|null
     */
    public function getRaised_funds_subsidies()
    {
        return $this->raised_funds_subsidies;
    }
    /**
     * Set raised_funds_subsidies value
     * @param float $raised_funds_subsidies
     * @return \StructType\Finance
     */
    public function setRaised_funds_subsidies($raised_funds_subsidies = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($raised_funds_subsidies) && strlen(substr($raised_funds_subsidies, strpos($raised_funds_subsidies, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($raised_funds_subsidies, strpos($raised_funds_subsidies, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($raised_funds_subsidies) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $raised_funds_subsidies)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($raised_funds_subsidies, strpos($raised_funds_subsidies, '.')))), __LINE__);
        }
        $this->raised_funds_subsidies = $raised_funds_subsidies;
        return $this;
    }
    /**
     * Get raised_funds_credits value
     * @return float|null
     */
    public function getRaised_funds_credits()
    {
        return $this->raised_funds_credits;
    }
    /**
     * Set raised_funds_credits value
     * @param float $raised_funds_credits
     * @return \StructType\Finance
     */
    public function setRaised_funds_credits($raised_funds_credits = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($raised_funds_credits) && strlen(substr($raised_funds_credits, strpos($raised_funds_credits, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($raised_funds_credits, strpos($raised_funds_credits, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($raised_funds_credits) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $raised_funds_credits)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($raised_funds_credits, strpos($raised_funds_credits, '.')))), __LINE__);
        }
        $this->raised_funds_credits = $raised_funds_credits;
        return $this;
    }
    /**
     * Get raised_funds_leasing value
     * @return float|null
     */
    public function getRaised_funds_leasing()
    {
        return $this->raised_funds_leasing;
    }
    /**
     * Set raised_funds_leasing value
     * @param float $raised_funds_leasing
     * @return \StructType\Finance
     */
    public function setRaised_funds_leasing($raised_funds_leasing = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($raised_funds_leasing) && strlen(substr($raised_funds_leasing, strpos($raised_funds_leasing, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($raised_funds_leasing, strpos($raised_funds_leasing, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($raised_funds_leasing) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $raised_funds_leasing)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($raised_funds_leasing, strpos($raised_funds_leasing, '.')))), __LINE__);
        }
        $this->raised_funds_leasing = $raised_funds_leasing;
        return $this;
    }
    /**
     * Get raised_funds_energy_service value
     * @return float|null
     */
    public function getRaised_funds_energy_service()
    {
        return $this->raised_funds_energy_service;
    }
    /**
     * Set raised_funds_energy_service value
     * @param float $raised_funds_energy_service
     * @return \StructType\Finance
     */
    public function setRaised_funds_energy_service($raised_funds_energy_service = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($raised_funds_energy_service) && strlen(substr($raised_funds_energy_service, strpos($raised_funds_energy_service, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($raised_funds_energy_service, strpos($raised_funds_energy_service, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($raised_funds_energy_service) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $raised_funds_energy_service)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($raised_funds_energy_service, strpos($raised_funds_energy_service, '.')))), __LINE__);
        }
        $this->raised_funds_energy_service = $raised_funds_energy_service;
        return $this;
    }
    /**
     * Get raised_funds_contributions value
     * @return float|null
     */
    public function getRaised_funds_contributions()
    {
        return $this->raised_funds_contributions;
    }
    /**
     * Set raised_funds_contributions value
     * @param float $raised_funds_contributions
     * @return \StructType\Finance
     */
    public function setRaised_funds_contributions($raised_funds_contributions = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($raised_funds_contributions) && strlen(substr($raised_funds_contributions, strpos($raised_funds_contributions, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($raised_funds_contributions, strpos($raised_funds_contributions, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($raised_funds_contributions) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $raised_funds_contributions)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($raised_funds_contributions, strpos($raised_funds_contributions, '.')))), __LINE__);
        }
        $this->raised_funds_contributions = $raised_funds_contributions;
        return $this;
    }
    /**
     * Get raised_funds_others value
     * @return float|null
     */
    public function getRaised_funds_others()
    {
        return $this->raised_funds_others;
    }
    /**
     * Set raised_funds_others value
     * @param float $raised_funds_others
     * @return \StructType\Finance
     */
    public function setRaised_funds_others($raised_funds_others = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($raised_funds_others) && strlen(substr($raised_funds_others, strpos($raised_funds_others, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($raised_funds_others, strpos($raised_funds_others, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($raised_funds_others) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $raised_funds_others)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($raised_funds_others, strpos($raised_funds_others, '.')))), __LINE__);
        }
        $this->raised_funds_others = $raised_funds_others;
        return $this;
    }
    /**
     * Get income_supply_heating value
     * @return float|null
     */
    public function getIncome_supply_heating()
    {
        return $this->income_supply_heating;
    }
    /**
     * Set income_supply_heating value
     * @param float $income_supply_heating
     * @return \StructType\Finance
     */
    public function setIncome_supply_heating($income_supply_heating = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($income_supply_heating) && strlen(substr($income_supply_heating, strpos($income_supply_heating, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($income_supply_heating, strpos($income_supply_heating, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($income_supply_heating) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $income_supply_heating)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($income_supply_heating, strpos($income_supply_heating, '.')))), __LINE__);
        }
        $this->income_supply_heating = $income_supply_heating;
        return $this;
    }
    /**
     * Get income_supply_electricity value
     * @return float|null
     */
    public function getIncome_supply_electricity()
    {
        return $this->income_supply_electricity;
    }
    /**
     * Set income_supply_electricity value
     * @param float $income_supply_electricity
     * @return \StructType\Finance
     */
    public function setIncome_supply_electricity($income_supply_electricity = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($income_supply_electricity) && strlen(substr($income_supply_electricity, strpos($income_supply_electricity, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($income_supply_electricity, strpos($income_supply_electricity, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($income_supply_electricity) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $income_supply_electricity)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($income_supply_electricity, strpos($income_supply_electricity, '.')))), __LINE__);
        }
        $this->income_supply_electricity = $income_supply_electricity;
        return $this;
    }
    /**
     * Get income_supply_gaz value
     * @return float|null
     */
    public function getIncome_supply_gaz()
    {
        return $this->income_supply_gaz;
    }
    /**
     * Set income_supply_gaz value
     * @param float $income_supply_gaz
     * @return \StructType\Finance
     */
    public function setIncome_supply_gaz($income_supply_gaz = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($income_supply_gaz) && strlen(substr($income_supply_gaz, strpos($income_supply_gaz, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($income_supply_gaz, strpos($income_supply_gaz, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($income_supply_gaz) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $income_supply_gaz)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($income_supply_gaz, strpos($income_supply_gaz, '.')))), __LINE__);
        }
        $this->income_supply_gaz = $income_supply_gaz;
        return $this;
    }
    /**
     * Get income_supply_hot_water value
     * @return float|null
     */
    public function getIncome_supply_hot_water()
    {
        return $this->income_supply_hot_water;
    }
    /**
     * Set income_supply_hot_water value
     * @param float $income_supply_hot_water
     * @return \StructType\Finance
     */
    public function setIncome_supply_hot_water($income_supply_hot_water = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($income_supply_hot_water) && strlen(substr($income_supply_hot_water, strpos($income_supply_hot_water, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($income_supply_hot_water, strpos($income_supply_hot_water, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($income_supply_hot_water) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $income_supply_hot_water)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($income_supply_hot_water, strpos($income_supply_hot_water, '.')))), __LINE__);
        }
        $this->income_supply_hot_water = $income_supply_hot_water;
        return $this;
    }
    /**
     * Get income_supply_cold_water value
     * @return float|null
     */
    public function getIncome_supply_cold_water()
    {
        return $this->income_supply_cold_water;
    }
    /**
     * Set income_supply_cold_water value
     * @param float $income_supply_cold_water
     * @return \StructType\Finance
     */
    public function setIncome_supply_cold_water($income_supply_cold_water = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($income_supply_cold_water) && strlen(substr($income_supply_cold_water, strpos($income_supply_cold_water, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($income_supply_cold_water, strpos($income_supply_cold_water, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($income_supply_cold_water) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $income_supply_cold_water)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($income_supply_cold_water, strpos($income_supply_cold_water, '.')))), __LINE__);
        }
        $this->income_supply_cold_water = $income_supply_cold_water;
        return $this;
    }
    /**
     * Get income_supply_wastewater value
     * @return float|null
     */
    public function getIncome_supply_wastewater()
    {
        return $this->income_supply_wastewater;
    }
    /**
     * Set income_supply_wastewater value
     * @param float $income_supply_wastewater
     * @return \StructType\Finance
     */
    public function setIncome_supply_wastewater($income_supply_wastewater = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($income_supply_wastewater) && strlen(substr($income_supply_wastewater, strpos($income_supply_wastewater, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($income_supply_wastewater, strpos($income_supply_wastewater, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($income_supply_wastewater) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $income_supply_wastewater)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($income_supply_wastewater, strpos($income_supply_wastewater, '.')))), __LINE__);
        }
        $this->income_supply_wastewater = $income_supply_wastewater;
        return $this;
    }
    /**
     * Get debt_owners_heating value
     * @return float|null
     */
    public function getDebt_owners_heating()
    {
        return $this->debt_owners_heating;
    }
    /**
     * Set debt_owners_heating value
     * @param float $debt_owners_heating
     * @return \StructType\Finance
     */
    public function setDebt_owners_heating($debt_owners_heating = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($debt_owners_heating) && strlen(substr($debt_owners_heating, strpos($debt_owners_heating, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($debt_owners_heating, strpos($debt_owners_heating, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($debt_owners_heating) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $debt_owners_heating)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($debt_owners_heating, strpos($debt_owners_heating, '.')))), __LINE__);
        }
        $this->debt_owners_heating = $debt_owners_heating;
        return $this;
    }
    /**
     * Get debt_owners_electricity value
     * @return float|null
     */
    public function getDebt_owners_electricity()
    {
        return $this->debt_owners_electricity;
    }
    /**
     * Set debt_owners_electricity value
     * @param float $debt_owners_electricity
     * @return \StructType\Finance
     */
    public function setDebt_owners_electricity($debt_owners_electricity = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($debt_owners_electricity) && strlen(substr($debt_owners_electricity, strpos($debt_owners_electricity, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($debt_owners_electricity, strpos($debt_owners_electricity, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($debt_owners_electricity) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $debt_owners_electricity)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($debt_owners_electricity, strpos($debt_owners_electricity, '.')))), __LINE__);
        }
        $this->debt_owners_electricity = $debt_owners_electricity;
        return $this;
    }
    /**
     * Get debt_owners_gaz value
     * @return float|null
     */
    public function getDebt_owners_gaz()
    {
        return $this->debt_owners_gaz;
    }
    /**
     * Set debt_owners_gaz value
     * @param float $debt_owners_gaz
     * @return \StructType\Finance
     */
    public function setDebt_owners_gaz($debt_owners_gaz = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($debt_owners_gaz) && strlen(substr($debt_owners_gaz, strpos($debt_owners_gaz, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($debt_owners_gaz, strpos($debt_owners_gaz, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($debt_owners_gaz) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $debt_owners_gaz)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($debt_owners_gaz, strpos($debt_owners_gaz, '.')))), __LINE__);
        }
        $this->debt_owners_gaz = $debt_owners_gaz;
        return $this;
    }
    /**
     * Get debt_owners_hot_water value
     * @return float|null
     */
    public function getDebt_owners_hot_water()
    {
        return $this->debt_owners_hot_water;
    }
    /**
     * Set debt_owners_hot_water value
     * @param float $debt_owners_hot_water
     * @return \StructType\Finance
     */
    public function setDebt_owners_hot_water($debt_owners_hot_water = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($debt_owners_hot_water) && strlen(substr($debt_owners_hot_water, strpos($debt_owners_hot_water, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($debt_owners_hot_water, strpos($debt_owners_hot_water, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($debt_owners_hot_water) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $debt_owners_hot_water)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($debt_owners_hot_water, strpos($debt_owners_hot_water, '.')))), __LINE__);
        }
        $this->debt_owners_hot_water = $debt_owners_hot_water;
        return $this;
    }
    /**
     * Get debt_owners_cold_water value
     * @return float|null
     */
    public function getDebt_owners_cold_water()
    {
        return $this->debt_owners_cold_water;
    }
    /**
     * Set debt_owners_cold_water value
     * @param float $debt_owners_cold_water
     * @return \StructType\Finance
     */
    public function setDebt_owners_cold_water($debt_owners_cold_water = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($debt_owners_cold_water) && strlen(substr($debt_owners_cold_water, strpos($debt_owners_cold_water, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($debt_owners_cold_water, strpos($debt_owners_cold_water, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($debt_owners_cold_water) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $debt_owners_cold_water)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($debt_owners_cold_water, strpos($debt_owners_cold_water, '.')))), __LINE__);
        }
        $this->debt_owners_cold_water = $debt_owners_cold_water;
        return $this;
    }
    /**
     * Get debt_owners_wastewater value
     * @return float|null
     */
    public function getDebt_owners_wastewater()
    {
        return $this->debt_owners_wastewater;
    }
    /**
     * Set debt_owners_wastewater value
     * @param float $debt_owners_wastewater
     * @return \StructType\Finance
     */
    public function setDebt_owners_wastewater($debt_owners_wastewater = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($debt_owners_wastewater) && strlen(substr($debt_owners_wastewater, strpos($debt_owners_wastewater, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($debt_owners_wastewater, strpos($debt_owners_wastewater, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($debt_owners_wastewater) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $debt_owners_wastewater)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($debt_owners_wastewater, strpos($debt_owners_wastewater, '.')))), __LINE__);
        }
        $this->debt_owners_wastewater = $debt_owners_wastewater;
        return $this;
    }
    /**
     * Get charged_services_heating value
     * @return float|null
     */
    public function getCharged_services_heating()
    {
        return $this->charged_services_heating;
    }
    /**
     * Set charged_services_heating value
     * @param float $charged_services_heating
     * @return \StructType\Finance
     */
    public function setCharged_services_heating($charged_services_heating = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($charged_services_heating) && strlen(substr($charged_services_heating, strpos($charged_services_heating, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($charged_services_heating, strpos($charged_services_heating, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($charged_services_heating) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $charged_services_heating)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($charged_services_heating, strpos($charged_services_heating, '.')))), __LINE__);
        }
        $this->charged_services_heating = $charged_services_heating;
        return $this;
    }
    /**
     * Get charged_services_electricity value
     * @return float|null
     */
    public function getCharged_services_electricity()
    {
        return $this->charged_services_electricity;
    }
    /**
     * Set charged_services_electricity value
     * @param float $charged_services_electricity
     * @return \StructType\Finance
     */
    public function setCharged_services_electricity($charged_services_electricity = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($charged_services_electricity) && strlen(substr($charged_services_electricity, strpos($charged_services_electricity, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($charged_services_electricity, strpos($charged_services_electricity, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($charged_services_electricity) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $charged_services_electricity)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($charged_services_electricity, strpos($charged_services_electricity, '.')))), __LINE__);
        }
        $this->charged_services_electricity = $charged_services_electricity;
        return $this;
    }
    /**
     * Get charged_services_gaz value
     * @return float|null
     */
    public function getCharged_services_gaz()
    {
        return $this->charged_services_gaz;
    }
    /**
     * Set charged_services_gaz value
     * @param float $charged_services_gaz
     * @return \StructType\Finance
     */
    public function setCharged_services_gaz($charged_services_gaz = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($charged_services_gaz) && strlen(substr($charged_services_gaz, strpos($charged_services_gaz, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($charged_services_gaz, strpos($charged_services_gaz, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($charged_services_gaz) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $charged_services_gaz)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($charged_services_gaz, strpos($charged_services_gaz, '.')))), __LINE__);
        }
        $this->charged_services_gaz = $charged_services_gaz;
        return $this;
    }
    /**
     * Get charged_services_hot_water value
     * @return float|null
     */
    public function getCharged_services_hot_water()
    {
        return $this->charged_services_hot_water;
    }
    /**
     * Set charged_services_hot_water value
     * @param float $charged_services_hot_water
     * @return \StructType\Finance
     */
    public function setCharged_services_hot_water($charged_services_hot_water = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($charged_services_hot_water) && strlen(substr($charged_services_hot_water, strpos($charged_services_hot_water, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($charged_services_hot_water, strpos($charged_services_hot_water, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($charged_services_hot_water) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $charged_services_hot_water)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($charged_services_hot_water, strpos($charged_services_hot_water, '.')))), __LINE__);
        }
        $this->charged_services_hot_water = $charged_services_hot_water;
        return $this;
    }
    /**
     * Get charged_services_cold_water value
     * @return float|null
     */
    public function getCharged_services_cold_water()
    {
        return $this->charged_services_cold_water;
    }
    /**
     * Set charged_services_cold_water value
     * @param float $charged_services_cold_water
     * @return \StructType\Finance
     */
    public function setCharged_services_cold_water($charged_services_cold_water = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($charged_services_cold_water) && strlen(substr($charged_services_cold_water, strpos($charged_services_cold_water, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($charged_services_cold_water, strpos($charged_services_cold_water, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($charged_services_cold_water) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $charged_services_cold_water)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($charged_services_cold_water, strpos($charged_services_cold_water, '.')))), __LINE__);
        }
        $this->charged_services_cold_water = $charged_services_cold_water;
        return $this;
    }
    /**
     * Get charged_services_wastewater value
     * @return float|null
     */
    public function getCharged_services_wastewater()
    {
        return $this->charged_services_wastewater;
    }
    /**
     * Set charged_services_wastewater value
     * @param float $charged_services_wastewater
     * @return \StructType\Finance
     */
    public function setCharged_services_wastewater($charged_services_wastewater = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($charged_services_wastewater) && strlen(substr($charged_services_wastewater, strpos($charged_services_wastewater, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($charged_services_wastewater, strpos($charged_services_wastewater, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($charged_services_wastewater) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $charged_services_wastewater)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($charged_services_wastewater, strpos($charged_services_wastewater, '.')))), __LINE__);
        }
        $this->charged_services_wastewater = $charged_services_wastewater;
        return $this;
    }
    /**
     * Get paid_services_heating value
     * @return float|null
     */
    public function getPaid_services_heating()
    {
        return $this->paid_services_heating;
    }
    /**
     * Set paid_services_heating value
     * @param float $paid_services_heating
     * @return \StructType\Finance
     */
    public function setPaid_services_heating($paid_services_heating = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($paid_services_heating) && strlen(substr($paid_services_heating, strpos($paid_services_heating, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($paid_services_heating, strpos($paid_services_heating, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($paid_services_heating) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $paid_services_heating)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($paid_services_heating, strpos($paid_services_heating, '.')))), __LINE__);
        }
        $this->paid_services_heating = $paid_services_heating;
        return $this;
    }
    /**
     * Get paid_services_electricity value
     * @return float|null
     */
    public function getPaid_services_electricity()
    {
        return $this->paid_services_electricity;
    }
    /**
     * Set paid_services_electricity value
     * @param float $paid_services_electricity
     * @return \StructType\Finance
     */
    public function setPaid_services_electricity($paid_services_electricity = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($paid_services_electricity) && strlen(substr($paid_services_electricity, strpos($paid_services_electricity, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($paid_services_electricity, strpos($paid_services_electricity, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($paid_services_electricity) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $paid_services_electricity)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($paid_services_electricity, strpos($paid_services_electricity, '.')))), __LINE__);
        }
        $this->paid_services_electricity = $paid_services_electricity;
        return $this;
    }
    /**
     * Get paid_services_gaz value
     * @return float|null
     */
    public function getPaid_services_gaz()
    {
        return $this->paid_services_gaz;
    }
    /**
     * Set paid_services_gaz value
     * @param float $paid_services_gaz
     * @return \StructType\Finance
     */
    public function setPaid_services_gaz($paid_services_gaz = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($paid_services_gaz) && strlen(substr($paid_services_gaz, strpos($paid_services_gaz, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($paid_services_gaz, strpos($paid_services_gaz, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($paid_services_gaz) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $paid_services_gaz)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($paid_services_gaz, strpos($paid_services_gaz, '.')))), __LINE__);
        }
        $this->paid_services_gaz = $paid_services_gaz;
        return $this;
    }
    /**
     * Get paid_services_hot_water value
     * @return float|null
     */
    public function getPaid_services_hot_water()
    {
        return $this->paid_services_hot_water;
    }
    /**
     * Set paid_services_hot_water value
     * @param float $paid_services_hot_water
     * @return \StructType\Finance
     */
    public function setPaid_services_hot_water($paid_services_hot_water = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($paid_services_hot_water) && strlen(substr($paid_services_hot_water, strpos($paid_services_hot_water, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($paid_services_hot_water, strpos($paid_services_hot_water, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($paid_services_hot_water) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $paid_services_hot_water)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($paid_services_hot_water, strpos($paid_services_hot_water, '.')))), __LINE__);
        }
        $this->paid_services_hot_water = $paid_services_hot_water;
        return $this;
    }
    /**
     * Get paid_services_cold_water value
     * @return float|null
     */
    public function getPaid_services_cold_water()
    {
        return $this->paid_services_cold_water;
    }
    /**
     * Set paid_services_cold_water value
     * @param float $paid_services_cold_water
     * @return \StructType\Finance
     */
    public function setPaid_services_cold_water($paid_services_cold_water = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($paid_services_cold_water) && strlen(substr($paid_services_cold_water, strpos($paid_services_cold_water, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($paid_services_cold_water, strpos($paid_services_cold_water, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($paid_services_cold_water) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $paid_services_cold_water)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($paid_services_cold_water, strpos($paid_services_cold_water, '.')))), __LINE__);
        }
        $this->paid_services_cold_water = $paid_services_cold_water;
        return $this;
    }
    /**
     * Get paid_resources_heating value
     * @return float|null
     */
    public function getPaid_resources_heating()
    {
        return $this->paid_resources_heating;
    }
    /**
     * Set paid_resources_heating value
     * @param float $paid_resources_heating
     * @return \StructType\Finance
     */
    public function setPaid_resources_heating($paid_resources_heating = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($paid_resources_heating) && strlen(substr($paid_resources_heating, strpos($paid_resources_heating, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($paid_resources_heating, strpos($paid_resources_heating, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($paid_resources_heating) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $paid_resources_heating)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($paid_resources_heating, strpos($paid_resources_heating, '.')))), __LINE__);
        }
        $this->paid_resources_heating = $paid_resources_heating;
        return $this;
    }
    /**
     * Get paid_resources_electricity value
     * @return float|null
     */
    public function getPaid_resources_electricity()
    {
        return $this->paid_resources_electricity;
    }
    /**
     * Set paid_resources_electricity value
     * @param float $paid_resources_electricity
     * @return \StructType\Finance
     */
    public function setPaid_resources_electricity($paid_resources_electricity = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($paid_resources_electricity) && strlen(substr($paid_resources_electricity, strpos($paid_resources_electricity, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($paid_resources_electricity, strpos($paid_resources_electricity, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($paid_resources_electricity) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $paid_resources_electricity)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($paid_resources_electricity, strpos($paid_resources_electricity, '.')))), __LINE__);
        }
        $this->paid_resources_electricity = $paid_resources_electricity;
        return $this;
    }
    /**
     * Get paid_resources_gaz value
     * @return float|null
     */
    public function getPaid_resources_gaz()
    {
        return $this->paid_resources_gaz;
    }
    /**
     * Set paid_resources_gaz value
     * @param float $paid_resources_gaz
     * @return \StructType\Finance
     */
    public function setPaid_resources_gaz($paid_resources_gaz = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($paid_resources_gaz) && strlen(substr($paid_resources_gaz, strpos($paid_resources_gaz, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($paid_resources_gaz, strpos($paid_resources_gaz, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($paid_resources_gaz) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $paid_resources_gaz)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($paid_resources_gaz, strpos($paid_resources_gaz, '.')))), __LINE__);
        }
        $this->paid_resources_gaz = $paid_resources_gaz;
        return $this;
    }
    /**
     * Get paid_resources_hot_water value
     * @return float|null
     */
    public function getPaid_resources_hot_water()
    {
        return $this->paid_resources_hot_water;
    }
    /**
     * Set paid_resources_hot_water value
     * @param float $paid_resources_hot_water
     * @return \StructType\Finance
     */
    public function setPaid_resources_hot_water($paid_resources_hot_water = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($paid_resources_hot_water) && strlen(substr($paid_resources_hot_water, strpos($paid_resources_hot_water, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($paid_resources_hot_water, strpos($paid_resources_hot_water, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($paid_resources_hot_water) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $paid_resources_hot_water)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($paid_resources_hot_water, strpos($paid_resources_hot_water, '.')))), __LINE__);
        }
        $this->paid_resources_hot_water = $paid_resources_hot_water;
        return $this;
    }
    /**
     * Get paid_resources_cold_water value
     * @return float|null
     */
    public function getPaid_resources_cold_water()
    {
        return $this->paid_resources_cold_water;
    }
    /**
     * Set paid_resources_cold_water value
     * @param float $paid_resources_cold_water
     * @return \StructType\Finance
     */
    public function setPaid_resources_cold_water($paid_resources_cold_water = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($paid_resources_cold_water) && strlen(substr($paid_resources_cold_water, strpos($paid_resources_cold_water, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($paid_resources_cold_water, strpos($paid_resources_cold_water, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($paid_resources_cold_water) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $paid_resources_cold_water)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($paid_resources_cold_water, strpos($paid_resources_cold_water, '.')))), __LINE__);
        }
        $this->paid_resources_cold_water = $paid_resources_cold_water;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Finance
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
