<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HouseRoof StructType
 * @subpackage Structs
 */
class HouseRoof extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $id;
    /**
     * The roof_type
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $roof_type;
    /**
     * The roofing_type
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $roofing_type;
    /**
     * Constructor method for HouseRoof
     * @uses HouseRoof::setId()
     * @uses HouseRoof::setRoof_type()
     * @uses HouseRoof::setRoofing_type()
     * @param int $id
     * @param string $roof_type
     * @param string $roofing_type
     */
    public function __construct($id = null, $roof_type = null, $roofing_type = null)
    {
        $this
            ->setId($id)
            ->setRoof_type($roof_type)
            ->setRoofing_type($roofing_type);
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\HouseRoof
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get roof_type value
     * @return string|null
     */
    public function getRoof_type()
    {
        return $this->roof_type;
    }
    /**
     * Set roof_type value
     * @uses \EnumType\HouseRoofTypeEnum::valueIsValid()
     * @uses \EnumType\HouseRoofTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $roof_type
     * @return \StructType\HouseRoof
     */
    public function setRoof_type($roof_type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\HouseRoofTypeEnum::valueIsValid($roof_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\HouseRoofTypeEnum', is_array($roof_type) ? implode(', ', $roof_type) : var_export($roof_type, true), implode(', ', \EnumType\HouseRoofTypeEnum::getValidValues())), __LINE__);
        }
        $this->roof_type = $roof_type;
        return $this;
    }
    /**
     * Get roofing_type value
     * @return string|null
     */
    public function getRoofing_type()
    {
        return $this->roofing_type;
    }
    /**
     * Set roofing_type value
     * @uses \EnumType\HouseRoofingTypeEnum::valueIsValid()
     * @uses \EnumType\HouseRoofingTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $roofing_type
     * @return \StructType\HouseRoof
     */
    public function setRoofing_type($roofing_type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\HouseRoofingTypeEnum::valueIsValid($roofing_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\HouseRoofingTypeEnum', is_array($roofing_type) ? implode(', ', $roofing_type) : var_export($roofing_type, true), implode(', ', \EnumType\HouseRoofingTypeEnum::getValidValues())), __LINE__);
        }
        $this->roofing_type = $roofing_type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HouseRoof
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
