<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HouseMeteringDevice StructType
 * @subpackage Structs
 */
class HouseMeteringDevice extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $id;
    /**
     * The communal_resource_type
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $communal_resource_type;
    /**
     * The availability
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $availability;
    /**
     * The meter_type
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $meter_type;
    /**
     * The unit_of_measurement
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $unit_of_measurement;
    /**
     * The commissioning_date
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $commissioning_date;
    /**
     * The calibration_date
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $calibration_date;
    /**
     * The is_default
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var bool
     */
    public $is_default;
    /**
     * Constructor method for HouseMeteringDevice
     * @uses HouseMeteringDevice::setId()
     * @uses HouseMeteringDevice::setCommunal_resource_type()
     * @uses HouseMeteringDevice::setAvailability()
     * @uses HouseMeteringDevice::setMeter_type()
     * @uses HouseMeteringDevice::setUnit_of_measurement()
     * @uses HouseMeteringDevice::setCommissioning_date()
     * @uses HouseMeteringDevice::setCalibration_date()
     * @uses HouseMeteringDevice::setIs_default()
     * @param int $id
     * @param string $communal_resource_type
     * @param string $availability
     * @param string $meter_type
     * @param string $unit_of_measurement
     * @param string $commissioning_date
     * @param string $calibration_date
     * @param bool $is_default
     */
    public function __construct($id = null, $communal_resource_type = null, $availability = null, $meter_type = null, $unit_of_measurement = null, $commissioning_date = null, $calibration_date = null, $is_default = null)
    {
        $this
            ->setId($id)
            ->setCommunal_resource_type($communal_resource_type)
            ->setAvailability($availability)
            ->setMeter_type($meter_type)
            ->setUnit_of_measurement($unit_of_measurement)
            ->setCommissioning_date($commissioning_date)
            ->setCalibration_date($calibration_date)
            ->setIs_default($is_default);
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\HouseMeteringDevice
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get communal_resource_type value
     * @return string|null
     */
    public function getCommunal_resource_type()
    {
        return $this->communal_resource_type;
    }
    /**
     * Set communal_resource_type value
     * @uses \EnumType\HouseCommunalServiceTypeEnum::valueIsValid()
     * @uses \EnumType\HouseCommunalServiceTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $communal_resource_type
     * @return \StructType\HouseMeteringDevice
     */
    public function setCommunal_resource_type($communal_resource_type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\HouseCommunalServiceTypeEnum::valueIsValid($communal_resource_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\HouseCommunalServiceTypeEnum', is_array($communal_resource_type) ? implode(', ', $communal_resource_type) : var_export($communal_resource_type, true), implode(', ', \EnumType\HouseCommunalServiceTypeEnum::getValidValues())), __LINE__);
        }
        $this->communal_resource_type = $communal_resource_type;
        return $this;
    }
    /**
     * Get availability value
     * @return string|null
     */
    public function getAvailability()
    {
        return $this->availability;
    }
    /**
     * Set availability value
     * @uses \EnumType\MeteringDeviceAvailabilityEnum::valueIsValid()
     * @uses \EnumType\MeteringDeviceAvailabilityEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $availability
     * @return \StructType\HouseMeteringDevice
     */
    public function setAvailability($availability = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\MeteringDeviceAvailabilityEnum::valueIsValid($availability)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\MeteringDeviceAvailabilityEnum', is_array($availability) ? implode(', ', $availability) : var_export($availability, true), implode(', ', \EnumType\MeteringDeviceAvailabilityEnum::getValidValues())), __LINE__);
        }
        $this->availability = $availability;
        return $this;
    }
    /**
     * Get meter_type value
     * @return string|null
     */
    public function getMeter_type()
    {
        return $this->meter_type;
    }
    /**
     * Set meter_type value
     * @uses \EnumType\HouseMeterTypeEnum::valueIsValid()
     * @uses \EnumType\HouseMeterTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $meter_type
     * @return \StructType\HouseMeteringDevice
     */
    public function setMeter_type($meter_type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\HouseMeterTypeEnum::valueIsValid($meter_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\HouseMeterTypeEnum', is_array($meter_type) ? implode(', ', $meter_type) : var_export($meter_type, true), implode(', ', \EnumType\HouseMeterTypeEnum::getValidValues())), __LINE__);
        }
        $this->meter_type = $meter_type;
        return $this;
    }
    /**
     * Get unit_of_measurement value
     * @return string|null
     */
    public function getUnit_of_measurement()
    {
        return $this->unit_of_measurement;
    }
    /**
     * Set unit_of_measurement value
     * @uses \EnumType\UnitOfMeasureEnum::valueIsValid()
     * @uses \EnumType\UnitOfMeasureEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $unit_of_measurement
     * @return \StructType\HouseMeteringDevice
     */
    public function setUnit_of_measurement($unit_of_measurement = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\UnitOfMeasureEnum::valueIsValid($unit_of_measurement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\UnitOfMeasureEnum', is_array($unit_of_measurement) ? implode(', ', $unit_of_measurement) : var_export($unit_of_measurement, true), implode(', ', \EnumType\UnitOfMeasureEnum::getValidValues())), __LINE__);
        }
        $this->unit_of_measurement = $unit_of_measurement;
        return $this;
    }
    /**
     * Get commissioning_date value
     * @return string|null
     */
    public function getCommissioning_date()
    {
        return $this->commissioning_date;
    }
    /**
     * Set commissioning_date value
     * @param string $commissioning_date
     * @return \StructType\HouseMeteringDevice
     */
    public function setCommissioning_date($commissioning_date = null)
    {
        // validation for constraint: string
        if (!is_null($commissioning_date) && !is_string($commissioning_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commissioning_date, true), gettype($commissioning_date)), __LINE__);
        }
        $this->commissioning_date = $commissioning_date;
        return $this;
    }
    /**
     * Get calibration_date value
     * @return string|null
     */
    public function getCalibration_date()
    {
        return $this->calibration_date;
    }
    /**
     * Set calibration_date value
     * @param string $calibration_date
     * @return \StructType\HouseMeteringDevice
     */
    public function setCalibration_date($calibration_date = null)
    {
        // validation for constraint: string
        if (!is_null($calibration_date) && !is_string($calibration_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($calibration_date, true), gettype($calibration_date)), __LINE__);
        }
        $this->calibration_date = $calibration_date;
        return $this;
    }
    /**
     * Get is_default value
     * @return bool|null
     */
    public function getIs_default()
    {
        return $this->is_default;
    }
    /**
     * Set is_default value
     * @param bool $is_default
     * @return \StructType\HouseMeteringDevice
     */
    public function setIs_default($is_default = null)
    {
        // validation for constraint: boolean
        if (!is_null($is_default) && !is_bool($is_default)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($is_default, true), gettype($is_default)), __LINE__);
        }
        $this->is_default = $is_default;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HouseMeteringDevice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
