<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HouseInfo StructType
 * @subpackage Structs
 */
class HouseInfo extends AbstractStructBase
{
    /**
     * The house_id
     * @var int
     */
    public $house_id;
    /**
     * The state
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $state;
    /**
     * The stage
     * @var string
     */
    public $stage;
    /**
     * The drifting_date
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $drifting_date;
    /**
     * The full_address
     * @var \StructType\FullAddress
     */
    public $full_address;
    /**
     * The inn
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $inn;
    /**
     * Constructor method for HouseInfo
     * @uses HouseInfo::setHouse_id()
     * @uses HouseInfo::setState()
     * @uses HouseInfo::setStage()
     * @uses HouseInfo::setDrifting_date()
     * @uses HouseInfo::setFull_address()
     * @uses HouseInfo::setInn()
     * @param int $house_id
     * @param string $state
     * @param string $stage
     * @param string $drifting_date
     * @param \StructType\FullAddress $full_address
     * @param string $inn
     */
    public function __construct($house_id = null, $state = null, $stage = null, $drifting_date = null, \StructType\FullAddress $full_address = null, $inn = null)
    {
        $this
            ->setHouse_id($house_id)
            ->setState($state)
            ->setStage($stage)
            ->setDrifting_date($drifting_date)
            ->setFull_address($full_address)
            ->setInn($inn);
    }
    /**
     * Get house_id value
     * @return int|null
     */
    public function getHouse_id()
    {
        return $this->house_id;
    }
    /**
     * Set house_id value
     * @param int $house_id
     * @return \StructType\HouseInfo
     */
    public function setHouse_id($house_id = null)
    {
        // validation for constraint: int
        if (!is_null($house_id) && !(is_int($house_id) || ctype_digit($house_id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($house_id, true), gettype($house_id)), __LINE__);
        }
        $this->house_id = $house_id;
        return $this;
    }
    /**
     * Get state value
     * @return string|null
     */
    public function getState()
    {
        return $this->state;
    }
    /**
     * Set state value
     * @uses \EnumType\HouseStateEnum::valueIsValid()
     * @uses \EnumType\HouseStateEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $state
     * @return \StructType\HouseInfo
     */
    public function setState($state = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\HouseStateEnum::valueIsValid($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\HouseStateEnum', is_array($state) ? implode(', ', $state) : var_export($state, true), implode(', ', \EnumType\HouseStateEnum::getValidValues())), __LINE__);
        }
        $this->state = $state;
        return $this;
    }
    /**
     * Get stage value
     * @return string|null
     */
    public function getStage()
    {
        return $this->stage;
    }
    /**
     * Set stage value
     * @uses \EnumType\HouseStageEnum::valueIsValid()
     * @uses \EnumType\HouseStageEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $stage
     * @return \StructType\HouseInfo
     */
    public function setStage($stage = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\HouseStageEnum::valueIsValid($stage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\HouseStageEnum', is_array($stage) ? implode(', ', $stage) : var_export($stage, true), implode(', ', \EnumType\HouseStageEnum::getValidValues())), __LINE__);
        }
        $this->stage = $stage;
        return $this;
    }
    /**
     * Get drifting_date value
     * @return string|null
     */
    public function getDrifting_date()
    {
        return $this->drifting_date;
    }
    /**
     * Set drifting_date value
     * @param string $drifting_date
     * @return \StructType\HouseInfo
     */
    public function setDrifting_date($drifting_date = null)
    {
        // validation for constraint: string
        if (!is_null($drifting_date) && !is_string($drifting_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($drifting_date, true), gettype($drifting_date)), __LINE__);
        }
        $this->drifting_date = $drifting_date;
        return $this;
    }
    /**
     * Get full_address value
     * @return \StructType\FullAddress|null
     */
    public function getFull_address()
    {
        return $this->full_address;
    }
    /**
     * Set full_address value
     * @param \StructType\FullAddress $full_address
     * @return \StructType\HouseInfo
     */
    public function setFull_address(\StructType\FullAddress $full_address = null)
    {
        $this->full_address = $full_address;
        return $this;
    }
    /**
     * Get inn value
     * @return string|null
     */
    public function getInn()
    {
        return $this->inn;
    }
    /**
     * Set inn value
     * @param string $inn
     * @return \StructType\HouseInfo
     */
    public function setInn($inn = null)
    {
        // validation for constraint: string
        if (!is_null($inn) && !is_string($inn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inn, true), gettype($inn)), __LINE__);
        }
        $this->inn = $inn;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HouseInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
