<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HouseCommonProperty StructType
 * @subpackage Structs
 */
class HouseCommonProperty extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $id;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $name;
    /**
     * The function
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $function;
    /**
     * The area
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $area;
    /**
     * The rent
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\HouseCommonPropertyRent
     */
    public $rent;
    /**
     * Constructor method for HouseCommonProperty
     * @uses HouseCommonProperty::setId()
     * @uses HouseCommonProperty::setName()
     * @uses HouseCommonProperty::setFunction()
     * @uses HouseCommonProperty::setArea()
     * @uses HouseCommonProperty::setRent()
     * @param int $id
     * @param string $name
     * @param string $function
     * @param float $area
     * @param \StructType\HouseCommonPropertyRent $rent
     */
    public function __construct($id = null, $name = null, $function = null, $area = null, \StructType\HouseCommonPropertyRent $rent = null)
    {
        $this
            ->setId($id)
            ->setName($name)
            ->setFunction($function)
            ->setArea($area)
            ->setRent($rent);
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\HouseCommonProperty
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\HouseCommonProperty
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get function value
     * @return string|null
     */
    public function getFunction()
    {
        return $this->function;
    }
    /**
     * Set function value
     * @param string $function
     * @return \StructType\HouseCommonProperty
     */
    public function setFunction($function = null)
    {
        // validation for constraint: string
        if (!is_null($function) && !is_string($function)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($function, true), gettype($function)), __LINE__);
        }
        $this->function = $function;
        return $this;
    }
    /**
     * Get area value
     * @return float|null
     */
    public function getArea()
    {
        return $this->area;
    }
    /**
     * Set area value
     * @param float $area
     * @return \StructType\HouseCommonProperty
     */
    public function setArea($area = null)
    {
        // validation for constraint: float
        if (!is_null($area) && !(is_float($area) || is_numeric($area))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($area, true), gettype($area)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($area) && mb_strlen(mb_substr($area, mb_strpos($area, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($area, true), mb_strlen(mb_substr($area, mb_strpos($area, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($area) && mb_strlen(preg_replace('/(\D)/', '', $area)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($area, true), mb_strlen(preg_replace('/(\D)/', '', $area))), __LINE__);
        }
        $this->area = $area;
        return $this;
    }
    /**
     * Get rent value
     * @return \StructType\HouseCommonPropertyRent|null
     */
    public function getRent()
    {
        return $this->rent;
    }
    /**
     * Set rent value
     * @param \StructType\HouseCommonPropertyRent $rent
     * @return \StructType\HouseCommonProperty
     */
    public function setRent(\StructType\HouseCommonPropertyRent $rent = null)
    {
        $this->rent = $rent;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HouseCommonProperty
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
