<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotWaterSystem StructType
 * @subpackage Structs
 */
class HotWaterSystem extends AbstractStructBase
{
    /**
     * The system_name
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $system_name;
    /**
     * The system_length
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $system_length;
    /**
     * The last_overhaul_date
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $last_overhaul_date;
    /**
     * The input_points_count
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $input_points_count;
    /**
     * The control_nodes_count
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $control_nodes_count;
    /**
     * The metering_devices_count
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $metering_devices_count;
    /**
     * The provisioning
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $provisioning;
    /**
     * Constructor method for HotWaterSystem
     * @uses HotWaterSystem::setSystem_name()
     * @uses HotWaterSystem::setSystem_length()
     * @uses HotWaterSystem::setLast_overhaul_date()
     * @uses HotWaterSystem::setInput_points_count()
     * @uses HotWaterSystem::setControl_nodes_count()
     * @uses HotWaterSystem::setMetering_devices_count()
     * @uses HotWaterSystem::setProvisioning()
     * @param string $system_name
     * @param float $system_length
     * @param string $last_overhaul_date
     * @param int $input_points_count
     * @param int $control_nodes_count
     * @param int $metering_devices_count
     * @param string $provisioning
     */
    public function __construct($system_name = null, $system_length = null, $last_overhaul_date = null, $input_points_count = null, $control_nodes_count = null, $metering_devices_count = null, $provisioning = null)
    {
        $this
            ->setSystem_name($system_name)
            ->setSystem_length($system_length)
            ->setLast_overhaul_date($last_overhaul_date)
            ->setInput_points_count($input_points_count)
            ->setControl_nodes_count($control_nodes_count)
            ->setMetering_devices_count($metering_devices_count)
            ->setProvisioning($provisioning);
    }
    /**
     * Get system_name value
     * @return string|null
     */
    public function getSystem_name()
    {
        return $this->system_name;
    }
    /**
     * Set system_name value
     * @uses \EnumType\HotWaterSystemNameEnum::valueIsValid()
     * @uses \EnumType\HotWaterSystemNameEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $system_name
     * @return \StructType\HotWaterSystem
     */
    public function setSystem_name($system_name = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\HotWaterSystemNameEnum::valueIsValid($system_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\HotWaterSystemNameEnum', is_array($system_name) ? implode(', ', $system_name) : var_export($system_name, true), implode(', ', \EnumType\HotWaterSystemNameEnum::getValidValues())), __LINE__);
        }
        $this->system_name = $system_name;
        return $this;
    }
    /**
     * Get system_length value
     * @return float|null
     */
    public function getSystem_length()
    {
        return $this->system_length;
    }
    /**
     * Set system_length value
     * @param float $system_length
     * @return \StructType\HotWaterSystem
     */
    public function setSystem_length($system_length = null)
    {
        // validation for constraint: float
        if (!is_null($system_length) && !(is_float($system_length) || is_numeric($system_length))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($system_length, true), gettype($system_length)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($system_length) && mb_strlen(mb_substr($system_length, mb_strpos($system_length, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($system_length, true), mb_strlen(mb_substr($system_length, mb_strpos($system_length, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($system_length) && mb_strlen(preg_replace('/(\D)/', '', $system_length)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($system_length, true), mb_strlen(preg_replace('/(\D)/', '', $system_length))), __LINE__);
        }
        $this->system_length = $system_length;
        return $this;
    }
    /**
     * Get last_overhaul_date value
     * @return string|null
     */
    public function getLast_overhaul_date()
    {
        return $this->last_overhaul_date;
    }
    /**
     * Set last_overhaul_date value
     * @param string $last_overhaul_date
     * @return \StructType\HotWaterSystem
     */
    public function setLast_overhaul_date($last_overhaul_date = null)
    {
        // validation for constraint: string
        if (!is_null($last_overhaul_date) && !is_string($last_overhaul_date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($last_overhaul_date, true), gettype($last_overhaul_date)), __LINE__);
        }
        $this->last_overhaul_date = $last_overhaul_date;
        return $this;
    }
    /**
     * Get input_points_count value
     * @return int|null
     */
    public function getInput_points_count()
    {
        return $this->input_points_count;
    }
    /**
     * Set input_points_count value
     * @param int $input_points_count
     * @return \StructType\HotWaterSystem
     */
    public function setInput_points_count($input_points_count = null)
    {
        // validation for constraint: int
        if (!is_null($input_points_count) && !(is_int($input_points_count) || ctype_digit($input_points_count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($input_points_count, true), gettype($input_points_count)), __LINE__);
        }
        $this->input_points_count = $input_points_count;
        return $this;
    }
    /**
     * Get control_nodes_count value
     * @return int|null
     */
    public function getControl_nodes_count()
    {
        return $this->control_nodes_count;
    }
    /**
     * Set control_nodes_count value
     * @param int $control_nodes_count
     * @return \StructType\HotWaterSystem
     */
    public function setControl_nodes_count($control_nodes_count = null)
    {
        // validation for constraint: int
        if (!is_null($control_nodes_count) && !(is_int($control_nodes_count) || ctype_digit($control_nodes_count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($control_nodes_count, true), gettype($control_nodes_count)), __LINE__);
        }
        $this->control_nodes_count = $control_nodes_count;
        return $this;
    }
    /**
     * Get metering_devices_count value
     * @return int|null
     */
    public function getMetering_devices_count()
    {
        return $this->metering_devices_count;
    }
    /**
     * Set metering_devices_count value
     * @param int $metering_devices_count
     * @return \StructType\HotWaterSystem
     */
    public function setMetering_devices_count($metering_devices_count = null)
    {
        // validation for constraint: int
        if (!is_null($metering_devices_count) && !(is_int($metering_devices_count) || ctype_digit($metering_devices_count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($metering_devices_count, true), gettype($metering_devices_count)), __LINE__);
        }
        $this->metering_devices_count = $metering_devices_count;
        return $this;
    }
    /**
     * Get provisioning value
     * @return string|null
     */
    public function getProvisioning()
    {
        return $this->provisioning;
    }
    /**
     * Set provisioning value
     * @uses \EnumType\ProvisioningEnum::valueIsValid()
     * @uses \EnumType\ProvisioningEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $provisioning
     * @return \StructType\HotWaterSystem
     */
    public function setProvisioning($provisioning = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ProvisioningEnum::valueIsValid($provisioning)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ProvisioningEnum', is_array($provisioning) ? implode(', ', $provisioning) : var_export($provisioning, true), implode(', ', \EnumType\ProvisioningEnum::getValidValues())), __LINE__);
        }
        $this->provisioning = $provisioning;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HotWaterSystem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
