<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetHouseListChangesHandlerResponse StructType
 * @subpackage Structs
 */
class GetHouseListChangesHandlerResponse extends AbstractStructBase
{
    /**
     * The data
     * @var \ArrayType\ArrayOfHouseChangesData
     */
    public $data;
    /**
     * The page_number
     * @var int
     */
    public $page_number;
    /**
     * The page_count
     * @var int
     */
    public $page_count;
    /**
     * Constructor method for GetHouseListChangesHandlerResponse
     * @uses GetHouseListChangesHandlerResponse::setData()
     * @uses GetHouseListChangesHandlerResponse::setPage_number()
     * @uses GetHouseListChangesHandlerResponse::setPage_count()
     * @param \ArrayType\ArrayOfHouseChangesData $data
     * @param int $page_number
     * @param int $page_count
     */
    public function __construct(\ArrayType\ArrayOfHouseChangesData $data = null, $page_number = null, $page_count = null)
    {
        $this
            ->setData($data)
            ->setPage_number($page_number)
            ->setPage_count($page_count);
    }
    /**
     * Get data value
     * @return \ArrayType\ArrayOfHouseChangesData|null
     */
    public function getData()
    {
        return $this->data;
    }
    /**
     * Set data value
     * @param \ArrayType\ArrayOfHouseChangesData $data
     * @return \StructType\GetHouseListChangesHandlerResponse
     */
    public function setData(\ArrayType\ArrayOfHouseChangesData $data = null)
    {
        $this->data = $data;
        return $this;
    }
    /**
     * Get page_number value
     * @return int|null
     */
    public function getPage_number()
    {
        return $this->page_number;
    }
    /**
     * Set page_number value
     * @param int $page_number
     * @return \StructType\GetHouseListChangesHandlerResponse
     */
    public function setPage_number($page_number = null)
    {
        // validation for constraint: int
        if (!is_null($page_number) && !(is_int($page_number) || ctype_digit($page_number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($page_number, true), gettype($page_number)), __LINE__);
        }
        $this->page_number = $page_number;
        return $this;
    }
    /**
     * Get page_count value
     * @return int|null
     */
    public function getPage_count()
    {
        return $this->page_count;
    }
    /**
     * Set page_count value
     * @param int $page_count
     * @return \StructType\GetHouseListChangesHandlerResponse
     */
    public function setPage_count($page_count = null)
    {
        // validation for constraint: int
        if (!is_null($page_count) && !(is_int($page_count) || ctype_digit($page_count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($page_count, true), gettype($page_count)), __LINE__);
        }
        $this->page_count = $page_count;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetHouseListChangesHandlerResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
