<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CompanyProfileChangesData StructType
 * @subpackage Structs
 */
class CompanyProfileChangesData extends AbstractStructBase
{
    /**
     * The inn
     * @var string
     */
    public $inn;
    /**
     * The reporting_period_id
     * @var int
     */
    public $reporting_period_id;
    /**
     * The last_update
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $last_update;
    /**
     * Constructor method for CompanyProfileChangesData
     * @uses CompanyProfileChangesData::setInn()
     * @uses CompanyProfileChangesData::setReporting_period_id()
     * @uses CompanyProfileChangesData::setLast_update()
     * @param string $inn
     * @param int $reporting_period_id
     * @param string $last_update
     */
    public function __construct($inn = null, $reporting_period_id = null, $last_update = null)
    {
        $this
            ->setInn($inn)
            ->setReporting_period_id($reporting_period_id)
            ->setLast_update($last_update);
    }
    /**
     * Get inn value
     * @return string|null
     */
    public function getInn()
    {
        return $this->inn;
    }
    /**
     * Set inn value
     * @param string $inn
     * @return \StructType\CompanyProfileChangesData
     */
    public function setInn($inn = null)
    {
        // validation for constraint: string
        if (!is_null($inn) && !is_string($inn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inn, true), gettype($inn)), __LINE__);
        }
        $this->inn = $inn;
        return $this;
    }
    /**
     * Get reporting_period_id value
     * @return int|null
     */
    public function getReporting_period_id()
    {
        return $this->reporting_period_id;
    }
    /**
     * Set reporting_period_id value
     * @param int $reporting_period_id
     * @return \StructType\CompanyProfileChangesData
     */
    public function setReporting_period_id($reporting_period_id = null)
    {
        // validation for constraint: int
        if (!is_null($reporting_period_id) && !(is_int($reporting_period_id) || ctype_digit($reporting_period_id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($reporting_period_id, true), gettype($reporting_period_id)), __LINE__);
        }
        $this->reporting_period_id = $reporting_period_id;
        return $this;
    }
    /**
     * Get last_update value
     * @return string|null
     */
    public function getLast_update()
    {
        return $this->last_update;
    }
    /**
     * Set last_update value
     * @param string $last_update
     * @return \StructType\CompanyProfileChangesData
     */
    public function setLast_update($last_update = null)
    {
        // validation for constraint: string
        if (!is_null($last_update) && !is_string($last_update)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($last_update, true), gettype($last_update)), __LINE__);
        }
        $this->last_update = $last_update;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CompanyProfileChangesData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
