<?php

namespace EnumType;

/**
 * This class stands for HouseServiceNameEnum EnumType
 * @subpackage Enumerations
 */
class HouseServiceNameEnum
{
    /**
     * Constant for value '1'
     * Meta information extracted from the WSDL
     * - description: Работы (услуги) по управлению многоквартирным домом
     * @return string '1'
     */
    const VALUE_1 = '1';
    /**
     * Constant for value '2'
     * Meta information extracted from the WSDL
     * - description: Работы по содержанию помещений, входящих в состав общего имущества в многоквартирном доме
     * @return string '2'
     */
    const VALUE_2 = '2';
    /**
     * Constant for value '3'
     * Meta information extracted from the WSDL
     * - description: Работы по обеспечению вывоза бытовых отходов
     * @return string '3'
     */
    const VALUE_3 = '3';
    /**
     * Constant for value '4'
     * Meta information extracted from the WSDL
     * - description: Работы по содержанию и ремонту конструктивных элементов (несущих конструкций и ненесущих конструкций) многоквартирных домов
     * @return string '4'
     */
    const VALUE_4 = '4';
    /**
     * Constant for value '5'
     * Meta information extracted from the WSDL
     * - description: Работы по содержанию и ремонту оборудования и систем инженерно-технического обеспечения, входящих в состав общего имущества в
     * многоквартирном доме
     * @return string '5'
     */
    const VALUE_5 = '5';
    /**
     * Constant for value '6'
     * Meta information extracted from the WSDL
     * - description: Работы по содержанию и ремонту мусоропроводов в многоквартирном доме
     * @return string '6'
     */
    const VALUE_6 = '6';
    /**
     * Constant for value '7'
     * Meta information extracted from the WSDL
     * - description: Работы по содержанию и ремонту лифта (лифтов) в многоквартирном доме
     * @return string '7'
     */
    const VALUE_7 = '7';
    /**
     * Constant for value '8'
     * Meta information extracted from the WSDL
     * - description: Работы по обеспечению требований пожарной безопасности
     * @return string '8'
     */
    const VALUE_8 = '8';
    /**
     * Constant for value '9'
     * Meta information extracted from the WSDL
     * - description: Работы по содержанию и ремонту систем дымоудаления и вентиляции
     * @return string '9'
     */
    const VALUE_9 = '9';
    /**
     * Constant for value '10'
     * Meta information extracted from the WSDL
     * - description: Работы по содержанию и ремонту систем внутридомового газового оборудования
     * @return string '10'
     */
    const VALUE_10 = '10';
    /**
     * Constant for value '11'
     * Meta information extracted from the WSDL
     * - description: Обеспечение устранения аварий на внутридомовых инженерных системах в многоквартирном доме
     * @return string '11'
     */
    const VALUE_11 = '11';
    /**
     * Constant for value '12'
     * Meta information extracted from the WSDL
     * - description: Проведение дератизации и дезинсекции помещений, входящих в состав общего имущества в многоквартирном доме
     * @return string '12'
     */
    const VALUE_12 = '12';
    /**
     * Constant for value '13'
     * Meta information extracted from the WSDL
     * - description: Работы по содержанию земельного участка с элементами озеленения и благоустройства, иными объектами, предназначенными для
     * обслуживания и эксплуатации многоквартирного дома
     * @return string '13'
     */
    const VALUE_13 = '13';
    /**
     * Constant for value '14'
     * Meta information extracted from the WSDL
     * - description: Прочая работа (услуга)
     * @return string '14'
     */
    const VALUE_14 = '14';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_1
     * @uses self::VALUE_2
     * @uses self::VALUE_3
     * @uses self::VALUE_4
     * @uses self::VALUE_5
     * @uses self::VALUE_6
     * @uses self::VALUE_7
     * @uses self::VALUE_8
     * @uses self::VALUE_9
     * @uses self::VALUE_10
     * @uses self::VALUE_11
     * @uses self::VALUE_12
     * @uses self::VALUE_13
     * @uses self::VALUE_14
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_1,
            self::VALUE_2,
            self::VALUE_3,
            self::VALUE_4,
            self::VALUE_5,
            self::VALUE_6,
            self::VALUE_7,
            self::VALUE_8,
            self::VALUE_9,
            self::VALUE_10,
            self::VALUE_11,
            self::VALUE_12,
            self::VALUE_13,
            self::VALUE_14,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
