<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NewCompanyProfileData StructType
 * @subpackage Structs
 */
class NewCompanyProfileData extends AbstractStructBase
{
    /**
     * The name_full
     * @var string
     */
    public $name_full;
    /**
     * The name_short
     * @var string
     */
    public $name_short;
    /**
     * The okopf
     * @var string
     */
    public $okopf;
    /**
     * The firstname
     * @var string
     */
    public $firstname;
    /**
     * The surname
     * @var string
     */
    public $surname;
    /**
     * The middlename
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $middlename;
    /**
     * The ogrn
     * @var string
     */
    public $ogrn;
    /**
     * The legal_address
     * @var \StructType\FiasAddress
     */
    public $legal_address;
    /**
     * The actual_address
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\FiasAddress
     */
    public $actual_address;
    /**
     * The post_address
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\FiasAddress
     */
    public $post_address;
    /**
     * The phone
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $phone;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $email;
    /**
     * The site
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $site;
    /**
     * The proportion_sf
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var float
     */
    public $proportion_sf;
    /**
     * The proportion_mo
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var float
     */
    public $proportion_mo;
    /**
     * Constructor method for NewCompanyProfileData
     * @uses NewCompanyProfileData::setName_full()
     * @uses NewCompanyProfileData::setName_short()
     * @uses NewCompanyProfileData::setOkopf()
     * @uses NewCompanyProfileData::setFirstname()
     * @uses NewCompanyProfileData::setSurname()
     * @uses NewCompanyProfileData::setMiddlename()
     * @uses NewCompanyProfileData::setOgrn()
     * @uses NewCompanyProfileData::setLegal_address()
     * @uses NewCompanyProfileData::setActual_address()
     * @uses NewCompanyProfileData::setPost_address()
     * @uses NewCompanyProfileData::setPhone()
     * @uses NewCompanyProfileData::setEmail()
     * @uses NewCompanyProfileData::setSite()
     * @uses NewCompanyProfileData::setProportion_sf()
     * @uses NewCompanyProfileData::setProportion_mo()
     * @param string $name_full
     * @param string $name_short
     * @param string $okopf
     * @param string $firstname
     * @param string $surname
     * @param string $middlename
     * @param string $ogrn
     * @param \StructType\FiasAddress $legal_address
     * @param \StructType\FiasAddress $actual_address
     * @param \StructType\FiasAddress $post_address
     * @param string $phone
     * @param string $email
     * @param string $site
     * @param float $proportion_sf
     * @param float $proportion_mo
     */
    public function __construct($name_full = null, $name_short = null, $okopf = null, $firstname = null, $surname = null, $middlename = null, $ogrn = null, \StructType\FiasAddress $legal_address = null, \StructType\FiasAddress $actual_address = null, \StructType\FiasAddress $post_address = null, $phone = null, $email = null, $site = null, $proportion_sf = null, $proportion_mo = null)
    {
        $this
            ->setName_full($name_full)
            ->setName_short($name_short)
            ->setOkopf($okopf)
            ->setFirstname($firstname)
            ->setSurname($surname)
            ->setMiddlename($middlename)
            ->setOgrn($ogrn)
            ->setLegal_address($legal_address)
            ->setActual_address($actual_address)
            ->setPost_address($post_address)
            ->setPhone($phone)
            ->setEmail($email)
            ->setSite($site)
            ->setProportion_sf($proportion_sf)
            ->setProportion_mo($proportion_mo);
    }
    /**
     * Get name_full value
     * @return string|null
     */
    public function getName_full()
    {
        return $this->name_full;
    }
    /**
     * Set name_full value
     * @param string $name_full
     * @return \StructType\NewCompanyProfileData
     */
    public function setName_full($name_full = null)
    {
        // validation for constraint: string
        if (!is_null($name_full) && !is_string($name_full)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name_full, true), gettype($name_full)), __LINE__);
        }
        $this->name_full = $name_full;
        return $this;
    }
    /**
     * Get name_short value
     * @return string|null
     */
    public function getName_short()
    {
        return $this->name_short;
    }
    /**
     * Set name_short value
     * @param string $name_short
     * @return \StructType\NewCompanyProfileData
     */
    public function setName_short($name_short = null)
    {
        // validation for constraint: string
        if (!is_null($name_short) && !is_string($name_short)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name_short, true), gettype($name_short)), __LINE__);
        }
        $this->name_short = $name_short;
        return $this;
    }
    /**
     * Get okopf value
     * @return string|null
     */
    public function getOkopf()
    {
        return $this->okopf;
    }
    /**
     * Set okopf value
     * @uses \EnumType\Okopf::valueIsValid()
     * @uses \EnumType\Okopf::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $okopf
     * @return \StructType\NewCompanyProfileData
     */
    public function setOkopf($okopf = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Okopf::valueIsValid($okopf)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Okopf', is_array($okopf) ? implode(', ', $okopf) : var_export($okopf, true), implode(', ', \EnumType\Okopf::getValidValues())), __LINE__);
        }
        $this->okopf = $okopf;
        return $this;
    }
    /**
     * Get firstname value
     * @return string|null
     */
    public function getFirstname()
    {
        return $this->firstname;
    }
    /**
     * Set firstname value
     * @param string $firstname
     * @return \StructType\NewCompanyProfileData
     */
    public function setFirstname($firstname = null)
    {
        // validation for constraint: string
        if (!is_null($firstname) && !is_string($firstname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstname, true), gettype($firstname)), __LINE__);
        }
        $this->firstname = $firstname;
        return $this;
    }
    /**
     * Get surname value
     * @return string|null
     */
    public function getSurname()
    {
        return $this->surname;
    }
    /**
     * Set surname value
     * @param string $surname
     * @return \StructType\NewCompanyProfileData
     */
    public function setSurname($surname = null)
    {
        // validation for constraint: string
        if (!is_null($surname) && !is_string($surname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surname, true), gettype($surname)), __LINE__);
        }
        $this->surname = $surname;
        return $this;
    }
    /**
     * Get middlename value
     * @return string|null
     */
    public function getMiddlename()
    {
        return $this->middlename;
    }
    /**
     * Set middlename value
     * @param string $middlename
     * @return \StructType\NewCompanyProfileData
     */
    public function setMiddlename($middlename = null)
    {
        // validation for constraint: string
        if (!is_null($middlename) && !is_string($middlename)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($middlename, true), gettype($middlename)), __LINE__);
        }
        $this->middlename = $middlename;
        return $this;
    }
    /**
     * Get ogrn value
     * @return string|null
     */
    public function getOgrn()
    {
        return $this->ogrn;
    }
    /**
     * Set ogrn value
     * @param string $ogrn
     * @return \StructType\NewCompanyProfileData
     */
    public function setOgrn($ogrn = null)
    {
        // validation for constraint: string
        if (!is_null($ogrn) && !is_string($ogrn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ogrn, true), gettype($ogrn)), __LINE__);
        }
        $this->ogrn = $ogrn;
        return $this;
    }
    /**
     * Get legal_address value
     * @return \StructType\FiasAddress|null
     */
    public function getLegal_address()
    {
        return $this->legal_address;
    }
    /**
     * Set legal_address value
     * @param \StructType\FiasAddress $legal_address
     * @return \StructType\NewCompanyProfileData
     */
    public function setLegal_address(\StructType\FiasAddress $legal_address = null)
    {
        $this->legal_address = $legal_address;
        return $this;
    }
    /**
     * Get actual_address value
     * @return \StructType\FiasAddress|null
     */
    public function getActual_address()
    {
        return $this->actual_address;
    }
    /**
     * Set actual_address value
     * @param \StructType\FiasAddress $actual_address
     * @return \StructType\NewCompanyProfileData
     */
    public function setActual_address(\StructType\FiasAddress $actual_address = null)
    {
        $this->actual_address = $actual_address;
        return $this;
    }
    /**
     * Get post_address value
     * @return \StructType\FiasAddress|null
     */
    public function getPost_address()
    {
        return $this->post_address;
    }
    /**
     * Set post_address value
     * @param \StructType\FiasAddress $post_address
     * @return \StructType\NewCompanyProfileData
     */
    public function setPost_address(\StructType\FiasAddress $post_address = null)
    {
        $this->post_address = $post_address;
        return $this;
    }
    /**
     * Get phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->phone;
    }
    /**
     * Set phone value
     * @param string $phone
     * @return \StructType\NewCompanyProfileData
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        $this->phone = $phone;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\NewCompanyProfileData
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get site value
     * @return string|null
     */
    public function getSite()
    {
        return $this->site;
    }
    /**
     * Set site value
     * @param string $site
     * @return \StructType\NewCompanyProfileData
     */
    public function setSite($site = null)
    {
        // validation for constraint: string
        if (!is_null($site) && !is_string($site)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($site, true), gettype($site)), __LINE__);
        }
        $this->site = $site;
        return $this;
    }
    /**
     * Get proportion_sf value
     * @return float|null
     */
    public function getProportion_sf()
    {
        return $this->proportion_sf;
    }
    /**
     * Set proportion_sf value
     * @param float $proportion_sf
     * @return \StructType\NewCompanyProfileData
     */
    public function setProportion_sf($proportion_sf = null)
    {
        // validation for constraint: float
        if (!is_null($proportion_sf) && !(is_float($proportion_sf) || is_numeric($proportion_sf))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($proportion_sf, true), gettype($proportion_sf)), __LINE__);
        }
        $this->proportion_sf = $proportion_sf;
        return $this;
    }
    /**
     * Get proportion_mo value
     * @return float|null
     */
    public function getProportion_mo()
    {
        return $this->proportion_mo;
    }
    /**
     * Set proportion_mo value
     * @param float $proportion_mo
     * @return \StructType\NewCompanyProfileData
     */
    public function setProportion_mo($proportion_mo = null)
    {
        // validation for constraint: float
        if (!is_null($proportion_mo) && !(is_float($proportion_mo) || is_numeric($proportion_mo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($proportion_mo, true), gettype($proportion_mo)), __LINE__);
        }
        $this->proportion_mo = $proportion_mo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NewCompanyProfileData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
